/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.embedded.EmbeddedProcessStartException;

public interface EmbeddedManagedProcess {
    public ModelControllerClient getModelControllerClient();

    public void start() throws EmbeddedProcessStartException;

    public void stop();

    public String getProcessState();

    public boolean canQueryProcessState();

    public static ClassLoader getTccl() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static void setTccl(final ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(cl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(cl);
                    return null;
                }
            });
        }
    }
}

