/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.io.File;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.core.embedded.logging.EmbeddedLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

final class InitialModuleLoaderFactory {
    private InitialModuleLoaderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleLoader getModuleLoader(File modulePath, String ... systemPackages) {
        if (modulePath == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("modulePath");
        }
        if (!modulePath.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidModulePath(modulePath.getAbsolutePath());
        }
        String oldClassPath = WildFlySecurityManager.getPropertyPrivileged((String)"java.class.path", null);
        try {
            ModuleLoader moduleLoader;
            WildFlySecurityManager.clearPropertyPrivileged((String)"java.class.path");
            WildFlySecurityManager.setPropertyPrivileged((String)"module.path", (String)modulePath.getAbsolutePath());
            StringBuffer packages = new StringBuffer("org.jboss.modules," + InitialModuleLoaderFactory.class.getPackage().getName());
            packages.append(",org.jboss.as.controller.client,org.jboss.dmr");
            if (systemPackages != null) {
                for (String packageName : systemPackages) {
                    packages.append("," + packageName);
                }
            }
            WildFlySecurityManager.setPropertyPrivileged((String)"jboss.modules.system.pkgs", (String)packages.toString());
            ModuleLoader moduleLoader2 = moduleLoader = Module.getBootModuleLoader();
            return moduleLoader2;
        }
        finally {
            WildFlySecurityManager.setPropertyPrivileged((String)"java.class.path", (String)oldClassPath);
        }
    }
}

