/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.PermissionMapperDefinitions;
import org.wildfly.extension.elytron.PrincipalDecoderDefinitions;
import org.wildfly.extension.elytron.PrincipalTransformerDefinitions;
import org.wildfly.extension.elytron.RealmMapperDefinitions;
import org.wildfly.extension.elytron.RegexAttributeDefinitions;
import org.wildfly.extension.elytron.RoleDecoderDefinitions;
import org.wildfly.extension.elytron.RoleMapperDefinitions;

class MapperParser {
    MapperParser() {
    }

    void readMappers(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block58: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "custom-permission-mapper": {
                    ElytronSubsystemParser.readCustomComponent("custom-permission-mapper", parentAddress, reader, operations);
                    continue block58;
                }
                case "logical-permission-mapper": {
                    this.readLogicalPermissionMapper(parentAddress, reader, operations);
                    continue block58;
                }
                case "simple-permission-mapper": {
                    this.readSimplePermissionMapper(parentAddress, reader, operations);
                    continue block58;
                }
                case "constant-permission-mapper": {
                    this.readConstantPermissionMapper(parentAddress, reader, operations);
                    continue block58;
                }
                case "aggregate-principal-decoder": {
                    this.readAggregatePrincipalDecoderElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "concatenating-principal-decoder": {
                    this.readConcatenatingPrincipalDecoderElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "constant-principal-decoder": {
                    this.readConstantPrincipalDecoderElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "custom-principal-decoder": {
                    ElytronSubsystemParser.readCustomComponent("custom-principal-decoder", parentAddress, reader, operations);
                    continue block58;
                }
                case "x500-attribute-principal-decoder": {
                    this.readX500AttributePrincipalDecoderElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "aggregate-principal-transformer": {
                    this.readAggregatePrincipalTransformerElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "chained-principal-transformer": {
                    this.readChainedPrincipalTransformersElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "constant-principal-transformer": {
                    this.readConstantPrincipalTransformerElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "custom-principal-transformer": {
                    ElytronSubsystemParser.readCustomComponent("custom-principal-transformer", parentAddress, reader, operations);
                    continue block58;
                }
                case "regex-principal-transformer": {
                    this.readRegexPrincipalTransformerElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "regex-validating-principal-transformer": {
                    this.readRegexPrincipalTransformerRewriterElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "constant-realm-mapper": {
                    this.readConstantRealmMapperElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "custom-realm-mapper": {
                    ElytronSubsystemParser.readCustomComponent("custom-realm-mapper", parentAddress, reader, operations);
                    continue block58;
                }
                case "simple-regex-realm-mapper": {
                    this.readSimpleRegexRealmMapperElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "mapped-regex-realm-mapper": {
                    this.readMappedRegexRealmMapperElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "custom-role-decoder": {
                    ElytronSubsystemParser.readCustomComponent("custom-role-decoder", parentAddress, reader, operations);
                    continue block58;
                }
                case "simple-role-decoder": {
                    this.readSimpleRoleDecoder(parentAddress, reader, operations);
                    continue block58;
                }
                case "add-prefix-role-mapper": {
                    this.readAddPrefixRoleMapper(parentAddress, reader, operations);
                    continue block58;
                }
                case "add-suffix-role-mapper": {
                    this.readAddSuffixRoleMapper(parentAddress, reader, operations);
                    continue block58;
                }
                case "aggregate-role-mapper": {
                    this.readAggregateRoleMapperElement(parentAddress, reader, operations);
                    continue block58;
                }
                case "constant-role-mapper": {
                    this.readConstantRoleMapper(parentAddress, reader, operations);
                    continue block58;
                }
                case "custom-role-mapper": {
                    ElytronSubsystemParser.readCustomComponent("custom-role-mapper", parentAddress, reader, operations);
                    continue block58;
                }
                case "logical-role-mapper": {
                    this.readLogicalRoleMapper(parentAddress, reader, operations);
                    continue block58;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readLogicalPermissionMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPermissionMapper = new ModelNode();
        addPermissionMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "logical-operation", "left", "right"));
        String name = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block12;
                }
                case "logical-operation": {
                    PermissionMapperDefinitions.LOGICAL_OPERATION.parseAndSetParameter(value, addPermissionMapper, (XMLStreamReader)reader);
                    continue block12;
                }
                case "left": {
                    PermissionMapperDefinitions.LEFT.parseAndSetParameter(value, addPermissionMapper, (XMLStreamReader)reader);
                    continue block12;
                }
                case "right": {
                    PermissionMapperDefinitions.RIGHT.parseAndSetParameter(value, addPermissionMapper, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addPermissionMapper.get("address").set(parentAddress).add("logical-permission-mapper", name);
        operations.add(addPermissionMapper);
    }

    private void readSimplePermissionMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPermissionMapper = new ModelNode();
        addPermissionMapper.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "mapping-mode": {
                    PermissionMapperDefinitions.MAPPING_MODE.parseAndSetParameter(value, addPermissionMapper, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        ModelNode permissionMappings = new ModelNode();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"permission-mapping".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            permissionMappings.add(this.readPermissionMapping(reader));
        }
        addPermissionMapper.get("address").set(parentAddress).add("simple-permission-mapper", name);
        addPermissionMapper.get("permission-mappings").set(permissionMappings);
        operations.add(addPermissionMapper);
    }

    private void readConstantPermissionMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPermissionMapper = new ModelNode();
        addPermissionMapper.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        ModelNode permissions = new ModelNode();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"permission".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            permissions.add(this.readPermission(reader));
        }
        addPermissionMapper.get("address").set(parentAddress).add("constant-permission-mapper", name);
        addPermissionMapper.get("permissions").set(permissions);
        operations.add(addPermissionMapper);
    }

    private ModelNode readPermissionMapping(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode permissionMapping = new ModelNode();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attribute;
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "principals": {
                    for (String principal : reader.getListAttributeValue(i)) {
                        PermissionMapperDefinitions.PRINCIPALS.parseAndAddParameterElement(principal, permissionMapping, (XMLStreamReader)reader);
                    }
                    continue block8;
                }
                case "roles": {
                    for (String role : reader.getListAttributeValue(i)) {
                        PermissionMapperDefinitions.ROLES.parseAndAddParameterElement(role, permissionMapping, (XMLStreamReader)reader);
                    }
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode permissions = new ModelNode();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"permission".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            permissions.add(this.readPermission(reader));
        }
        permissionMapping.get("permissions").set(permissions);
        return permissionMapping;
    }

    private ModelNode readPermission(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode permission = new ModelNode();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "class-name": {
                    ClassLoadingAttributeDefinitions.CLASS_NAME.parseAndSetParameter(value, permission, (XMLStreamReader)reader);
                    continue block12;
                }
                case "module": {
                    ClassLoadingAttributeDefinitions.MODULE.parseAndSetParameter(value, permission, (XMLStreamReader)reader);
                    continue block12;
                }
                case "target-name": {
                    PermissionMapperDefinitions.TARGET_NAME.parseAndSetParameter(value, permission, (XMLStreamReader)reader);
                    continue block12;
                }
                case "action": {
                    PermissionMapperDefinitions.ACTION.parseAndSetParameter(value, permission, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!permission.get("class-name").isDefined()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"class-name"});
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return permission;
    }

    private void readAggregatePrincipalDecoderElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPrincipalDecoder = new ModelNode();
        addPrincipalDecoder.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addPrincipalDecoder.get("address").set(parentAddress).add("aggregate-principal-decoder", name);
        operations.add(addPrincipalDecoder);
        ListAttributeDefinition principalDecoders = PrincipalDecoderDefinitions.getAggregatePrincipalDecoderDefinition().getReferencesAttribute();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"principal-decoder".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String principalDecoderName = reader.getAttributeValue(0);
            principalDecoders.parseAndAddParameterElement(principalDecoderName, addPrincipalDecoder, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readConcatenatingPrincipalDecoderElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPrincipalDecoder = new ModelNode();
        addPrincipalDecoder.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "joiner": {
                    PrincipalDecoderDefinitions.JOINER.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addPrincipalDecoder.get("address").set(parentAddress).add("concatenating-principal-decoder", name);
        operations.add(addPrincipalDecoder);
        StringListAttributeDefinition principalDecoders = PrincipalDecoderDefinitions.PRINCIPAL_DECODERS;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"principal-decoder".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String principalDecoderName = reader.getAttributeValue(0);
            principalDecoders.parseAndAddParameterElement(principalDecoderName, addPrincipalDecoder, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readConstantPrincipalDecoderElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPrincipalDecoder = new ModelNode();
        addPrincipalDecoder.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "constant"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "constant": {
                    PrincipalDecoderDefinitions.CONSTANT.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addPrincipalDecoder.get("address").set(parentAddress).add("constant-principal-decoder", name);
        operations.add(addPrincipalDecoder);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readX500AttributePrincipalDecoderElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPrincipalDecoder = new ModelNode();
        addPrincipalDecoder.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name"));
        String name = null;
        int count = reader.getAttributeCount();
        block22: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block22;
                }
                case "oid": {
                    PrincipalDecoderDefinitions.OID.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block22;
                }
                case "attribute-name": {
                    PrincipalDecoderDefinitions.ATTRIBUTE_NAME.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block22;
                }
                case "joiner": {
                    PrincipalDecoderDefinitions.JOINER.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block22;
                }
                case "start-segment": {
                    PrincipalDecoderDefinitions.START_SEGMENT.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block22;
                }
                case "maximum-segments": {
                    PrincipalDecoderDefinitions.MAXIMUM_SEGMENTS.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block22;
                }
                case "reverse": {
                    PrincipalDecoderDefinitions.REVERSE.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block22;
                }
                case "required-oids": {
                    for (String requiredOid : reader.getListAttributeValue(i)) {
                        PrincipalDecoderDefinitions.REQUIRED_OIDS.parseAndAddParameterElement(requiredOid, addPrincipalDecoder, (XMLStreamReader)reader);
                    }
                    continue block22;
                }
                case "required-attributes": {
                    for (String requiredOid : reader.getListAttributeValue(i)) {
                        PrincipalDecoderDefinitions.REQUIRED_ATTRIBUTES.parseAndAddParameterElement(requiredOid, addPrincipalDecoder, (XMLStreamReader)reader);
                    }
                    continue block22;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addPrincipalDecoder.get("address").set(parentAddress).add("x500-attribute-principal-decoder", name);
        operations.add(addPrincipalDecoder);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readAggregatePrincipalTransformerElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPrincipalTransformer = new ModelNode();
        addPrincipalTransformer.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addPrincipalTransformer.get("address").set(parentAddress).add("aggregate-principal-transformer", name);
        operations.add(addPrincipalTransformer);
        ListAttributeDefinition principalTranformers = PrincipalTransformerDefinitions.getAggregatePrincipalTransformerDefinition().getReferencesAttribute();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"principal-transformer".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String principalTransformerName = reader.getAttributeValue(0);
            principalTranformers.parseAndAddParameterElement(principalTransformerName, addPrincipalTransformer, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readChainedPrincipalTransformersElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPrincipalTransformer = new ModelNode();
        addPrincipalTransformer.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addPrincipalTransformer.get("address").set(parentAddress).add("chained-principal-transformer", name);
        operations.add(addPrincipalTransformer);
        ListAttributeDefinition principalTransformers = PrincipalTransformerDefinitions.getChainedPrincipalTransformerDefinition().getReferencesAttribute();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"principal-transformer".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String principalTransformerName = reader.getAttributeValue(0);
            principalTransformers.parseAndAddParameterElement(principalTransformerName, addPrincipalTransformer, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readConstantPrincipalTransformerElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPrincipalTransformer = new ModelNode();
        addPrincipalTransformer.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "constant"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "constant": {
                    PrincipalTransformerDefinitions.CONSTANT.parseAndSetParameter(value, addPrincipalTransformer, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addPrincipalTransformer.get("address").set(parentAddress).add("constant-principal-transformer", name);
        operations.add(addPrincipalTransformer);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readRegexPrincipalTransformerElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPrincipalTransformer = new ModelNode();
        addPrincipalTransformer.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "pattern", "replacement"));
        String name = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block12;
                }
                case "pattern": {
                    RegexAttributeDefinitions.PATTERN.parseAndSetParameter(value, addPrincipalTransformer, (XMLStreamReader)reader);
                    continue block12;
                }
                case "replacement": {
                    PrincipalTransformerDefinitions.REPLACEMENT.parseAndSetParameter(value, addPrincipalTransformer, (XMLStreamReader)reader);
                    continue block12;
                }
                case "replace-all": {
                    PrincipalTransformerDefinitions.REPLACE_ALL.parseAndSetParameter(value, addPrincipalTransformer, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addPrincipalTransformer.get("address").set(parentAddress).add("regex-principal-transformer", name);
        operations.add(addPrincipalTransformer);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readRegexPrincipalTransformerRewriterElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPrincipalTransformer = new ModelNode();
        addPrincipalTransformer.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "pattern"));
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "pattern": {
                    RegexAttributeDefinitions.PATTERN.parseAndSetParameter(value, addPrincipalTransformer, (XMLStreamReader)reader);
                    continue block10;
                }
                case "match": {
                    PrincipalTransformerDefinitions.MATCH.parseAndSetParameter(value, addPrincipalTransformer, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addPrincipalTransformer.get("address").set(parentAddress).add("regex-validating-principal-transformer", name);
        operations.add(addPrincipalTransformer);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readConstantRealmMapperElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealmMapper = new ModelNode();
        addRealmMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "realm-name"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "realm-name": {
                    RealmMapperDefinitions.REALM_NAME.parseAndSetParameter(value, addRealmMapper, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addRealmMapper.get("address").set(parentAddress).add("constant-realm-mapper", name);
        operations.add(addRealmMapper);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readSimpleRegexRealmMapperElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealmMapper = new ModelNode();
        addRealmMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "pattern"));
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "pattern": {
                    RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP.parseAndSetParameter(value, addRealmMapper, (XMLStreamReader)reader);
                    continue block10;
                }
                case "delegate-realm-mapper": {
                    RealmMapperDefinitions.DELEGATE_REALM_MAPPER.parseAndSetParameter(value, addRealmMapper, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addRealmMapper.get("address").set(parentAddress).add("simple-regex-realm-mapper", name);
        operations.add(addRealmMapper);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readMappedRegexRealmMapperElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealmMapper = new ModelNode();
        addRealmMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "pattern"));
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "pattern": {
                    RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP.parseAndSetParameter(value, addRealmMapper, (XMLStreamReader)reader);
                    continue block10;
                }
                case "delegate-realm-mapper": {
                    RealmMapperDefinitions.DELEGATE_REALM_MAPPER.parseAndSetParameter(value, addRealmMapper, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addRealmMapper.get("address").set(parentAddress).add("mapped-regex-realm-mapper", name);
        operations.add(addRealmMapper);
        ModelNode realmNameMap = addRealmMapper.get("realm-map");
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"realm-mapping".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            this.readRealmMapping(realmNameMap, reader);
        }
        if (!realmNameMap.isDefined()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton("realm-mapping"));
        }
    }

    private void readRealmMapping(ModelNode realmNameMap, XMLExtendedStreamReader reader) throws XMLStreamException {
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("from", "to"));
        String from = null;
        String to = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "from": {
                    from = value;
                    continue block8;
                }
                case "to": {
                    to = value;
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        realmNameMap.add(from, to);
    }

    private void readSimpleRoleDecoder(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleDecoder = new ModelNode();
        addRoleDecoder.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "attribute"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "attribute": {
                    RoleDecoderDefinitions.ATTRIBUTE.parseAndSetParameter(value, addRoleDecoder, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addRoleDecoder.get("address").set(parentAddress).add("simple-role-decoder", name);
        operations.add(addRoleDecoder);
    }

    private void readAddPrefixRoleMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleMapper = new ModelNode();
        addRoleMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "prefix"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "prefix": {
                    RoleMapperDefinitions.PREFIX.parseAndSetParameter(value, addRoleMapper, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addRoleMapper.get("address").set(parentAddress).add("add-prefix-role-mapper", name);
        operations.add(addRoleMapper);
    }

    private void readAddSuffixRoleMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleMapper = new ModelNode();
        addRoleMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "suffix"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "suffix": {
                    RoleMapperDefinitions.SUFFIX.parseAndSetParameter(value, addRoleMapper, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addRoleMapper.get("address").set(parentAddress).add("add-suffix-role-mapper", name);
        operations.add(addRoleMapper);
    }

    private void readAggregateRoleMapperElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleMapper = new ModelNode();
        addRoleMapper.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addRoleMapper.get("address").set(parentAddress).add("aggregate-role-mapper", name);
        operations.add(addRoleMapper);
        ListAttributeDefinition roleMappers = RoleMapperDefinitions.getAggregateRoleMapperDefinition().getReferencesAttribute();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"role-mapper".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String roleMapperName = reader.getAttributeValue(0);
            roleMappers.parseAndAddParameterElement(roleMapperName, addRoleMapper, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readConstantRoleMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleMapper = new ModelNode();
        addRoleMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name"));
        HashSet<String> requiredElements = new HashSet<String>(Arrays.asList("role"));
        String name = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addRoleMapper.get("address").set(parentAddress).add("constant-role-mapper", name);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            requiredElements.remove(localName);
            switch (localName) {
                case "role": {
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
                    String roleName = reader.getAttributeValue(0);
                    RoleMapperDefinitions.ROLES.parseAndAddParameterElement(roleName, addRoleMapper, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
        if (!requiredElements.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, requiredElements);
        }
        operations.add(addRoleMapper);
    }

    private void readLogicalRoleMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleMapper = new ModelNode();
        addRoleMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "logical-operation"));
        String name = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block12;
                }
                case "logical-operation": {
                    RoleMapperDefinitions.LOGICAL_OPERATION.parseAndSetParameter(value, addRoleMapper, (XMLStreamReader)reader);
                    continue block12;
                }
                case "left": {
                    RoleMapperDefinitions.LEFT.parseAndSetParameter(value, addRoleMapper, (XMLStreamReader)reader);
                    continue block12;
                }
                case "right": {
                    RoleMapperDefinitions.RIGHT.parseAndSetParameter(value, addRoleMapper, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addRoleMapper.get("address").set(parentAddress).add("logical-role-mapper", name);
        operations.add(addRoleMapper);
    }

    private void startMappers(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("mappers");
        }
    }

    private boolean writeCustomPermissionMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-permission-mapper")) {
            this.startMappers(started, writer);
            ModelNode principalDecoders = subsystem.require("custom-permission-mapper");
            for (String name : principalDecoders.keys()) {
                ModelNode principalDecoder = principalDecoders.require(name);
                ElytronSubsystemParser.writeCustomComponent("custom-permission-mapper", name, principalDecoder, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeLogicalPermissionMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("logical-permission-mapper")) {
            this.startMappers(started, writer);
            ModelNode permissionMappers = subsystem.require("logical-permission-mapper");
            for (String name : permissionMappers.keys()) {
                ModelNode permissionMapper = permissionMappers.require(name);
                writer.writeStartElement("logical-permission-mapper");
                writer.writeAttribute("name", name);
                PermissionMapperDefinitions.LOGICAL_OPERATION.marshallAsAttribute(permissionMapper, (XMLStreamWriter)writer);
                PermissionMapperDefinitions.LEFT.marshallAsAttribute(permissionMapper, (XMLStreamWriter)writer);
                PermissionMapperDefinitions.RIGHT.marshallAsAttribute(permissionMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeSimplePermissionMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("simple-permission-mapper")) {
            this.startMappers(started, writer);
            ModelNode permissionMappers = subsystem.require("simple-permission-mapper");
            for (String name : permissionMappers.keys()) {
                ModelNode permissionMapper = permissionMappers.require(name);
                writer.writeStartElement("simple-permission-mapper");
                writer.writeAttribute("name", name);
                PermissionMapperDefinitions.MAPPING_MODE.marshallAsAttribute(permissionMapper, false, (XMLStreamWriter)writer);
                if (permissionMapper.hasDefined("permission-mappings")) {
                    for (ModelNode permissionMapping : permissionMapper.get("permission-mappings").asList()) {
                        writer.writeStartElement("permission-mapping");
                        PermissionMapperDefinitions.PRINCIPALS.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)PermissionMapperDefinitions.PRINCIPALS, permissionMapping, false, (XMLStreamWriter)writer);
                        PermissionMapperDefinitions.ROLES.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)PermissionMapperDefinitions.ROLES, permissionMapping, false, (XMLStreamWriter)writer);
                        if (permissionMapping.hasDefined("permissions")) {
                            for (ModelNode permission : permissionMapping.get("permissions").asList()) {
                                writer.writeStartElement("permission");
                                ClassLoadingAttributeDefinitions.CLASS_NAME.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                                ClassLoadingAttributeDefinitions.MODULE.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                                PermissionMapperDefinitions.TARGET_NAME.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                                PermissionMapperDefinitions.ACTION.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                                writer.writeEndElement();
                            }
                        }
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeConstantPermissionMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("constant-permission-mapper")) {
            this.startMappers(started, writer);
            ModelNode permissionMappers = subsystem.require("constant-permission-mapper");
            for (String name : permissionMappers.keys()) {
                ModelNode permissionMapper = permissionMappers.require(name);
                writer.writeStartElement("constant-permission-mapper");
                writer.writeAttribute("name", name);
                if (permissionMapper.hasDefined("permissions")) {
                    for (ModelNode permission : permissionMapper.get("permissions").asList()) {
                        writer.writeStartElement("permission");
                        ClassLoadingAttributeDefinitions.CLASS_NAME.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                        ClassLoadingAttributeDefinitions.MODULE.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                        PermissionMapperDefinitions.TARGET_NAME.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                        PermissionMapperDefinitions.ACTION.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeAggregatePrincipalDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-principal-decoder")) {
            this.startMappers(started, writer);
            ModelNode principalDecoders = subsystem.require("aggregate-principal-decoder");
            for (String name : principalDecoders.keys()) {
                ModelNode principalDecoder = principalDecoders.require(name);
                writer.writeStartElement("aggregate-principal-decoder");
                writer.writeAttribute("name", name);
                List principalDecoderReferences = principalDecoder.get("principal-decoders").asList();
                for (ModelNode currentReference : principalDecoderReferences) {
                    writer.writeStartElement("principal-decoder");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeConcatenatingPrincipalDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("concatenating-principal-decoder")) {
            this.startMappers(started, writer);
            ModelNode principalDecoders = subsystem.require("concatenating-principal-decoder");
            for (String name : principalDecoders.keys()) {
                ModelNode principalDecoder = principalDecoders.require(name);
                writer.writeStartElement("concatenating-principal-decoder");
                writer.writeAttribute("name", name);
                PrincipalDecoderDefinitions.JOINER.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                List principalDecoderReferences = principalDecoder.get("principal-decoders").asList();
                for (ModelNode currentReference : principalDecoderReferences) {
                    writer.writeStartElement("principal-decoder");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeConstantPrincipalDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("constant-principal-decoder")) {
            this.startMappers(started, writer);
            ModelNode principalDecoders = subsystem.require("constant-principal-decoder");
            for (String name : principalDecoders.keys()) {
                ModelNode principalDecoder = principalDecoders.require(name);
                writer.writeStartElement("constant-principal-decoder");
                writer.writeAttribute("name", name);
                PrincipalDecoderDefinitions.CONSTANT.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomPrincipalDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-principal-decoder")) {
            this.startMappers(started, writer);
            ModelNode principalDecoders = subsystem.require("custom-principal-decoder");
            for (String name : principalDecoders.keys()) {
                ModelNode principalDecoder = principalDecoders.require(name);
                ElytronSubsystemParser.writeCustomComponent("custom-principal-decoder", name, principalDecoder, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeX500AttributePrincipalDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("x500-attribute-principal-decoder")) {
            this.startMappers(started, writer);
            ModelNode principalDecoders = subsystem.require("x500-attribute-principal-decoder");
            for (String name : principalDecoders.keys()) {
                ModelNode principalDecoder = principalDecoders.require(name);
                writer.writeStartElement("x500-attribute-principal-decoder");
                writer.writeAttribute("name", name);
                PrincipalDecoderDefinitions.OID.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                PrincipalDecoderDefinitions.ATTRIBUTE_NAME.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                PrincipalDecoderDefinitions.JOINER.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                PrincipalDecoderDefinitions.START_SEGMENT.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                PrincipalDecoderDefinitions.MAXIMUM_SEGMENTS.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                PrincipalDecoderDefinitions.REVERSE.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                PrincipalDecoderDefinitions.REQUIRED_OIDS.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)PrincipalDecoderDefinitions.REQUIRED_OIDS, principalDecoder, false, (XMLStreamWriter)writer);
                PrincipalDecoderDefinitions.REQUIRED_ATTRIBUTES.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)PrincipalDecoderDefinitions.REQUIRED_ATTRIBUTES, principalDecoder, false, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeAggregatePrincipalTransformers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-principal-transformer")) {
            this.startMappers(started, writer);
            ModelNode principalTransformers = subsystem.require("aggregate-principal-transformer");
            for (String name : principalTransformers.keys()) {
                ModelNode principalTransformer = principalTransformers.require(name);
                writer.writeStartElement("aggregate-principal-transformer");
                writer.writeAttribute("name", name);
                List principalTransformerReferences = principalTransformer.get("principal-transformers").asList();
                for (ModelNode currentReference : principalTransformerReferences) {
                    writer.writeStartElement("principal-transformer");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeChainedPrincipalTransformers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("chained-principal-transformer")) {
            this.startMappers(started, writer);
            ModelNode principalTransformers = subsystem.require("chained-principal-transformer");
            for (String name : principalTransformers.keys()) {
                ModelNode principalTransformer = principalTransformers.require(name);
                writer.writeStartElement("chained-principal-transformer");
                writer.writeAttribute("name", name);
                List principalTransformerReferences = principalTransformer.get("principal-transformers").asList();
                for (ModelNode currentReference : principalTransformerReferences) {
                    writer.writeStartElement("principal-transformer");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomPrincipalTransformers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-principal-transformer")) {
            this.startMappers(started, writer);
            ModelNode transformers = subsystem.require("custom-principal-transformer");
            for (String name : transformers.keys()) {
                ModelNode realm = transformers.require(name);
                ElytronSubsystemParser.writeCustomComponent("custom-principal-transformer", name, realm, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeConstantPrincipalTransformers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("constant-principal-transformer")) {
            this.startMappers(started, writer);
            ModelNode principalTransformers = subsystem.require("constant-principal-transformer");
            for (String name : principalTransformers.keys()) {
                ModelNode principalTransformer = principalTransformers.require(name);
                writer.writeStartElement("constant-principal-transformer");
                writer.writeAttribute("name", name);
                PrincipalTransformerDefinitions.CONSTANT.marshallAsAttribute(principalTransformer, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeRegexPrincipalTransformers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("regex-principal-transformer")) {
            this.startMappers(started, writer);
            ModelNode principalTransformers = subsystem.require("regex-principal-transformer");
            for (String name : principalTransformers.keys()) {
                ModelNode principalTransformer = principalTransformers.require(name);
                writer.writeStartElement("regex-principal-transformer");
                writer.writeAttribute("name", name);
                RegexAttributeDefinitions.PATTERN.marshallAsAttribute(principalTransformer, (XMLStreamWriter)writer);
                PrincipalTransformerDefinitions.REPLACEMENT.marshallAsAttribute(principalTransformer, (XMLStreamWriter)writer);
                PrincipalTransformerDefinitions.REPLACE_ALL.marshallAsAttribute(principalTransformer, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeRegexValidatingPrincipalTransformer(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("regex-validating-principal-transformer")) {
            this.startMappers(started, writer);
            ModelNode principalTransformers = subsystem.require("regex-validating-principal-transformer");
            for (String name : principalTransformers.keys()) {
                ModelNode principalTransformer = principalTransformers.require(name);
                writer.writeStartElement("regex-validating-principal-transformer");
                writer.writeAttribute("name", name);
                RegexAttributeDefinitions.PATTERN.marshallAsAttribute(principalTransformer, (XMLStreamWriter)writer);
                PrincipalTransformerDefinitions.MATCH.marshallAsAttribute(principalTransformer, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomRealmMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-realm-mapper")) {
            this.startMappers(started, writer);
            ModelNode realmMappers = subsystem.require("custom-realm-mapper");
            for (String name : realmMappers.keys()) {
                ModelNode realmMapper = realmMappers.require(name);
                ElytronSubsystemParser.writeCustomComponent("custom-realm-mapper", name, realmMapper, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeConstantRealmMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("constant-realm-mapper")) {
            this.startMappers(started, writer);
            ModelNode realmMappers = subsystem.require("constant-realm-mapper");
            for (String name : realmMappers.keys()) {
                ModelNode realmMapper = realmMappers.require(name);
                writer.writeStartElement("constant-realm-mapper");
                writer.writeAttribute("name", name);
                RealmMapperDefinitions.REALM_NAME.marshallAsAttribute(realmMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeSimpleRegexRealmMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("simple-regex-realm-mapper")) {
            this.startMappers(started, writer);
            ModelNode realmMappers = subsystem.require("simple-regex-realm-mapper");
            for (String name : realmMappers.keys()) {
                ModelNode realmMapper = realmMappers.require(name);
                writer.writeStartElement("simple-regex-realm-mapper");
                writer.writeAttribute("name", name);
                RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP.marshallAsAttribute(realmMapper, (XMLStreamWriter)writer);
                RealmMapperDefinitions.DELEGATE_REALM_MAPPER.marshallAsAttribute(realmMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeMapRegexRealmMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("mapped-regex-realm-mapper")) {
            this.startMappers(started, writer);
            ModelNode realmMappers = subsystem.require("mapped-regex-realm-mapper");
            for (String name : realmMappers.keys()) {
                ModelNode realmMapper = realmMappers.require(name);
                writer.writeStartElement("mapped-regex-realm-mapper");
                writer.writeAttribute("name", name);
                RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP.marshallAsAttribute(realmMapper, (XMLStreamWriter)writer);
                RealmMapperDefinitions.DELEGATE_REALM_MAPPER.marshallAsAttribute(realmMapper, (XMLStreamWriter)writer);
                RealmMapperDefinitions.REALM_REALM_MAP.marshallAsElement(realmMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomRoleDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-role-decoder")) {
            this.startMappers(started, writer);
            ModelNode roleDecoders = subsystem.require("custom-role-decoder");
            for (String name : roleDecoders.keys()) {
                ModelNode roleDecoder = roleDecoders.require(name);
                ElytronSubsystemParser.writeCustomComponent("custom-role-decoder", name, roleDecoder, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeSimpleRoleDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("simple-role-decoder")) {
            this.startMappers(started, writer);
            ModelNode roleDecoders = subsystem.require("simple-role-decoder");
            for (String name : roleDecoders.keys()) {
                ModelNode roleDecoder = roleDecoders.require(name);
                writer.writeStartElement("simple-role-decoder");
                writer.writeAttribute("name", name);
                RoleDecoderDefinitions.ATTRIBUTE.marshallAsAttribute(roleDecoder, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeAddPrefixRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("add-prefix-role-mapper")) {
            this.startMappers(started, writer);
            ModelNode roleMappers = subsystem.require("add-prefix-role-mapper");
            for (String name : roleMappers.keys()) {
                ModelNode roleMapper = roleMappers.require(name);
                writer.writeStartElement("add-prefix-role-mapper");
                writer.writeAttribute("name", name);
                RoleMapperDefinitions.PREFIX.marshallAsAttribute(roleMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeAddSuffixRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("add-suffix-role-mapper")) {
            this.startMappers(started, writer);
            ModelNode roleMappers = subsystem.require("add-suffix-role-mapper");
            for (String name : roleMappers.keys()) {
                ModelNode roleMapper = roleMappers.require(name);
                writer.writeStartElement("add-suffix-role-mapper");
                writer.writeAttribute("name", name);
                RoleMapperDefinitions.SUFFIX.marshallAsAttribute(roleMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeAggregateRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-role-mapper")) {
            this.startMappers(started, writer);
            ModelNode roleMappers = subsystem.require("aggregate-role-mapper");
            for (String name : roleMappers.keys()) {
                ModelNode roleMapper = roleMappers.require(name);
                writer.writeStartElement("aggregate-role-mapper");
                writer.writeAttribute("name", name);
                List roleMapperReferences = roleMapper.get("role-mappers").asList();
                for (ModelNode currentReference : roleMapperReferences) {
                    writer.writeStartElement("role-mapper");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeConstantRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("constant-role-mapper")) {
            this.startMappers(started, writer);
            ModelNode roleMappers = subsystem.require("constant-role-mapper");
            for (String name : roleMappers.keys()) {
                ModelNode roleMapper = roleMappers.require(name);
                writer.writeStartElement("constant-role-mapper");
                writer.writeAttribute("name", name);
                for (ModelNode role : roleMapper.require("roles").asList()) {
                    writer.writeStartElement("role");
                    writer.writeAttribute("name", role.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-role-mapper")) {
            this.startMappers(started, writer);
            ModelNode roleMappers = subsystem.require("custom-role-mapper");
            for (String name : roleMappers.keys()) {
                ModelNode roleMapper = roleMappers.require(name);
                ElytronSubsystemParser.writeCustomComponent("custom-role-mapper", name, roleMapper, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeLogicalRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("logical-role-mapper")) {
            this.startMappers(started, writer);
            ModelNode roleMappers = subsystem.require("logical-role-mapper");
            for (String name : roleMappers.keys()) {
                ModelNode roleMapper = roleMappers.require(name);
                writer.writeStartElement("logical-role-mapper");
                writer.writeAttribute("name", name);
                RoleMapperDefinitions.LOGICAL_OPERATION.marshallAsAttribute(roleMapper, (XMLStreamWriter)writer);
                RoleMapperDefinitions.LEFT.marshallAsAttribute(roleMapper, (XMLStreamWriter)writer);
                RoleMapperDefinitions.RIGHT.marshallAsAttribute(roleMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    void writeMappers(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean mappersStarted = false;
        mappersStarted |= this.writeCustomPermissionMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeLogicalPermissionMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeSimplePermissionMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeConstantPermissionMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeAggregatePrincipalDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeConcatenatingPrincipalDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeConstantPrincipalDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomPrincipalDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeX500AttributePrincipalDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeAggregatePrincipalTransformers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeChainedPrincipalTransformers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeConstantPrincipalTransformers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomPrincipalTransformers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeRegexPrincipalTransformers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeRegexValidatingPrincipalTransformer(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeConstantRealmMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomRealmMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeSimpleRegexRealmMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeMapRegexRealmMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomRoleDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeSimpleRoleDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeAddPrefixRoleMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeAddSuffixRoleMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeAggregateRoleMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeConstantRoleMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomRoleMappers(mappersStarted, subsystem, writer);
        if (mappersStarted |= this.writeLogicalRoleMappers(mappersStarted, subsystem, writer)) {
            writer.writeEndElement();
        }
    }
}

