/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.elytron.tool.wrapper;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.wildfly.core.elytron.tool.wrapper._private.ElytronToolWrapperMessages;

public class ElytronToolScriptWrapper {
    private static final String ELYTRON_TOOL_SCRIPT = "elytron-tool.[sh|bat|ps1]";

    public static void main(String[] args) {
        try {
            File jarPath = new File(ElytronToolScriptWrapper.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            File parentDir = jarPath.getParentFile();
            if (parentDir != null) {
                String parentDirPath = parentDir.getAbsolutePath();
                StringBuilder elytronToolScriptCommand = new StringBuilder(parentDirPath + File.separator + "elytron-tool.[sh|bat|ps1] ");
                Arrays.stream(args).forEach(arg -> elytronToolScriptCommand.append(arg + " "));
                System.out.println(ElytronToolWrapperMessages.ROOT_LOGGER.redirectToScript(elytronToolScriptCommand.toString()));
                return;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        System.out.println(ElytronToolWrapperMessages.ROOT_LOGGER.redirectToScriptSimple());
    }
}

