/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.authz.MappedRoleMapper;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;

class RoleMapperDefinitions {
    static final SimpleAttributeDefinition SUFFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("suffix", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PREFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("prefix", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition LEFT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("left", ModelType.STRING, true).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.role-mapper", "org.wildfly.security.role-mapper")).build();
    static final SimpleAttributeDefinition RIGHT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("right", ModelType.STRING, true).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.role-mapper", "org.wildfly.security.role-mapper")).build();
    static final SimpleAttributeDefinition LOGICAL_OPERATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("logical-operation", ModelType.STRING, false).setAllowExpression(true)).setAllowedValues(new String[]{"and", "minus", "or", "xor"})).setValidator((ParameterValidator)EnumValidator.create(LogicalOperation.class, (boolean)false, (boolean)true))).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleMapAttributeDefinition ROLE_MAPPING_MAP = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("role-map", ModelType.LIST, false).setMinSize(1)).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition KEEP_MAPPED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("keep-mapped", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition KEEP_NON_MAPPED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("keep-non-mapped", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final StringListAttributeDefinition ROLES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("roles").setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).setXmlName("role")).setAttributeMarshaller(AttributeMarshallers.STRING_LIST_NAMED_ELEMENT)).setAttributeParser(AttributeParsers.STRING_LIST_NAMED_ELEMENT)).build();
    private static final AggregateComponentDefinition<RoleMapper> AGGREGATE_ROLE_MAPPER = AggregateComponentDefinition.create(RoleMapper.class, "aggregate-role-mapper", "role-mappers", Capabilities.ROLE_MAPPER_RUNTIME_CAPABILITY, r -> RoleMapper.aggregate((RoleMapper[])r));

    RoleMapperDefinitions() {
    }

    static ResourceDefinition getMappedRoleMapperDefinition() {
        RoleMapperAddHandler add = new RoleMapperAddHandler(new AttributeDefinition[]{ROLE_MAPPING_MAP, KEEP_MAPPED, KEEP_NON_MAPPED}){

            @Override
            protected TrivialService.ValueSupplier<RoleMapper> getValueSupplier(OperationContext context, ModelNode model) throws OperationFailedException {
                ModelNode roleMappingMapNode = ROLE_MAPPING_MAP.resolveModelAttribute(context, model);
                boolean keepMapped = KEEP_MAPPED.resolveModelAttribute(context, model).asBoolean();
                boolean keepNonMapped = KEEP_NON_MAPPED.resolveModelAttribute(context, model).asBoolean();
                Set keys = roleMappingMapNode.keys();
                LinkedHashMap roleMappingMap = new LinkedHashMap(keys.size());
                for (String s : keys) {
                    List currentList = roleMappingMapNode.require(s).asList();
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    for (ModelNode m : currentList) {
                        set.add(m.asString());
                    }
                    roleMappingMap.put(s, set);
                }
                MappedRoleMapper roleMapper = MappedRoleMapper.builder().setRoleMap(roleMappingMap).build();
                Roles keyRoles = Roles.fromSet(roleMappingMap.keySet());
                if (keepMapped && keepNonMapped) {
                    return () -> roleMapper.or(RoleMapper.IDENTITY_ROLE_MAPPER);
                }
                if (keepMapped) {
                    return () -> roleMapper.or(delegate -> delegate.and(keyRoles));
                }
                if (keepNonMapped) {
                    return () -> roleMapper.or(delegate -> delegate.minus(keyRoles));
                }
                return () -> roleMapper;
            }
        };
        return new RoleMapperResourceDefinition("mapped-role-mapper", add, new AttributeDefinition[]{ROLE_MAPPING_MAP, KEEP_MAPPED, KEEP_NON_MAPPED});
    }

    static AggregateComponentDefinition<RoleMapper> getAggregateRoleMapperDefinition() {
        return AGGREGATE_ROLE_MAPPER;
    }

    static ResourceDefinition getAddSuffixRoleMapperDefinition() {
        RoleMapperAddHandler add = new RoleMapperAddHandler(new AttributeDefinition[]{SUFFIX}){

            @Override
            protected TrivialService.ValueSupplier<RoleMapper> getValueSupplier(OperationContext context, ModelNode model) throws OperationFailedException {
                String suffix = SUFFIX.resolveModelAttribute(context, model).asString();
                return () -> r -> r.addSuffix(suffix);
            }
        };
        return new RoleMapperResourceDefinition("add-suffix-role-mapper", add, new AttributeDefinition[]{SUFFIX});
    }

    static ResourceDefinition getAddPrefixRoleMapperDefinition() {
        RoleMapperAddHandler add = new RoleMapperAddHandler(new AttributeDefinition[]{PREFIX}){

            @Override
            protected TrivialService.ValueSupplier<RoleMapper> getValueSupplier(OperationContext context, ModelNode model) throws OperationFailedException {
                String prefix = PREFIX.resolveModelAttribute(context, model).asString();
                return () -> r -> r.addPrefix(prefix);
            }
        };
        return new RoleMapperResourceDefinition("add-prefix-role-mapper", add, new AttributeDefinition[]{PREFIX});
    }

    static ResourceDefinition getLogicalRoleMapperDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{LOGICAL_OPERATION, LEFT, RIGHT};
        RoleMapperAddHandler add = new RoleMapperAddHandler(attributes){

            @Override
            protected ServiceBuilder<RoleMapper> installService(OperationContext context, ServiceName roleMapperName, ModelNode model) throws OperationFailedException {
                InjectedValue leftRoleMapperInjector = new InjectedValue();
                InjectedValue rightRoleMapperInjector = new InjectedValue();
                LogicalOperation operation = LogicalOperation.valueOf(LogicalOperation.class, LOGICAL_OPERATION.resolveModelAttribute(context, model).asString().toUpperCase(Locale.ENGLISH));
                TrivialService<RoleMapper> roleMapperService = new TrivialService<RoleMapper>(() -> operation.create((RoleMapper)leftRoleMapperInjector.getValue(), (RoleMapper)rightRoleMapperInjector.getValue()));
                ServiceTarget serviceTarget = context.getServiceTarget();
                ServiceBuilder serviceBuilder = serviceTarget.addService(roleMapperName, roleMapperService);
                String leftName = LEFT.resolveModelAttribute(context, model).asStringOrNull();
                if (leftName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.role-mapper", (String)leftName), RoleMapper.class), RoleMapper.class, (Injector)leftRoleMapperInjector);
                } else {
                    leftRoleMapperInjector.inject((Object)RoleMapper.IDENTITY_ROLE_MAPPER);
                }
                String rightName = RIGHT.resolveModelAttribute(context, model).asStringOrNull();
                if (rightName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.role-mapper", (String)rightName), RoleMapper.class), RoleMapper.class, (Injector)rightRoleMapperInjector);
                } else {
                    rightRoleMapperInjector.inject((Object)RoleMapper.IDENTITY_ROLE_MAPPER);
                }
                return serviceBuilder;
            }
        };
        return new RoleMapperResourceDefinition("logical-role-mapper", add, attributes);
    }

    static ResourceDefinition getConstantRoleMapperDefinition() {
        RoleMapperAddHandler add = new RoleMapperAddHandler(new AttributeDefinition[]{ROLES}){

            @Override
            protected TrivialService.ValueSupplier<RoleMapper> getValueSupplier(OperationContext context, ModelNode model) throws OperationFailedException {
                List rolesList = ROLES.unwrap((ExpressionResolver)context, model);
                Roles roles = Roles.fromSet(new HashSet(rolesList));
                return () -> r -> roles;
            }
        };
        return new RoleMapperResourceDefinition("constant-role-mapper", add, new AttributeDefinition[]{ROLES});
    }

    private static enum LogicalOperation {
        AND((left, right) -> left.and(right)),
        MINUS((left, right) -> left.minus(right)),
        OR((left, right) -> left.or(right)),
        XOR((left, right) -> left.xor(right));

        private final BinaryOperator<RoleMapper> operation;

        private LogicalOperation(BinaryOperator<RoleMapper> operation) {
            this.operation = operation;
        }

        RoleMapper create(RoleMapper left, RoleMapper right) {
            return (RoleMapper)this.operation.apply(left, right);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    private static class RoleMapperAddHandler
    extends BaseAddHandler {
        private RoleMapperAddHandler(AttributeDefinition ... attributes) {
            super(Capabilities.ROLE_MAPPER_RUNTIME_CAPABILITY, attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            RuntimeCapability runtimeCapability = Capabilities.ROLE_MAPPER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName roleMapperName = runtimeCapability.getCapabilityServiceName(RoleMapper.class);
            ElytronDefinition.commonDependencies(this.installService(context, roleMapperName, model)).setInitialMode(ServiceController.Mode.LAZY).install();
        }

        protected ServiceBuilder<RoleMapper> installService(OperationContext context, ServiceName roleMapperName, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            TrivialService<RoleMapper> roleMapperService = new TrivialService<RoleMapper>(this.getValueSupplier(context, model));
            return serviceTarget.addService(roleMapperName, roleMapperService);
        }

        protected TrivialService.ValueSupplier<RoleMapper> getValueSupplier(OperationContext context, ModelNode model) throws OperationFailedException {
            return () -> null;
        }
    }

    private static class RoleMapperResourceDefinition
    extends SimpleResourceDefinition {
        private final String pathKey;
        private final AttributeDefinition[] attributes;

        RoleMapperResourceDefinition(String pathKey, AbstractAddStepHandler add, AttributeDefinition ... attributes) {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new TrivialCapabilityServiceRemoveHandler(add, Capabilities.ROLE_MAPPER_RUNTIME_CAPABILITY)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.ROLE_MAPPER_RUNTIME_CAPABILITY}));
            this.pathKey = pathKey;
            this.attributes = attributes;
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            if (this.attributes != null && this.attributes.length > 0) {
                ElytronReloadRequiredWriteAttributeHandler write = new ElytronReloadRequiredWriteAttributeHandler(this.attributes);
                for (AttributeDefinition current : this.attributes) {
                    resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
                }
            }
        }
    }
}

