/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.SSLContextResource;
import org.wildfly.extension.elytron.SSLSessionDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities.PrincipalTransformer;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.keystore.AliasFilter;
import org.wildfly.security.keystore.FilteringKeyStore;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.Protocol;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.ssl.X509CRLExtendedTrustManager;

class SSLDefinitions {
    private static final BooleanSupplier IS_FIPS = SSLDefinitions.getFipsSupplier();
    static final ServiceUtil<SSLContext> SERVER_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY, "server-ssl-context", SSLContext.class);
    static final ServiceUtil<SSLContext> CLIENT_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY, "client-ssl-context", SSLContext.class);
    static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROVIDER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-name", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("providers", ModelType.STRING, true).setAllowExpression(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEYSTORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-store", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition ALIAS_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias-filter", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.ssl-context")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PRE_REALM_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pre-realm-principal-transformer", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.principal-transformer", "org.wildfly.security.ssl-context")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition POST_REALM_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("post-realm-principal-transformer", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.principal-transformer", "org.wildfly.security.ssl-context")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition FINAL_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("final-principal-transformer", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.principal-transformer", "org.wildfly.security.ssl-context")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition REALM_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm-mapper", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.realm-mapper", "org.wildfly.security.ssl-context")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CIPHER_SUITE_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cipher-suite-filter", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).setValidator((ParameterValidator)new CipherSuiteFilterValidator())).setDefaultValue(new ModelNode("DEFAULT"))).build();
    private static final String[] ALLOWED_PROTOCOLS = new String[]{"SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
    static final StringListAttributeDefinition PROTOCOLS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("protocols").setAllowExpression(true)).setMinSize(1)).setRequired(false)).setAllowedValues(ALLOWED_PROTOCOLS)).setValidator((ParameterValidator)new StringValuesValidator(ALLOWED_PROTOCOLS))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition WANT_CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("want-client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition NEED_CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("need-client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition AUTHENTICATION_OPTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-optional", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition USE_CIPHER_SUITES_ORDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-cipher-suites-order", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MAXIMUM_SESSION_CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-session-cache-size", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).setValidator((ParameterValidator)new IntRangeValidator(-1))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SESSION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-timeout", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).setValidator((ParameterValidator)new IntRangeValidator(-1))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition WRAP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("wrap", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition KEY_MANAGER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-manager", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.key-manager", "org.wildfly.security.ssl-context")).setRestartAllServices()).setAllowExpression(false)).build();
    static final SimpleAttributeDefinition TRUST_MANAGER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("trust-manager", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.trust-manager", "org.wildfly.security.ssl-context")).setRestartAllServices()).setAllowExpression(false)).build();
    private static final SimpleAttributeDefinition MAXIMUM_CERT_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-cert-path", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(5))).setValidator((ParameterValidator)new IntRangeValidator(1))).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition CERTIFICATE_REVOCATION_LIST = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("certificate-revocation-list", new AttributeDefinition[]{FileAttributeDefinitions.PATH, FileAttributeDefinitions.RELATIVE_TO, MAXIMUM_CERT_PATH}).setRequired(false)).setRestartAllServices()).build();
    private static SimpleAttributeDefinition ACTIVE_SESSION_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("active-session-count", ModelType.INT).setStorageRuntime()).build();

    SSLDefinitions() {
    }

    static ResourceDefinition getKeyManagerDefinition() {
        final ServiceUtil<KeyManager> KEY_MANAGER_UTIL = ServiceUtil.newInstance(Capabilities.KEY_MANAGER_RUNTIME_CAPABILITY, "key-manager", KeyManager.class);
        StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("key-manager");
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.key-manager")).setAllowExpression(false)).setRestartAllServices()).build();
        final SimpleAttributeDefinition keystoreDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(KEYSTORE).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.key-manager")).setAllowExpression(false)).setRestartAllServices()).build();
        final ObjectTypeAttributeDefinition credentialReferenceDefinition = CredentialReference.getAttributeDefinition((boolean)true);
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALGORITHM, providersDefinition, PROVIDER_NAME, keystoreDefinition, ALIAS_FILTER, credentialReferenceDefinition};
        TrivialAddHandler<KeyManager> add = new TrivialAddHandler<KeyManager>(KeyManager.class, attributes, Capabilities.KEY_MANAGER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<KeyManager> getValueSupplier(ServiceBuilder<KeyManager> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String algorithmName = ALGORITHM.resolveModelAttribute(context, model).asStringOrNull();
                String providerName = PROVIDER_NAME.resolveModelAttribute(context, model).asStringOrNull();
                String providersName = providersDefinition.resolveModelAttribute(context, model).asStringOrNull();
                InjectedValue providersInjector = new InjectedValue();
                if (providersName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providersName), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                String keyStoreName = keystoreDefinition.resolveModelAttribute(context, model).asStringOrNull();
                InjectedValue keyStoreInjector = new InjectedValue();
                if (keyStoreName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStoreName), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                String aliasFilter = ALIAS_FILTER.resolveModelAttribute(context, model).asStringOrNull();
                String algorithm = algorithmName != null ? algorithmName : KeyManagerFactory.getDefaultAlgorithm();
                ExceptionSupplier credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)credentialReferenceDefinition, (ModelNode)model, serviceBuilder);
                DelegatingKeyManager delegatingKeyManager = new DelegatingKeyManager();
                return () -> {
                    void var13_21;
                    KeyManager[] keyManagers;
                    Object[] providers = (Provider[])providersInjector.getOptionalValue();
                    KeyManagerFactory keyManagerFactory = null;
                    if (providers != null) {
                        for (Provider provider : providers) {
                            if (providerName != null && !providerName.equals(provider.getName())) continue;
                            try {
                                keyManagerFactory = KeyManagerFactory.getInstance(algorithm, provider);
                                break;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                // empty catch block
                            }
                        }
                        if (keyManagerFactory == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateManagerFactory(KeyManagerFactory.class.getSimpleName(), algorithm);
                        }
                    } else {
                        try {
                            keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new StartException((Throwable)e);
                        }
                    }
                    try {
                        CredentialSource cs = (CredentialSource)credentialSourceSupplier.get();
                        if (cs == null) {
                            throw new StartException((Throwable)ElytronSubsystemMessages.ROOT_LOGGER.keyStorePasswordCannotBeResolved(keyStoreName));
                        }
                        char[] password = ((ClearPassword)((PasswordCredential)cs.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword();
                        KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                        if (aliasFilter != null) {
                            keyStore = FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)aliasFilter));
                        }
                        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                            ElytronSubsystemMessages.ROOT_LOGGER.tracef("KeyManager supplying:  providers = %s  provider = %s  algorithm = %s  keyManagerFactory = %s  keyStoreName = %s  aliasFilter = %s  keyStore = %s  keyStoreSize = %d  password (of item) = %b", new Object[]{Arrays.toString(providers), providerName, algorithm, keyManagerFactory, keyStoreName, aliasFilter, keyStore, keyStore.size(), password != null});
                        }
                        keyManagerFactory.init(keyStore, password);
                    }
                    catch (StartException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new StartException((Throwable)e);
                    }
                    KeyManager[] keyManagerArray = keyManagers = keyManagerFactory.getKeyManagers();
                    int n = keyManagerArray.length;
                    boolean bl = false;
                    while (var13_21 < n) {
                        KeyManager keyManager = keyManagerArray[var13_21];
                        if (keyManager instanceof X509ExtendedKeyManager) {
                            delegatingKeyManager.setKeyManager((X509ExtendedKeyManager)keyManager);
                            return delegatingKeyManager;
                        }
                        ++var13_21;
                    }
                    throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFound(X509ExtendedKeyManager.class.getSimpleName());
                };
            }
        };
        ElytronRuntimeOnlyHandler init = new ElytronRuntimeOnlyHandler(){

            protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName keyStoreName = KEY_MANAGER_UTIL.serviceName(operation);
                ServiceController<KeyManager> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(false), keyStoreName, KeyManager.class);
                try {
                    serviceContainer.getService().stop(null);
                    serviceContainer.getService().start(null);
                }
                catch (Exception e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
        };
        return TrivialResourceDefinition.builder().setPathKey("key-manager").setAddHandler(add).setAttributes(attributes).setRuntimeCapabilities(Capabilities.KEY_MANAGER_RUNTIME_CAPABILITY).addOperation((OperationDefinition)new SimpleOperationDefinitionBuilder("init", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setRuntimeOnly().build(), init).build();
    }

    static ResourceDefinition getTrustManagerDefinition() {
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.trust-manager")).setAllowExpression(false)).setRestartAllServices()).build();
        final SimpleAttributeDefinition keystoreDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(KEYSTORE).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.trust-manager")).setAllowExpression(false)).setRestartAllServices()).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALGORITHM, providersDefinition, PROVIDER_NAME, keystoreDefinition, ALIAS_FILTER, CERTIFICATE_REVOCATION_LIST};
        TrivialAddHandler<TrustManager> add = new TrivialAddHandler<TrustManager>(TrustManager.class, attributes, Capabilities.TRUST_MANAGER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<TrustManager> getValueSupplier(ServiceBuilder<TrustManager> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String algorithmName = ALGORITHM.resolveModelAttribute(context, model).asStringOrNull();
                String providerName = PROVIDER_NAME.resolveModelAttribute(context, model).asStringOrNull();
                String providerLoader = providersDefinition.resolveModelAttribute(context, model).asStringOrNull();
                InjectedValue providersInjector = new InjectedValue();
                if (providerLoader != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providerLoader), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                String keyStoreName = keystoreDefinition.resolveModelAttribute(context, model).asStringOrNull();
                InjectedValue keyStoreInjector = new InjectedValue();
                if (keyStoreName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStoreName), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                String aliasFilter = ALIAS_FILTER.resolveModelAttribute(context, model).asStringOrNull();
                String algorithm = algorithmName != null ? algorithmName : TrustManagerFactory.getDefaultAlgorithm();
                ModelNode crlNode = CERTIFICATE_REVOCATION_LIST.resolveModelAttribute(context, model);
                if (crlNode.isDefined()) {
                    return this.createX509CRLExtendedTrustManager(serviceBuilder, context, algorithm, providerName, (InjectedValue<Provider[]>)providersInjector, (InjectedValue<KeyStore>)keyStoreInjector, crlNode);
                }
                return () -> {
                    TrustManager[] trustManagers;
                    Object[] providers = (Provider[])providersInjector.getOptionalValue();
                    TrustManagerFactory trustManagerFactory = this.createTrustManagerFactory((Provider[])providers, providerName, algorithm);
                    KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                    try {
                        if (aliasFilter != null) {
                            keyStore = FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)aliasFilter));
                        }
                        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                            ElytronSubsystemMessages.ROOT_LOGGER.tracef("TrustManager supplying:  providers = %s  provider = %s  algorithm = %s  trustManagerFactory = %s  keyStoreName = %s  keyStore = %s  aliasFilter = %s  keyStoreSize = %d", new Object[]{Arrays.toString(providers), providerName, algorithm, trustManagerFactory, keyStoreName, keyStore, aliasFilter, keyStore.size()});
                        }
                        trustManagerFactory.init((KeyStore)keyStoreInjector.getOptionalValue());
                    }
                    catch (Exception e) {
                        throw new StartException((Throwable)e);
                    }
                    for (TrustManager trustManager : trustManagers = trustManagerFactory.getTrustManagers()) {
                        if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
                        return trustManager;
                    }
                    throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFound(X509ExtendedKeyManager.class.getSimpleName());
                };
            }

            private TrivialService.ValueSupplier<TrustManager> createX509CRLExtendedTrustManager(ServiceBuilder<TrustManager> serviceBuilder, OperationContext context, String algorithm, String providerName, InjectedValue<Provider[]> providersInjector, InjectedValue<KeyStore> keyStoreInjector, ModelNode crlNode) throws OperationFailedException {
                String crlPath = FileAttributeDefinitions.PATH.resolveModelAttribute(context, crlNode).asStringOrNull();
                String crlRelativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, crlNode).asStringOrNull();
                int certPath = MAXIMUM_CERT_PATH.resolveModelAttribute(context, crlNode).asInt();
                InjectedValue pathManagerInjector = new InjectedValue();
                if (crlPath != null && crlRelativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManagerInjector);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(crlRelativeTo));
                }
                return () -> {
                    TrustManagerFactory trustManagerFactory = this.createTrustManagerFactory((Provider[])providersInjector.getOptionalValue(), providerName, algorithm);
                    KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                    if (crlPath != null) {
                        try {
                            X509CRLExtendedTrustManager trustManager = new X509CRLExtendedTrustManager(keyStore, trustManagerFactory, (InputStream)new FileInputStream(this.resolveFileLocation(crlPath, crlRelativeTo, (InjectedValue<PathManager>)pathManagerInjector)), certPath, null);
                            return this.createReloadableX509CRLTrustManager(crlPath, crlRelativeTo, certPath, (InjectedValue<PathManager>)pathManagerInjector, trustManagerFactory, keyStore, trustManager);
                        }
                        catch (FileNotFoundException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToAccessCRL(e);
                        }
                    }
                    return new X509CRLExtendedTrustManager(keyStore, trustManagerFactory, null, certPath, null);
                };
            }

            private TrustManager createReloadableX509CRLTrustManager(final String crlPath, final String crlRelativeTo, final int certPath, final InjectedValue<PathManager> pathManagerInjector, final TrustManagerFactory trustManagerFactory, final KeyStore keyStore, final X509CRLExtendedTrustManager trustManager) {
                return new ReloadableX509ExtendedTrustManager(){
                    private volatile X509ExtendedTrustManager delegate;
                    private AtomicBoolean reloading;
                    {
                        this.delegate = trustManager;
                        this.reloading = new AtomicBoolean();
                    }

                    @Override
                    void reload() {
                        if (this.reloading.compareAndSet(false, true)) {
                            try {
                                this.delegate = new X509CRLExtendedTrustManager(keyStore, trustManagerFactory, (InputStream)new FileInputStream(this.resolveFileLocation(crlPath, crlRelativeTo, (InjectedValue<PathManager>)pathManagerInjector)), certPath, null);
                            }
                            catch (FileNotFoundException cause) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToReloadCRL(cause);
                            }
                            finally {
                                this.reloading.lazySet(false);
                            }
                        }
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
                        this.delegate.checkClientTrusted(x509Certificates, s, socket);
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
                        this.delegate.checkServerTrusted(x509Certificates, s, socket);
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
                        this.delegate.checkClientTrusted(x509Certificates, s, sslEngine);
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
                        this.delegate.checkServerTrusted(x509Certificates, s, sslEngine);
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        this.delegate.checkClientTrusted(x509Certificates, s);
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        this.delegate.checkServerTrusted(x509Certificates, s);
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return this.delegate.getAcceptedIssuers();
                    }
                };
            }

            private File resolveFileLocation(String path, String relativeTo, InjectedValue<PathManager> pathManagerInjector) {
                File resolvedPath;
                if (relativeTo != null) {
                    PathManager pathManager = (PathManager)pathManagerInjector.getValue();
                    resolvedPath = new File(pathManager.resolveRelativePathEntry(path, relativeTo));
                } else {
                    resolvedPath = new File(path);
                }
                return resolvedPath;
            }

            private TrustManagerFactory createTrustManagerFactory(Provider[] providers, String providerName, String algorithm) throws StartException {
                Object trustManagerFactory = null;
                if (providers != null) {
                    for (Provider current : providers) {
                        if (providerName != null && !providerName.equals(current.getName())) continue;
                        try {
                            return TrustManagerFactory.getInstance(algorithm, current);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            // empty catch block
                        }
                    }
                    if (trustManagerFactory == null) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateManagerFactory(TrustManagerFactory.class.getSimpleName(), algorithm);
                    }
                }
                try {
                    return TrustManagerFactory.getInstance(algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new StartException((Throwable)e);
                }
            }
        };
        StandardResourceDescriptionResolver resolver = ElytronExtension.getResourceDescriptionResolver("trust-manager");
        return TrivialResourceDefinition.builder().setPathKey("trust-manager").setResourceDescriptionResolver((ResourceDescriptionResolver)resolver).setAddHandler(add).setAttributes(attributes).setRuntimeCapabilities(Capabilities.TRUST_MANAGER_RUNTIME_CAPABILITY).addOperation((OperationDefinition)new SimpleOperationDefinitionBuilder("reload-certificate-revocation-list", (ResourceDescriptionResolver)resolver).setRuntimeOnly().build(), new ElytronRuntimeOnlyHandler(){

            protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName serviceName = Capabilities.TRUST_MANAGER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue()).getCapabilityServiceName();
                ServiceController<TrustManager> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(true), serviceName, TrustManager.class);
                ServiceController.State serviceState = serviceContainer.getState();
                if (serviceState != ServiceController.State.UP) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serviceName, serviceState);
                }
                TrustManager trustManager = (TrustManager)serviceContainer.getValue();
                if (!(trustManager instanceof ReloadableX509ExtendedTrustManager)) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToReloadCRLNotReloadable();
                }
                ((ReloadableX509ExtendedTrustManager)trustManager).reload();
            }
        }).build();
    }

    private static ResourceDefinition createSSLContextDefinition(String pathKey, final boolean server, AbstractAddStepHandler addHandler, AttributeDefinition[] attributes, boolean serverOrHostController) {
        TrivialResourceDefinition.Builder builder = TrivialResourceDefinition.builder().setPathKey(pathKey).setAddHandler(addHandler).setAttributes(attributes).setRuntimeCapabilities(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY);
        if (serverOrHostController) {
            builder.addReadOnlyAttribute((AttributeDefinition)ACTIVE_SESSION_COUNT, new SSLContextRuntimeHandler(){

                @Override
                protected void performRuntime(ModelNode result, ModelNode operation, SSLContext sslContext) throws OperationFailedException {
                    SSLSessionContext sessionContext = server ? sslContext.getServerSessionContext() : sslContext.getClientSessionContext();
                    int sum = 0;
                    for (byte[] b : Collections.list(sessionContext.getIds())) {
                        int i = 1;
                        sum += i;
                    }
                    result.set(sum);
                }

                @Override
                protected ServiceUtil<SSLContext> getSSLContextServiceUtil() {
                    return server ? SERVER_SERVICE_UTIL : CLIENT_SERVICE_UTIL;
                }
            }).addChild((ResourceDefinition)new SSLSessionDefinition(server));
        }
        return builder.build();
    }

    private static <T> InjectedValue<T> addDependency(String baseName, SimpleAttributeDefinition attribute, Class<T> type, ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
        String dynamicNameElement = attribute.resolveModelAttribute(context, model).asStringOrNull();
        InjectedValue injectedValue = new InjectedValue();
        if (dynamicNameElement != null) {
            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)baseName, (String)dynamicNameElement), type), type, (Injector)injectedValue);
        }
        return injectedValue;
    }

    static ResourceDefinition getServerSSLContextDefinition(boolean serverOrHostController) {
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.ssl-context")).setAllowExpression(false)).setRestartAllServices()).build();
        SimpleAttributeDefinition keyManagerDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(KEY_MANAGER).setRequired(true)).setRestartAllServices()).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{CIPHER_SUITE_FILTER, PROTOCOLS, SECURITY_DOMAIN, WANT_CLIENT_AUTH, NEED_CLIENT_AUTH, AUTHENTICATION_OPTIONAL, USE_CIPHER_SUITES_ORDER, MAXIMUM_SESSION_CACHE_SIZE, SESSION_TIMEOUT, WRAP, keyManagerDefinition, TRUST_MANAGER, PRE_REALM_PRINCIPAL_TRANSFORMER, POST_REALM_PRINCIPAL_TRANSFORMER, FINAL_PRINCIPAL_TRANSFORMER, REALM_MAPPER, providersDefinition, PROVIDER_NAME};
        TrivialAddHandler<SSLContext> add = new TrivialAddHandler<SSLContext>(SSLContext.class, attributes, Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<SSLContext> getValueSupplier(ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue securityDomainInjector = SSLDefinitions.addDependency("org.wildfly.security.security-domain", SECURITY_DOMAIN, SecurityDomain.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue keyManagerInjector = SSLDefinitions.addDependency("org.wildfly.security.key-manager", KEY_MANAGER, KeyManager.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue trustManagerInjector = SSLDefinitions.addDependency("org.wildfly.security.trust-manager", TRUST_MANAGER, TrustManager.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue preRealmPrincipalTransformerInjector = SSLDefinitions.addDependency("org.wildfly.security.principal-transformer", PRE_REALM_PRINCIPAL_TRANSFORMER, PrincipalTransformer.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue postRealmPrincipalTransformerInjector = SSLDefinitions.addDependency("org.wildfly.security.principal-transformer", POST_REALM_PRINCIPAL_TRANSFORMER, PrincipalTransformer.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue finalPrincipalTransformerInjector = SSLDefinitions.addDependency("org.wildfly.security.principal-transformer", FINAL_PRINCIPAL_TRANSFORMER, PrincipalTransformer.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue realmMapperInjector = SSLDefinitions.addDependency("org.wildfly.security.realm-mapper", REALM_MAPPER, RealmMapper.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue providersInjector = SSLDefinitions.addDependency("org.wildfly.security.providers", providersDefinition, Provider[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                String providerName = PROVIDER_NAME.resolveModelAttribute(context, model).asStringOrNull();
                List protocols = PROTOCOLS.unwrap((ExpressionResolver)context, model);
                String cipherSuiteFilter = CIPHER_SUITE_FILTER.resolveModelAttribute(context, model).asStringOrNull();
                boolean wantClientAuth = WANT_CLIENT_AUTH.resolveModelAttribute(context, model).asBoolean();
                boolean needClientAuth = NEED_CLIENT_AUTH.resolveModelAttribute(context, model).asBoolean();
                boolean authenticationOptional = AUTHENTICATION_OPTIONAL.resolveModelAttribute(context, model).asBoolean();
                boolean useCipherSuitesOrder = USE_CIPHER_SUITES_ORDER.resolveModelAttribute(context, model).asBoolean();
                int maximumSessionCacheSize = MAXIMUM_SESSION_CACHE_SIZE.resolveModelAttribute(context, model).asInt();
                int sessionTimeout = SESSION_TIMEOUT.resolveModelAttribute(context, model).asInt();
                boolean wrap = WRAP.resolveModelAttribute(context, model).asBoolean();
                return () -> {
                    SecurityDomain securityDomain = (SecurityDomain)securityDomainInjector.getOptionalValue();
                    X509ExtendedKeyManager keyManager = SSLDefinitions.getX509KeyManager((KeyManager)keyManagerInjector.getOptionalValue());
                    X509ExtendedTrustManager trustManager = SSLDefinitions.getX509TrustManager((TrustManager)trustManagerInjector.getOptionalValue());
                    PrincipalTransformer preRealmRewriter = (PrincipalTransformer)preRealmPrincipalTransformerInjector.getOptionalValue();
                    PrincipalTransformer postRealmRewriter = (PrincipalTransformer)postRealmPrincipalTransformerInjector.getOptionalValue();
                    PrincipalTransformer finalRewriter = (PrincipalTransformer)finalPrincipalTransformerInjector.getOptionalValue();
                    RealmMapper realmMapper = (RealmMapper)realmMapperInjector.getOptionalValue();
                    Object[] providers = SSLDefinitions.filterProviders((Provider[])providersInjector.getOptionalValue(), providerName);
                    SSLContextBuilder builder = new SSLContextBuilder();
                    if (securityDomain != null) {
                        builder.setSecurityDomain(securityDomain);
                    }
                    if (keyManager != null) {
                        builder.setKeyManager(keyManager);
                    }
                    if (trustManager != null) {
                        builder.setTrustManager((X509TrustManager)trustManager);
                    }
                    if (providers != null) {
                        builder.setProviderSupplier(() -> 6.lambda$null$0((Provider[])providers));
                    }
                    if (cipherSuiteFilter != null) {
                        builder.setCipherSuiteSelector(CipherSuiteSelector.fromString((String)cipherSuiteFilter));
                    }
                    if (!protocols.isEmpty()) {
                        ArrayList<Protocol> list = new ArrayList<Protocol>();
                        for (String protocol : protocols) {
                            Protocol forName = Protocol.forName((String)protocol);
                            list.add(forName);
                        }
                        builder.setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(list)));
                    }
                    if (preRealmRewriter != null || postRealmRewriter != null || finalRewriter != null || realmMapper != null) {
                        MechanismConfiguration.Builder mechBuilder = MechanismConfiguration.builder();
                        if (preRealmRewriter != null) {
                            mechBuilder.setPreRealmRewriter((Function)preRealmRewriter);
                        }
                        if (postRealmRewriter != null) {
                            mechBuilder.setPostRealmRewriter((Function)postRealmRewriter);
                        }
                        if (finalRewriter != null) {
                            mechBuilder.setFinalRewriter((Function)finalRewriter);
                        }
                        if (realmMapper != null) {
                            mechBuilder.setRealmMapper(realmMapper);
                        }
                        builder.setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)mechBuilder.build()));
                    }
                    builder.setWantClientAuth(wantClientAuth).setNeedClientAuth(needClientAuth).setAuthenticationOptional(authenticationOptional).setUseCipherSuitesOrder(useCipherSuitesOrder).setSessionCacheSize(maximumSessionCacheSize).setSessionTimeout(sessionTimeout).setWrap(wrap);
                    if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                        ElytronSubsystemMessages.ROOT_LOGGER.tracef("ServerSSLContext supplying:  securityDomain = %s  keyManager = %s  trustManager = %s  providers = %s  cipherSuiteFilter = %s  protocols = %s  wantClientAuth = %s  needClientAuth = %s  authenticationOptional = %s  maximumSessionCacheSize = %s  sessionTimeout = %s wrap = %s", new Object[]{securityDomain, keyManager, trustManager, Arrays.toString(providers), cipherSuiteFilter, Arrays.toString(protocols.toArray()), wantClientAuth, needClientAuth, authenticationOptional, maximumSessionCacheSize, sessionTimeout, wrap});
                    }
                    try {
                        return (SSLContext)builder.build().create();
                    }
                    catch (GeneralSecurityException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }

            protected Resource createResource(OperationContext context) {
                SSLContextResource resource = new SSLContextResource(Resource.Factory.create(), true);
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
                return resource;
            }

            @Override
            protected void installedForResource(ServiceController<SSLContext> serviceController, Resource resource) {
                ((SSLContextResource)resource).setSSLContextServiceController(serviceController);
            }

            private static /* synthetic */ Provider[] lambda$null$0(Provider[] providers) {
                return providers;
            }
        };
        return SSLDefinitions.createSSLContextDefinition("server-ssl-context", true, add, attributes, serverOrHostController);
    }

    static ResourceDefinition getClientSSLContextDefinition(boolean serverOrHostController) {
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.ssl-context")).setAllowExpression(false)).setRestartAllServices()).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{CIPHER_SUITE_FILTER, PROTOCOLS, KEY_MANAGER, TRUST_MANAGER, providersDefinition, PROVIDER_NAME};
        TrivialAddHandler<SSLContext> add = new TrivialAddHandler<SSLContext>(SSLContext.class, attributes, Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<SSLContext> getValueSupplier(ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue keyManagerInjector = SSLDefinitions.addDependency("org.wildfly.security.key-manager", KEY_MANAGER, KeyManager.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue trustManagerInjector = SSLDefinitions.addDependency("org.wildfly.security.trust-manager", TRUST_MANAGER, TrustManager.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue providersInjector = SSLDefinitions.addDependency("org.wildfly.security.providers", providersDefinition, Provider[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                String providerName = PROVIDER_NAME.resolveModelAttribute(context, model).asStringOrNull();
                List protocols = PROTOCOLS.unwrap((ExpressionResolver)context, model);
                String cipherSuiteFilter = CIPHER_SUITE_FILTER.resolveModelAttribute(context, model).asStringOrNull();
                return () -> {
                    X509ExtendedKeyManager keyManager = SSLDefinitions.getX509KeyManager((KeyManager)keyManagerInjector.getOptionalValue());
                    X509ExtendedTrustManager trustManager = SSLDefinitions.getX509TrustManager((TrustManager)trustManagerInjector.getOptionalValue());
                    Object[] providers = SSLDefinitions.filterProviders((Provider[])providersInjector.getOptionalValue(), providerName);
                    SSLContextBuilder builder = new SSLContextBuilder();
                    if (keyManager != null) {
                        builder.setKeyManager(keyManager);
                    }
                    if (trustManager != null) {
                        builder.setTrustManager((X509TrustManager)trustManager);
                    }
                    if (providers != null) {
                        builder.setProviderSupplier(() -> 7.lambda$null$0((Provider[])providers));
                    }
                    if (cipherSuiteFilter != null) {
                        builder.setCipherSuiteSelector(CipherSuiteSelector.fromString((String)cipherSuiteFilter));
                    }
                    if (!protocols.isEmpty()) {
                        ArrayList<Protocol> list = new ArrayList<Protocol>();
                        for (String protocol : protocols) {
                            Protocol forName = Protocol.forName((String)protocol);
                            list.add(forName);
                        }
                        builder.setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(list)));
                    }
                    builder.setClientMode(true).setWrap(false);
                    if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                        ElytronSubsystemMessages.ROOT_LOGGER.tracef("ClientSSLContext supplying:  keyManager = %s  trustManager = %s  providers = %s  cipherSuiteFilter = %s  protocols = %s", new Object[]{keyManager, trustManager, Arrays.toString(providers), cipherSuiteFilter, Arrays.toString(protocols.toArray())});
                    }
                    try {
                        return (SSLContext)builder.build().create();
                    }
                    catch (GeneralSecurityException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }

            protected Resource createResource(OperationContext context) {
                SSLContextResource resource = new SSLContextResource(Resource.Factory.create(), false);
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
                return resource;
            }

            @Override
            protected void installedForResource(ServiceController<SSLContext> serviceController, Resource resource) {
                ((SSLContextResource)resource).setSSLContextServiceController(serviceController);
            }

            private static /* synthetic */ Provider[] lambda$null$0(Provider[] providers) {
                return providers;
            }
        };
        return SSLDefinitions.createSSLContextDefinition("client-ssl-context", false, add, attributes, serverOrHostController);
    }

    private static Provider[] filterProviders(Provider[] all, String provider) {
        if (provider == null || all == null) {
            return all;
        }
        ArrayList<Provider> list = new ArrayList<Provider>();
        for (Provider current : all) {
            if (!provider.equals(current.getName())) continue;
            list.add(current);
        }
        return list.toArray(new Provider[0]);
    }

    private static X509ExtendedKeyManager getX509KeyManager(KeyManager keyManager) throws StartException {
        if (keyManager == null) {
            return null;
        }
        if (keyManager instanceof X509ExtendedKeyManager) {
            X509ExtendedKeyManager x509KeyManager = (X509ExtendedKeyManager)keyManager;
            if (x509KeyManager instanceof DelegatingKeyManager && IS_FIPS.getAsBoolean()) {
                ElytronSubsystemMessages.ROOT_LOGGER.trace("FIPS enabled on JVM, unwrapping KeyManager");
                x509KeyManager = (X509ExtendedKeyManager)((DelegatingKeyManager)x509KeyManager).delegating.get();
            }
            return x509KeyManager;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.invalidTypeInjected(X509ExtendedKeyManager.class.getSimpleName());
    }

    private static X509ExtendedTrustManager getX509TrustManager(TrustManager trustManager) throws StartException {
        if (trustManager == null) {
            return null;
        }
        if (trustManager instanceof X509ExtendedTrustManager) {
            return (X509ExtendedTrustManager)trustManager;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.invalidTypeInjected(X509ExtendedTrustManager.class.getSimpleName());
    }

    private static BooleanSupplier getFipsSupplier() {
        try {
            Class<?> providerClazz = SSLDefinitions.class.getClassLoader().loadClass("com.sun.net.ssl.internal.ssl.Provider");
            Method isFipsMethod = providerClazz.getMethod("isFIPS", new Class[0]);
            return () -> {
                Object isFips;
                try {
                    isFips = isFipsMethod.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    ElytronSubsystemMessages.ROOT_LOGGER.trace("Unable to invoke com.sun.net.ssl.internal.ssl.Provider.isFIPS() method.", e);
                    return false;
                }
                return isFips != null && isFips instanceof Boolean ? (Boolean)isFips : false;
            };
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            ElytronSubsystemMessages.ROOT_LOGGER.trace("Unable to find com.sun.net.ssl.internal.ssl.Provider.isFIPS() method.", e);
            return Boolean.FALSE::booleanValue;
        }
    }

    static abstract class SSLContextRuntimeHandler
    extends ElytronRuntimeOnlyHandler {
        SSLContextRuntimeHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName serviceName = this.getSSLContextServiceUtil().serviceName(operation);
            ServiceController<SSLContext> serviceController = ElytronExtension.getRequiredService(context.getServiceRegistry(false), serviceName, SSLContext.class);
            ServiceController.State serviceState = serviceController.getState();
            if (serviceState != ServiceController.State.UP) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serviceName, serviceState);
            }
            this.performRuntime(context.getResult(), operation, (SSLContext)serviceController.getService().getValue());
        }

        protected abstract void performRuntime(ModelNode var1, ModelNode var2, SSLContext var3) throws OperationFailedException;

        protected abstract ServiceUtil<SSLContext> getSSLContextServiceUtil();
    }

    private static class DelegatingKeyManager
    extends X509ExtendedKeyManager {
        private final AtomicReference<X509ExtendedKeyManager> delegating = new AtomicReference();

        private DelegatingKeyManager() {
        }

        private void setKeyManager(X509ExtendedKeyManager keyManager) {
            this.delegating.set(keyManager);
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            return this.delegating.get().getClientAliases(s, principals);
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return this.delegating.get().chooseClientAlias(strings, principals, socket);
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            return this.delegating.get().getServerAliases(s, principals);
        }

        @Override
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return this.delegating.get().chooseServerAlias(s, principals, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            return this.delegating.get().getCertificateChain(s);
        }

        @Override
        public PrivateKey getPrivateKey(String s) {
            return this.delegating.get().getPrivateKey(s);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return this.delegating.get().chooseEngineClientAlias(keyType, issuers, engine);
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            return this.delegating.get().chooseEngineServerAlias(keyType, issuers, engine);
        }
    }

    private static abstract class ReloadableX509ExtendedTrustManager
    extends X509ExtendedTrustManager {
        private ReloadableX509ExtendedTrustManager() {
        }

        abstract void reload();
    }

    static class CipherSuiteFilterValidator
    extends ModelTypeValidator {
        CipherSuiteFilterValidator() {
            super(ModelType.STRING, true, true, false);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined()) {
                try {
                    CipherSuiteSelector.fromString((String)value.asString());
                }
                catch (IllegalArgumentException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidCipherSuiteFilter(e, e.getLocalizedMessage());
                }
            }
        }
    }

    static class StringValuesValidator
    extends ModelTypeValidator
    implements AllowedValuesValidator {
        private List<ModelNode> allowedValues = new ArrayList<ModelNode>();

        StringValuesValidator(String ... values) {
            super(ModelType.STRING);
            for (String value : values) {
                this.allowedValues.add(new ModelNode().set(value));
            }
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined() && !this.allowedValues.contains(value)) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidValue(value.asString(), parameterName, this.allowedValues));
            }
        }

        public List<ModelNode> getAllowedValues() {
            return this.allowedValues;
        }
    }
}

