/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;

final class TrivialResourceDefinition
extends SimpleResourceDefinition {
    private final String pathKey;
    private final RuntimeCapability<?> firstCapability;
    private final AttributeDefinition[] attributes;
    private final Map<OperationDefinition, OperationStepHandler> operations;
    private final Map<AttributeDefinition, OperationStepHandler> readOnlyAttributes;
    private final List<ResourceDefinition> children;

    private TrivialResourceDefinition(String pathKey, ResourceDescriptionResolver resourceDescriptionResolver, AbstractAddStepHandler add, AttributeDefinition[] attributes, Map<AttributeDefinition, OperationStepHandler> readOnlyAttributes, Map<OperationDefinition, OperationStepHandler> operations, List<ResourceDefinition> children, RuntimeCapability<?>[] runtimeCapabilities) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), resourceDescriptionResolver).setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new TrivialCapabilityServiceRemoveHandler(add, runtimeCapabilities)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(runtimeCapabilities));
        this.pathKey = pathKey;
        this.firstCapability = runtimeCapabilities[0];
        this.attributes = attributes;
        this.readOnlyAttributes = readOnlyAttributes;
        this.operations = operations;
        this.children = children;
    }

    TrivialResourceDefinition(String pathKey, ResourceDescriptionResolver resourceDescriptionResolver, AbstractAddStepHandler add, AttributeDefinition[] attributes, RuntimeCapability<?> ... runtimeCapabilities) {
        this(pathKey, resourceDescriptionResolver, add, attributes, (Map<AttributeDefinition, OperationStepHandler>)null, (Map<OperationDefinition, OperationStepHandler>)null, (List<ResourceDefinition>)null, runtimeCapabilities);
    }

    TrivialResourceDefinition(String pathKey, AbstractAddStepHandler add, AttributeDefinition[] attributes, RuntimeCapability<?> ... runtimeCapabilities) {
        this(pathKey, (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey), add, attributes, (Map<AttributeDefinition, OperationStepHandler>)null, (Map<OperationDefinition, OperationStepHandler>)null, (List<ResourceDefinition>)null, runtimeCapabilities);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        if (this.attributes != null && this.attributes.length > 0) {
            ElytronReloadRequiredWriteAttributeHandler writeHandler = new ElytronReloadRequiredWriteAttributeHandler(this.attributes);
            for (AttributeDefinition current : this.attributes) {
                resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)writeHandler);
            }
        }
        if (this.readOnlyAttributes != null) {
            for (Map.Entry<AttributeDefinition, OperationStepHandler> entry : this.readOnlyAttributes.entrySet()) {
                resourceRegistration.registerReadOnlyAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.operations != null) {
            for (Map.Entry<OperationDefinition, OperationStepHandler> entry : this.operations.entrySet()) {
                resourceRegistration.registerOperationHandler(entry.getKey(), entry.getValue());
            }
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        if (this.children != null) {
            for (ResourceDefinition child : this.children) {
                resourceRegistration.registerSubModel(child);
            }
        }
    }

    public AttributeDefinition[] getAttributes() {
        return this.attributes;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private String pathKey;
        private ResourceDescriptionResolver resourceDescriptionResolver;
        private AbstractAddStepHandler addHandler;
        private AttributeDefinition[] attributes;
        private Map<AttributeDefinition, OperationStepHandler> readOnlyAttributes;
        private Map<OperationDefinition, OperationStepHandler> operations;
        private RuntimeCapability<?>[] runtimeCapabilities;
        private List<ResourceDefinition> children;

        Builder() {
        }

        Builder setPathKey(String pathKey) {
            this.pathKey = pathKey;
            return this;
        }

        Builder setResourceDescriptionResolver(ResourceDescriptionResolver resourceDescriptionResolver) {
            this.resourceDescriptionResolver = resourceDescriptionResolver;
            return this;
        }

        Builder setAddHandler(AbstractAddStepHandler addHandler) {
            this.addHandler = addHandler;
            return this;
        }

        Builder setAttributes(AttributeDefinition ... attributes) {
            this.attributes = attributes;
            return this;
        }

        Builder addReadOnlyAttribute(AttributeDefinition attribute, OperationStepHandler handler) {
            if (this.readOnlyAttributes == null) {
                this.readOnlyAttributes = new HashMap<AttributeDefinition, OperationStepHandler>();
            }
            this.readOnlyAttributes.put(attribute, handler);
            return this;
        }

        Builder addOperation(OperationDefinition operation, OperationStepHandler handler) {
            if (this.operations == null) {
                this.operations = new HashMap<OperationDefinition, OperationStepHandler>();
            }
            this.operations.put(operation, handler);
            return this;
        }

        Builder setRuntimeCapabilities(RuntimeCapability<?> ... runtimeCapabilities) {
            this.runtimeCapabilities = runtimeCapabilities;
            return this;
        }

        Builder addChild(ResourceDefinition child) {
            if (this.children == null) {
                this.children = new ArrayList<ResourceDefinition>();
            }
            this.children.add(child);
            return this;
        }

        ResourceDefinition build() {
            ResourceDescriptionResolver resourceDescriptionResolver = this.resourceDescriptionResolver != null ? this.resourceDescriptionResolver : ElytronExtension.getResourceDescriptionResolver(this.pathKey);
            return new TrivialResourceDefinition(this.pathKey, resourceDescriptionResolver, this.addHandler, this.attributes, this.readOnlyAttributes, this.operations, this.children, this.runtimeCapabilities);
        }
    }
}

