/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.SimplePermissionMapper;
import org.wildfly.security.permission.InvalidPermissionClassException;
import org.wildfly.security.permission.PermissionUtil;
import org.wildfly.security.permission.PermissionVerifier;

class PermissionMapperDefinitions {
    static final SimpleAttributeDefinition LEFT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("left", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.permission-mapper", "org.wildfly.security.permission-mapper", true)).build();
    static final SimpleAttributeDefinition RIGHT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("right", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.permission-mapper", "org.wildfly.security.permission-mapper", true)).build();
    static final SimpleAttributeDefinition LOGICAL_OPERATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("logical-operation", ModelType.STRING, false).setAllowExpression(true)).setAllowedValues(new String[]{"and", "or", "xor", "unless"})).setValidator((ParameterValidator)EnumValidator.create(LogicalMapperOperation.class, (boolean)false, (boolean)true))).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MAPPING_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("mapping-mode", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("first"))).setAllowedValues(new String[]{"and", "or", "xor", "unless", "first"})).setValidator((ParameterValidator)EnumValidator.create(MappingMode.class, EnumSet.allOf(MappingMode.class)))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MATCH_ALL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-all", ModelType.BOOLEAN, true).setCorrector(new ParameterCorrector(){

        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            if (newValue.isDefined() && "false".equals(newValue.asString())) {
                newValue.clear();
            }
            return newValue;
        }
    })).setAllowExpression(false)).setAlternatives(new String[]{"principals", "roles"})).setRestartAllServices()).build();
    static final StringListAttributeDefinition PRINCIPALS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("principals").setAllowExpression(true)).setRequired(false)).setAlternatives(new String[]{"match-all"})).setMinSize(1)).setXmlName("principal")).setAttributeParser(AttributeParsers.STRING_LIST_NAMED_ELEMENT)).setAttributeMarshaller(AttributeMarshallers.STRING_LIST_NAMED_ELEMENT)).build();
    static final StringListAttributeDefinition ROLES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("roles").setAllowExpression(true)).setRequired(false)).setAlternatives(new String[]{"match-all"})).setMinSize(1)).setXmlName("role")).setAttributeParser(AttributeParsers.STRING_LIST_NAMED_ELEMENT)).setAttributeMarshaller(AttributeMarshallers.STRING_LIST_NAMED_ELEMENT)).build();
    static final SimpleAttributeDefinition TARGET_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("target-name", ModelType.STRING, true).setAllowExpression(true)).setMinSize(0)).build();
    static final SimpleAttributeDefinition ACTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("action", ModelType.STRING, true).setAllowExpression(true)).setMinSize(0)).build();
    static final ObjectTypeAttributeDefinition PERMISSION = new ObjectTypeAttributeDefinition.Builder("permission", new AttributeDefinition[]{ClassLoadingAttributeDefinitions.CLASS_NAME, ClassLoadingAttributeDefinitions.MODULE, TARGET_NAME, ACTION}).build();
    static final ObjectListAttributeDefinition PERMISSIONS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("permissions", PERMISSION).setRequired(false)).setAlternatives(new String[]{"permission-sets"})).setRestartAllServices()).setAttributeMarshaller(AttributeMarshaller.UNWRAPPED_OBJECT_LIST_MARSHALLER)).setAttributeParser(AttributeParser.UNWRAPPED_OBJECT_LIST_PARSER)).setDeprecated(ModelVersion.create((int)3, (int)0))).build();
    static final SimpleAttributeDefinition PERMISSION_SET_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("permission-set", ModelType.STRING, false).setXmlName("name")).setMinSize(1)).setCapabilityReference("org.wildfly.security.permission-set", "org.wildfly.security.permission-mapper", true)).build();
    static final ObjectTypeAttributeDefinition PERMISSION_SET = new ObjectTypeAttributeDefinition.Builder("permission-set", new AttributeDefinition[]{PERMISSION_SET_NAME}).build();
    static final ObjectListAttributeDefinition PERMISSION_SETS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("permission-sets", PERMISSION_SET).setRequired(false)).setAlternatives(new String[]{"permissions"})).setRestartAllServices()).setAttributeMarshaller(AttributeMarshaller.UNWRAPPED_OBJECT_LIST_MARSHALLER)).setAttributeParser(AttributeParser.UNWRAPPED_OBJECT_LIST_PARSER)).build();
    static final ObjectTypeAttributeDefinition PERMISSION_MAPPING = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("permission-mapping", new AttributeDefinition[]{MATCH_ALL, PRINCIPALS, ROLES, PERMISSIONS, PERMISSION_SETS}).setCorrector((ParameterCorrector)new MatchAllCorrector())).build();
    static final ObjectListAttributeDefinition PERMISSION_MAPPINGS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("permission-mappings", PERMISSION_MAPPING).setRequired(false)).setCorrector((ParameterCorrector)new PermissionMappingCorrector())).setRestartAllServices()).setAttributeMarshaller(AttributeMarshallers.OBJECT_LIST_UNWRAPPED)).setAttributeParser(AttributeParsers.UNWRAPPED_OBJECT_LIST_PARSER)).build();
    static final StringListAttributeDefinition ROLES_1_0 = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(ROLES).setXmlName("roles")).setAttributeParser(AttributeParsers.STRING_LIST)).setAttributeMarshaller(AttributeMarshallers.STRING_LIST)).build();
    static final StringListAttributeDefinition PRINCIPALS_1_0 = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(PRINCIPALS).setXmlName("principals")).setAttributeParser(AttributeParsers.STRING_LIST)).setAttributeMarshaller(AttributeMarshallers.STRING_LIST)).build();
    private static final ObjectTypeAttributeDefinition PERMISSION_MAPPING_1_0 = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("permission-mapping", new AttributeDefinition[]{MATCH_ALL, PRINCIPALS_1_0, ROLES_1_0, PERMISSIONS}).setCorrector((ParameterCorrector)new MatchAllCorrector())).build();
    static final ObjectListAttributeDefinition PERMISSION_MAPPINGS_1_0 = new ObjectListAttributeDefinition.Builder(PERMISSION_MAPPINGS).setValueType(PERMISSION_MAPPING_1_0).build();
    private static final ObjectTypeAttributeDefinition PERMISSION_MAPPING_1_1 = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("permission-mapping", new AttributeDefinition[]{MATCH_ALL, PRINCIPALS, ROLES, PERMISSIONS}).setCorrector((ParameterCorrector)new MatchAllCorrector())).build();
    static final ObjectListAttributeDefinition PERMISSION_MAPPINGS_1_1 = new ObjectListAttributeDefinition.Builder(PERMISSION_MAPPINGS).setValueType(PERMISSION_MAPPING_1_1).build();

    PermissionMapperDefinitions() {
    }

    static ResourceDefinition getLogicalPermissionMapper() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{LOGICAL_OPERATION, LEFT, RIGHT};
        TrivialAddHandler<PermissionMapper> add = new TrivialAddHandler<PermissionMapper>(PermissionMapper.class, attributes, Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<PermissionMapper> getValueSupplier(ServiceBuilder<PermissionMapper> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue leftPermissionMapperInjector = new InjectedValue();
                InjectedValue rightPermissionMapperInjector = new InjectedValue();
                LogicalMapperOperation operation = LogicalMapperOperation.valueOf(LogicalMapperOperation.class, LOGICAL_OPERATION.resolveModelAttribute(context, model).asString().toUpperCase(Locale.ENGLISH));
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.permission-mapper", (String)LEFT.resolveModelAttribute(context, model).asString()), PermissionMapper.class), PermissionMapper.class, (Injector)leftPermissionMapperInjector);
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.permission-mapper", (String)RIGHT.resolveModelAttribute(context, model).asString()), PermissionMapper.class), PermissionMapper.class, (Injector)rightPermissionMapperInjector);
                return () -> operation.create((PermissionMapper)leftPermissionMapperInjector.getValue(), (PermissionMapper)rightPermissionMapperInjector.getValue());
            }
        };
        return new TrivialResourceDefinition("logical-permission-mapper", add, attributes, Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getSimplePermissionMapper() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{MAPPING_MODE, PERMISSION_MAPPINGS};
        TrivialAddHandler<PermissionMapper> add = new TrivialAddHandler<PermissionMapper>(PermissionMapper.class, attributes, Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<PermissionMapper> getValueSupplier(ServiceBuilder<PermissionMapper> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                MappingMode mappingMode = MappingMode.valueOf(MappingMode.class, MAPPING_MODE.resolveModelAttribute(context, model).asString().toUpperCase(Locale.ENGLISH));
                ArrayList<Mapping> permissionMappings = new ArrayList<Mapping>();
                if (model.hasDefined("permission-mappings")) {
                    for (ModelNode permissionMapping : model.get("permission-mappings").asList()) {
                        boolean matchAll = MATCH_ALL.resolveModelAttribute(context, permissionMapping).asBoolean(false);
                        HashSet<String> principals = !matchAll ? new HashSet<String>(PRINCIPALS.unwrap((ExpressionResolver)context, permissionMapping)) : Collections.emptySet();
                        HashSet<String> roles = !matchAll ? new HashSet<String>(ROLES.unwrap((ExpressionResolver)context, permissionMapping)) : Collections.emptySet();
                        ArrayList<Permission> permissions = new ArrayList<Permission>();
                        if (permissionMapping.hasDefined("permissions")) {
                            for (ModelNode permission : permissionMapping.require("permissions").asList()) {
                                permissions.add(new Permission(ClassLoadingAttributeDefinitions.CLASS_NAME.resolveModelAttribute(context, permission).asString(), ClassLoadingAttributeDefinitions.MODULE.resolveModelAttribute(context, permission).asStringOrNull(), TARGET_NAME.resolveModelAttribute(context, permission).asStringOrNull(), ACTION.resolveModelAttribute(context, permission).asStringOrNull()));
                            }
                        }
                        ArrayList<InjectedValue<Permissions>> permissionSetInjectors = new ArrayList<InjectedValue<Permissions>>();
                        if (permissionMapping.hasDefined("permission-sets")) {
                            for (ModelNode permissionSet : permissionMapping.require("permission-sets").asList()) {
                                InjectedValue permissionSetInjector = new InjectedValue();
                                String permissionSetName = PERMISSION_SET_NAME.resolveModelAttribute(context, permissionSet).asString();
                                String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.permission-set", (String)permissionSetName);
                                ServiceName permissionSetServiceName = context.getCapabilityServiceName(runtimeCapability, Permissions.class);
                                serviceBuilder.addDependency(permissionSetServiceName, Permissions.class, (Injector)permissionSetInjector);
                                permissionSetInjectors.add((InjectedValue<Permissions>)permissionSetInjector);
                            }
                        }
                        permissionMappings.add(new Mapping(principals, roles, permissions, permissionSetInjectors, matchAll));
                    }
                }
                return () -> PermissionMapperDefinitions.createSimplePermissionMapper(mappingMode, permissionMappings);
            }
        };
        return new TrivialResourceDefinition("simple-permission-mapper", add, attributes, Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY);
    }

    private static PermissionMapper createSimplePermissionMapper(MappingMode mappingMode, List<Mapping> mappings) throws StartException {
        SimplePermissionMapper.Builder builder = SimplePermissionMapper.builder();
        builder.setMappingMode(mappingMode.convert());
        for (Mapping current : mappings) {
            Permissions permissions = PermissionMapperDefinitions.createPermissions(current.getPermissions(), current.getPermissionSetInjectors());
            if (current.matchAll()) {
                builder.addMatchAllPrincipals(PermissionVerifier.from((PermissionCollection)permissions));
                continue;
            }
            builder.addMapping(current.getPrincipals(), current.getRoles(), PermissionVerifier.from((PermissionCollection)permissions));
        }
        return builder.build();
    }

    static ResourceDefinition getConstantPermissionMapper() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PERMISSIONS, PERMISSION_SETS};
        TrivialAddHandler<PermissionMapper> add = new TrivialAddHandler<PermissionMapper>(PermissionMapper.class, attributes, Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<PermissionMapper> getValueSupplier(ServiceBuilder<PermissionMapper> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                ArrayList<Permission> permissions = new ArrayList<Permission>();
                if (model.hasDefined("permissions")) {
                    for (ModelNode permission : model.require("permissions").asList()) {
                        permissions.add(new Permission(ClassLoadingAttributeDefinitions.CLASS_NAME.resolveModelAttribute(context, permission).asString(), ClassLoadingAttributeDefinitions.MODULE.resolveModelAttribute(context, permission).asStringOrNull(), TARGET_NAME.resolveModelAttribute(context, permission).asStringOrNull(), ACTION.resolveModelAttribute(context, permission).asStringOrNull()));
                    }
                }
                ArrayList<InjectedValue> permissionSetInjectors = new ArrayList<InjectedValue>();
                if (model.hasDefined("permission-sets")) {
                    for (ModelNode permissionSet : model.require("permission-sets").asList()) {
                        InjectedValue permissionSetInjector = new InjectedValue();
                        String permissionSetName = PERMISSION_SET_NAME.resolveModelAttribute(context, permissionSet).asString();
                        String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.permission-set", (String)permissionSetName);
                        ServiceName permissionSetServiceName = context.getCapabilityServiceName(runtimeCapability, Permissions.class);
                        serviceBuilder.addDependency(permissionSetServiceName, Permissions.class, (Injector)permissionSetInjector);
                        permissionSetInjectors.add(permissionSetInjector);
                    }
                }
                return () -> PermissionMapperDefinitions.createConstantPermissionMapper(permissions, permissionSetInjectors);
            }
        };
        return new TrivialResourceDefinition("constant-permission-mapper", add, attributes, Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY);
    }

    private static PermissionMapper createConstantPermissionMapper(List<Permission> permissionsList, List<InjectedValue<Permissions>> permissionSetInjectors) throws StartException {
        Permissions allPermissions = PermissionMapperDefinitions.createPermissions(permissionsList, permissionSetInjectors);
        return PermissionMapper.createConstant((PermissionVerifier)PermissionVerifier.from((PermissionCollection)allPermissions));
    }

    private static Permissions createPermissions(List<Permission> permissionsList, List<InjectedValue<Permissions>> permissionSetInjectors) throws StartException {
        Permissions allPermissions = PermissionMapperDefinitions.createPermissions(permissionsList);
        for (InjectedValue<Permissions> permissionSetInjector : permissionSetInjectors) {
            Permissions permissionSet = (Permissions)permissionSetInjector.getValue();
            Enumeration<java.security.Permission> permissions = permissionSet.elements();
            while (permissions.hasMoreElements()) {
                allPermissions.add(permissions.nextElement());
            }
        }
        return allPermissions;
    }

    static Permissions createPermissions(List<Permission> permissionsList) throws StartException {
        Permissions permissions = new Permissions();
        for (Permission permission : permissionsList) {
            java.security.Permission realPerm = PermissionMapperDefinitions.createPermission(permission);
            permissions.add(realPerm);
        }
        return permissions;
    }

    private static java.security.Permission createPermission(Permission permission) throws StartException {
        Module currentModule = Module.getCallerModule();
        if (permission.getModule() != null && currentModule != null) {
            ModuleIdentifier mi = ModuleIdentifier.fromString((String)permission.getModule());
            try {
                currentModule = currentModule.getModule(mi);
            }
            catch (ModuleLoadException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidPermissionModule(permission.getModule(), e);
            }
        }
        Object classLoader = currentModule != null ? currentModule.getClassLoader() : PermissionMapperDefinitions.class.getClassLoader();
        try {
            return PermissionUtil.createPermission((ClassLoader)classLoader, (String)permission.getClassName(), (String)permission.getTargetName(), (String)permission.getAction());
        }
        catch (InvalidPermissionClassException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.invalidPermissionClass(permission.getClassName());
        }
        catch (Throwable e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.exceptionWhileCreatingPermission(permission.getClassName(), e);
        }
    }

    private static enum LogicalMapperOperation {
        AND((l, r) -> l.and(r)),
        OR((l, r) -> l.or(r)),
        XOR((l, r) -> l.xor(r)),
        UNLESS((l, r) -> l.unless(r));

        private final BinaryOperator<PermissionMapper> operator;

        private LogicalMapperOperation(BinaryOperator<PermissionMapper> operator) {
            this.operator = operator;
        }

        PermissionMapper create(PermissionMapper left, PermissionMapper right) {
            return (PermissionMapper)this.operator.apply(left, right);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    private static enum MappingMode {
        AND,
        OR,
        XOR,
        UNLESS,
        FIRST;


        SimplePermissionMapper.MappingMode convert() {
            switch (this) {
                case AND: {
                    return SimplePermissionMapper.MappingMode.AND;
                }
                case OR: {
                    return SimplePermissionMapper.MappingMode.OR;
                }
                case XOR: {
                    return SimplePermissionMapper.MappingMode.XOR;
                }
                case UNLESS: {
                    return SimplePermissionMapper.MappingMode.UNLESS;
                }
            }
            return SimplePermissionMapper.MappingMode.FIRST_MATCH;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static class Mapping {
        private boolean matchAll;
        private final Set<String> principals;
        private final Set<String> roles;
        private final List<Permission> permissions;
        private final List<InjectedValue<Permissions>> permissionSetInjectors;

        Mapping(Set<String> principals, Set<String> roles, List<Permission> permissions, List<InjectedValue<Permissions>> permissionSetInjectors, boolean matchAll) {
            this.principals = principals;
            this.roles = roles;
            this.permissions = permissions;
            this.permissionSetInjectors = permissionSetInjectors;
            this.matchAll = matchAll;
        }

        public Set<String> getPrincipals() {
            return this.principals;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public List<Permission> getPermissions() {
            return this.permissions;
        }

        public List<InjectedValue<Permissions>> getPermissionSetInjectors() {
            return this.permissionSetInjectors;
        }

        public boolean matchAll() {
            return this.matchAll;
        }
    }

    static class Permission {
        private final String className;
        private final String module;
        private final String targetName;
        private final String action;

        Permission(String className, String module, String targetName, String action) {
            this.className = className;
            this.module = module;
            this.targetName = targetName;
            this.action = action;
        }

        public String getClassName() {
            return this.className;
        }

        public String getModule() {
            return this.module;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String getAction() {
            return this.action;
        }
    }

    static class PermissionMappingCorrector
    implements ParameterCorrector {
        PermissionMappingCorrector() {
        }

        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            if (!newValue.isDefined() || newValue.getType() != ModelType.LIST) {
                return newValue;
            }
            for (ModelNode newNode : newValue.asList()) {
                PERMISSION_MAPPING.getCorrector().correct(newNode, new ModelNode());
            }
            return newValue;
        }
    }

    static class MatchAllCorrector
    implements ParameterCorrector {
        MatchAllCorrector() {
        }

        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            String name = MATCH_ALL.getName();
            if (!newValue.isDefined() || !newValue.hasDefined(name)) {
                return newValue;
            }
            ModelNode updated = newValue.get(name);
            MATCH_ALL.getCorrector().correct(updated, new ModelNode());
            if (!updated.isDefined()) {
                newValue.remove(name);
            }
            return newValue;
        }
    }
}

