/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.Services;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.common.Assert;
import org.wildfly.extension.elytron.Capabilities;

class ElytronScheduledExecutorService
implements Service {
    private static final ServiceName SERVICE_NAME = Capabilities.SCHEDULED_EXECUTOR_RUNTIME_CAPABILITY.getCapabilityServiceName();
    private final Supplier<ExecutorService> shutDownExecutor;
    private final Consumer<ScheduledExecutorService> valueConsumer;
    private volatile ScheduledExecutorService scheduledExecutorService;

    ElytronScheduledExecutorService(Supplier<ExecutorService> shutDownExecutor, Consumer<ScheduledExecutorService> valueConsumer) {
        this.shutDownExecutor = (Supplier)Assert.checkNotNullParam((String)"shutDownExecutor", shutDownExecutor);
        this.valueConsumer = (Consumer)Assert.checkNotNullParam((String)"valueConsumer", valueConsumer);
    }

    public void start(StartContext context) throws StartException {
        String namePattern = "ElytronExtension Thread Pool -- %t";
        ThreadGroup threadGroup = new ThreadGroup("ElytronExtension ThreadGroup");
        ThreadFactory threadFactory = AccessController.doPrivileged(() -> new JBossThreadFactory(threadGroup, Boolean.FALSE, null, "ElytronExtension Thread Pool -- %t", null, null));
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.valueConsumer.accept(this.scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        Runnable r = () -> {
            try {
                this.scheduledExecutorService.shutdown();
            }
            finally {
                this.scheduledExecutorService = null;
                context.complete();
            }
        };
        try {
            this.shutDownExecutor.get().execute(r);
        }
        catch (RejectedExecutionException e) {
            r.run();
        }
        finally {
            context.asynchronous();
        }
    }

    static void installScheduledExecutorService(ServiceTarget serviceTarget) {
        ServiceBuilder serviceBuilder = serviceTarget.addService().setInitialMode(ServiceController.Mode.ON_DEMAND);
        Supplier shutDownExecutor = Services.requireServerExecutor((ServiceBuilder)serviceBuilder);
        Consumer valueConsumer = serviceBuilder.provides(new ServiceName[]{SERVICE_NAME});
        serviceBuilder.setInstance((Service)new ElytronScheduledExecutorService(shutDownExecutor, valueConsumer)).install();
    }

    static void uninstallScheduledExecutorService(OperationContext context) {
        context.removeService(SERVICE_NAME);
    }
}

