/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.CharsetValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.LegacyPropertiesSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.spec.Encoding;

class PropertiesRealmDefinition {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", FileAttributeDefinitions.PATH).setRequired(true)).build();
    private static final SimpleAttributeDefinition PLAIN_TEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("plain-text", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static final SimpleAttributeDefinition DIGEST_REALM_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("digest-realm-name", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final ObjectTypeAttributeDefinition USERS_PROPERTIES = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("users-properties", new AttributeDefinition[]{PATH, FileAttributeDefinitions.RELATIVE_TO, DIGEST_REALM_NAME, PLAIN_TEXT}).setRequired(true)).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition GROUPS_PROPERTIES = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("groups-properties", new AttributeDefinition[]{PATH, FileAttributeDefinitions.RELATIVE_TO}).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition GROUPS_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("groups-attribute", ModelType.STRING, true).setDefaultValue(new ModelNode("groups"))).setAllowExpression(true)).setRestartAllServices()).build();
    private static final SimpleAttributeDefinition SYNCHRONIZED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("synchronized", ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition HASH_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-encoding", ModelType.STRING, true).setDefaultValue(new ModelNode("hex"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"base64", "hex"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition HASH_CHARSET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-charset", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator((ParameterValidator)new CharsetValidator())).setDefaultValue(new ModelNode("UTF-8"))).setAllowExpression(true)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{USERS_PROPERTIES, GROUPS_PROPERTIES, GROUPS_ATTRIBUTE, HASH_ENCODING, HASH_CHARSET};
    private static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("properties-realm");
    private static final SimpleOperationDefinition LOAD = new SimpleOperationDefinitionBuilder("load", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setRuntimeOnly().build();
    private static final AbstractAddStepHandler ADD = new TrivialAddHandler<SecurityRealm>(SecurityRealm.class, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY){

        @Override
        protected TrivialService.ValueSupplier<SecurityRealm> getValueSupplier(ServiceBuilder<SecurityRealm> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
            String groupsRelativeTo;
            String groupsPath;
            final String groupsAttribute = GROUPS_ATTRIBUTE.resolveModelAttribute(context, model).asString();
            final String hashEncoding = HASH_ENCODING.resolveModelAttribute(context, model).asString();
            final String hashCharset = HASH_CHARSET.resolveModelAttribute(context, model).asString();
            ModelNode usersProperties = USERS_PROPERTIES.resolveModelAttribute(context, model);
            final String usersPath = PATH.resolveModelAttribute(context, usersProperties).asStringOrNull();
            final String usersRelativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, usersProperties).asStringOrNull();
            final String digestRealmName = DIGEST_REALM_NAME.resolveModelAttribute(context, usersProperties).asStringOrNull();
            final boolean plainText = PLAIN_TEXT.resolveModelAttribute(context, usersProperties).asBoolean();
            ModelNode groupsProperties = GROUPS_PROPERTIES.resolveModelAttribute(context, model);
            if (groupsProperties.isDefined()) {
                groupsPath = PATH.resolveModelAttribute(context, groupsProperties).asStringOrNull();
                groupsRelativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, groupsProperties).asStringOrNull();
            } else {
                groupsPath = null;
                groupsRelativeTo = null;
            }
            final InjectedValue pathManagerInjector = new InjectedValue();
            if (usersRelativeTo != null || groupsRelativeTo != null) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManagerInjector);
                if (usersRelativeTo != null) {
                    serviceBuilder.requires(FileAttributeDefinitions.pathName(usersRelativeTo));
                }
                if (groupsRelativeTo != null) {
                    serviceBuilder.requires(FileAttributeDefinitions.pathName(groupsRelativeTo));
                }
            }
            return new TrivialService.ValueSupplier<SecurityRealm>(){
                private final List<PathManager.Callback.Handle> callbackHandles = new ArrayList<PathManager.Callback.Handle>();

                /*
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public SecurityRealm get() throws StartException {
                    File usersFile = this.resolveFileLocation(usersPath, usersRelativeTo);
                    File groupsFile = groupsPath != null ? this.resolveFileLocation(groupsPath, groupsRelativeTo) : null;
                    try (FileInputStream usersInputStream = new FileInputStream(usersFile);){
                        RealmWrapper realmWrapper;
                        block15: {
                            FileInputStream groupsInputStream = groupsFile != null ? new FileInputStream(groupsFile) : null;
                            try {
                                realmWrapper = new RealmWrapper(LegacyPropertiesSecurityRealm.builder().setUsersStream((InputStream)usersInputStream).setGroupsStream((InputStream)groupsInputStream).setPlainText(plainText).setGroupsAttribute(groupsAttribute).setDefaultRealm(digestRealmName).setHashEncoding("base64".equalsIgnoreCase(hashEncoding) ? Encoding.BASE64 : Encoding.HEX).setHashCharset(Charset.forName(hashCharset)).build(), usersFile, groupsFile);
                                if (groupsInputStream == null) break block15;
                            }
                            catch (Throwable throwable) {
                                if (groupsInputStream != null) {
                                    try {
                                        ((InputStream)groupsInputStream).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            ((InputStream)groupsInputStream).close();
                        }
                        return realmWrapper;
                    }
                    catch (FileNotFoundException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.propertyFilesDoesNotExist(e.getMessage());
                    }
                    catch (RealmUnavailableException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.propertyFileIsInvalid(e.getMessage(), e.getCause());
                    }
                    catch (IOException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToLoadPropertiesFiles(e, usersFile.toString(), groupsFile != null ? groupsFile.toString() : null);
                    }
                }

                @Override
                public void dispose() {
                    for (PathManager.Callback.Handle h : this.callbackHandles) {
                        h.remove();
                    }
                }

                private File resolveFileLocation(String path, String relativeTo) {
                    File resolvedPath;
                    if (relativeTo != null) {
                        PathManager pathManager = (PathManager)pathManagerInjector.getValue();
                        resolvedPath = new File(pathManager.resolveRelativePathEntry(path, relativeTo));
                        PathManager.Callback.Handle callbackHandle = pathManager.registerCallback(relativeTo, new PathManager.Callback(){

                            public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                                if (!eventContext.isResourceServiceRestartAllowed()) {
                                    eventContext.reloadRequired();
                                }
                            }

                            public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                            }
                        }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
                        this.callbackHandles.add(callbackHandle);
                    } else {
                        resolvedPath = new File(path);
                    }
                    return resolvedPath;
                }
            };
        }
    };

    PropertiesRealmDefinition() {
    }

    static ResourceDefinition create(boolean serverOrHostController) {
        TrivialResourceDefinition.Builder builder = TrivialResourceDefinition.builder().setPathKey("properties-realm").setResourceDescriptionResolver((ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler(ADD).setAttributes(ATTRIBUTES).setRuntimeCapabilities(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
        if (serverOrHostController) {
            builder.addReadOnlyAttribute((AttributeDefinition)SYNCHRONIZED, new PropertiesRuntimeHandler(false){

                @Override
                void performRuntime(OperationContext context, RealmWrapper securityRealm) throws OperationFailedException {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                    context.getResult().set(sdf.format(new Date(securityRealm.getLoadTime())));
                }
            });
        }
        builder.addOperation((OperationDefinition)LOAD, new PropertiesRuntimeHandler(true){

            @Override
            void performRuntime(OperationContext context, RealmWrapper securityRealm) throws OperationFailedException {
                securityRealm.reload();
            }
        });
        return builder.build();
    }

    private static final class RealmWrapper
    implements SecurityRealm {
        private final LegacyPropertiesSecurityRealm delegate;
        private final File usersFile;
        private final File groupsFile;

        RealmWrapper(LegacyPropertiesSecurityRealm delegate, File usersFile, File groupsFile) {
            this.delegate = delegate;
            this.usersFile = usersFile;
            this.groupsFile = groupsFile;
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            try {
                this.reloadIfNeeded();
                return this.delegate.getRealmIdentity(principal);
            }
            catch (IOException e) {
                throw new RealmUnavailableException((Throwable)e);
            }
        }

        public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
            try {
                this.reloadIfNeeded();
                return this.delegate.getRealmIdentity(evidence);
            }
            catch (IOException e) {
                throw new RealmUnavailableException((Throwable)e);
            }
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.delegate.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.delegate.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.delegate.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        public void handleRealmEvent(RealmEvent event) {
            this.delegate.handleRealmEvent(event);
        }

        long getLoadTime() {
            return this.delegate.getLoadTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reloadIfNeeded() throws IOException {
            long loadTime = this.delegate.getLoadTime();
            if (this.shouldReload(loadTime)) {
                RealmWrapper realmWrapper = this;
                synchronized (realmWrapper) {
                    loadTime = this.delegate.getLoadTime();
                    if (this.shouldReload(loadTime)) {
                        this.reloadInternal();
                    }
                }
            }
        }

        boolean shouldReload(long loadTime) {
            return SecurityActions.doPrivileged(() -> loadTime < this.usersFile.lastModified() || this.groupsFile != null && loadTime < this.groupsFile.lastModified());
        }

        void reload() throws OperationFailedException {
            try {
                this.reloadInternal();
            }
            catch (IOException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToReLoadPropertiesFiles(e);
            }
        }

        void reloadInternal() throws IOException {
            try (FileInputStream usersInputStream = new FileInputStream(this.usersFile);
                 FileInputStream groupsInputStream = this.groupsFile != null ? new FileInputStream(this.groupsFile) : null;){
                this.delegate.load((InputStream)usersInputStream, (InputStream)groupsInputStream);
            }
        }
    }

    static abstract class PropertiesRuntimeHandler
    extends ElytronRuntimeOnlyHandler {
        private final boolean writeAccess;

        PropertiesRuntimeHandler(boolean writeAccess) {
            this.writeAccess = writeAccess;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName securityRealmName = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue()).getCapabilityServiceName();
            ServiceController<SecurityRealm> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(this.writeAccess), securityRealmName, SecurityRealm.class);
            ServiceController.State serviceState = serviceContainer.getState();
            if (serviceState != ServiceController.State.UP) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(securityRealmName, serviceState);
            }
            SecurityRealm securityRealm = (SecurityRealm)serviceContainer.getValue();
            assert (securityRealm instanceof RealmWrapper);
            this.performRuntime(context, (RealmWrapper)securityRealm);
        }

        abstract void performRuntime(OperationContext var1, RealmWrapper var2) throws OperationFailedException;
    }
}

