/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.elytron.ElytronOperationStepHandler;

class TrivialCapabilityServiceRemoveHandler
extends ServiceRemoveStepHandler
implements ElytronOperationStepHandler {
    private final RuntimeCapability<?> firstCapability;
    private final Set<RuntimeCapability> allCapabilities;

    TrivialCapabilityServiceRemoveHandler(AbstractAddStepHandler addOperation, RuntimeCapability<?> ... runtimeCapabilities) {
        super(addOperation, runtimeCapabilities);
        this.firstCapability = runtimeCapabilities[0];
        this.allCapabilities = new HashSet(Arrays.asList(runtimeCapabilities));
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        String pathValue = context.getCurrentAddressValue();
        this.allCapabilities.forEach(r -> context.deregisterCapabilityRequirement("org.wildfly.security.elytron", r.isDynamicallyNamed() ? r.getDynamicName(pathValue) : r.getName()));
    }

    protected ServiceName serviceName(String name) {
        return this.firstCapability.fromBaseCapability(name).getCapabilityServiceName();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return this.isServerOrHostController(context);
    }
}

