/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AuditLoggingParser;
import org.wildfly.extension.elytron.AuthenticationClientParser;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.CredentialSecurityFactoryParser;
import org.wildfly.extension.elytron.CredentialStoreParser;
import org.wildfly.extension.elytron.CustomComponentDefinition;
import org.wildfly.extension.elytron.DirContextParser;
import org.wildfly.extension.elytron.DomainDefinition;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.HttpParser;
import org.wildfly.extension.elytron.MapperParser;
import org.wildfly.extension.elytron.PolicyParser;
import org.wildfly.extension.elytron.ProviderParser;
import org.wildfly.extension.elytron.RealmParser;
import org.wildfly.extension.elytron.SaslParser;
import org.wildfly.extension.elytron.TlsParser;

class ElytronSubsystemParser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private final AuthenticationClientParser clientParser = new AuthenticationClientParser(this);
    private final AuditLoggingParser auditLoggingParser = new AuditLoggingParser(this);
    private final PersistentResourceXMLDescription domainParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"security-domain")).setXmlWrapperElement("security-domains").addAttribute((AttributeDefinition)DomainDefinition.DEFAULT_REALM).addAttribute((AttributeDefinition)DomainDefinition.PERMISSION_MAPPER).addAttribute((AttributeDefinition)DomainDefinition.PRE_REALM_PRINCIPAL_TRANSFORMER).addAttribute((AttributeDefinition)DomainDefinition.POST_REALM_PRINCIPAL_TRANSFORMER).addAttribute((AttributeDefinition)DomainDefinition.PRINCIPAL_DECODER).addAttribute((AttributeDefinition)DomainDefinition.REALM_MAPPER).addAttribute((AttributeDefinition)DomainDefinition.ROLE_MAPPER).addAttribute((AttributeDefinition)DomainDefinition.TRUSTED_SECURITY_DOMAINS).addAttribute((AttributeDefinition)DomainDefinition.OUTFLOW_ANONYMOUS).addAttribute((AttributeDefinition)DomainDefinition.OUTFLOW_SECURITY_DOMAINS).addAttribute((AttributeDefinition)DomainDefinition.SECURITY_EVENT_LISTENER).addAttribute((AttributeDefinition)DomainDefinition.REALMS).build();
    private final RealmParser realmParser = new RealmParser(this);
    private final TlsParser tlsParser = new TlsParser(this);
    private final ProviderParser providerParser = new ProviderParser(this);
    private final CredentialSecurityFactoryParser credentialSecurityFactoryParser = new CredentialSecurityFactoryParser(this);
    private final SaslParser saslParser = new SaslParser(this);
    private final HttpParser httpParser = new HttpParser(this);
    private final CredentialStoreParser credentialStoreParser = new CredentialStoreParser(this);
    private final DirContextParser dirContextParser = new DirContextParser(this);
    private final PolicyParser policyParser = new PolicyParser(this);
    private final String namespace;
    private final MapperParser mapperParser;

    ElytronSubsystemParser(String namespace) {
        this.namespace = namespace;
        this.mapperParser = new MapperParser(this, "urn:wildfly:elytron:1.0".equals(namespace));
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress parentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{ElytronExtension.SUBSYSTEM_PATH});
        ModelNode subsystemAdd = Util.createAddOperation((PathAddress)parentAddress);
        operations.add(subsystemAdd);
        int count = reader.getAttributeCount();
        block44: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "default-authentication-context": {
                    ElytronDefinition.DEFAULT_AUTHENTICATION_CONTEXT.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                    continue block44;
                }
                case "initial-providers": {
                    ElytronDefinition.INITIAL_PROVIDERS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                    continue block44;
                }
                case "final-providers": {
                    ElytronDefinition.FINAL_PROVIDERS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                    continue block44;
                }
                case "disallowed-providers": {
                    ElytronDefinition.DISALLOWED_PROVIDERS.getParser().parseAndSetParameter((AttributeDefinition)ElytronDefinition.DISALLOWED_PROVIDERS, value, subsystemAdd, (XMLStreamReader)reader);
                    continue block44;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        HashSet<String> foundElements = new HashSet<String>();
        block45: while (reader.hasNext() && reader.nextTag() != 2) {
            this.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!foundElements.add(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (reader.getLocalName()) {
                case "security-properties": {
                    ElytronDefinition.SECURITY_PROPERTIES.getParser().parseElement((AttributeDefinition)ElytronDefinition.SECURITY_PROPERTIES, reader, subsystemAdd);
                    continue block45;
                }
                case "authentication-client": {
                    this.clientParser.readAuthenticationClient(parentAddress, reader, operations);
                    continue block45;
                }
                case "providers": {
                    this.providerParser.readProviders(parentAddress, reader, operations);
                    continue block45;
                }
                case "audit-logging": {
                    this.auditLoggingParser.readAuditLogging(parentAddress, reader, operations);
                    continue block45;
                }
                case "security-domains": {
                    this.readDomains(parentAddress, reader, operations);
                    continue block45;
                }
                case "security-realms": {
                    this.realmParser.readRealms(parentAddress, reader, operations);
                    continue block45;
                }
                case "credential-security-factories": {
                    this.credentialSecurityFactoryParser.readCredentialSecurityFactories(parentAddress, reader, operations);
                    continue block45;
                }
                case "mappers": {
                    this.mapperParser.readMappers(parentAddress, reader, operations);
                    continue block45;
                }
                case "http": {
                    this.httpParser.readHttp(PathAddress.pathAddress((PathAddress)parentAddress, (PathElement[])new PathElement[0]), reader, operations);
                    continue block45;
                }
                case "sasl": {
                    this.saslParser.readSasl(parentAddress, reader, operations);
                    continue block45;
                }
                case "tls": {
                    this.tlsParser.readTls(parentAddress, reader, operations);
                    continue block45;
                }
                case "credential-stores": {
                    this.credentialStoreParser.readCredentialStores(parentAddress.toModelNode(), reader, operations);
                    continue block45;
                }
                case "dir-contexts": {
                    this.dirContextParser.readDirContexts(parentAddress.toModelNode(), reader, operations);
                    continue block45;
                }
                case "policy": {
                    this.policyParser.readPolicy(parentAddress.toModelNode(), reader, operations);
                    continue block45;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readDomains(PathAddress parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("security-domain".equals(localName)) {
                this.domainParser.parse(reader, parentAddress, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static PersistentResourceXMLDescription getCustomComponentParser(String componentType) {
        return PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)componentType)).setUseElementsForGroups(false).addAttribute((AttributeDefinition)ClassLoadingAttributeDefinitions.MODULE).addAttribute((AttributeDefinition)ClassLoadingAttributeDefinitions.CLASS_NAME).addAttribute((AttributeDefinition)CustomComponentDefinition.CONFIGURATION).build();
    }

    static void readCustomComponent(String componentType, PathAddress parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ElytronSubsystemParser.getCustomComponentParser(componentType).parse(reader, parentAddress, operations);
    }

    static void writeCustomComponent(String elementName, String componentType, ModelNode component, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(elementName);
        writer.writeAttribute("name", componentType);
        ClassLoadingAttributeDefinitions.MODULE.marshallAsAttribute(component, (XMLStreamWriter)writer);
        ClassLoadingAttributeDefinitions.CLASS_NAME.marshallAsAttribute(component, (XMLStreamWriter)writer);
        CustomComponentDefinition.CONFIGURATION.marshallAsElement(component, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(this.namespace, false);
        ModelNode model = context.getModelNode();
        ElytronDefinition.DEFAULT_AUTHENTICATION_CONTEXT.marshallAsAttribute(model, (XMLStreamWriter)writer);
        ElytronDefinition.INITIAL_PROVIDERS.marshallAsAttribute(model, (XMLStreamWriter)writer);
        ElytronDefinition.FINAL_PROVIDERS.marshallAsAttribute(model, (XMLStreamWriter)writer);
        ElytronDefinition.DISALLOWED_PROVIDERS.getMarshaller().marshallAsAttribute((AttributeDefinition)ElytronDefinition.DISALLOWED_PROVIDERS, model, true, (XMLStreamWriter)writer);
        ElytronDefinition.SECURITY_PROPERTIES.getMarshaller().marshall((AttributeDefinition)ElytronDefinition.SECURITY_PROPERTIES, model, true, (XMLStreamWriter)writer);
        this.clientParser.writeAuthenticationClient(model, writer);
        this.providerParser.writeProviders(model, writer);
        this.auditLoggingParser.writeAuditLogging(model, writer);
        this.domainParser.persist(writer, model);
        this.realmParser.writeRealms(model, writer);
        this.credentialSecurityFactoryParser.writeCredentialSecurityFactories(model, writer);
        this.mapperParser.writeMappers(model, writer);
        this.httpParser.writeHttp(model, writer);
        this.saslParser.writeSasl(model, writer);
        this.tlsParser.writeTLS(model, writer);
        this.credentialStoreParser.writeCredentialStores(model, writer);
        this.dirContextParser.writeDirContexts(model, writer);
        this.policyParser.writePolicy(model, writer);
        writer.writeEndElement();
    }

    void verifyNamespace(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (!this.namespace.equals(reader.getNamespaceURI())) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

