/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.PolicyDefinitions;

class PolicyParser {
    private final ElytronSubsystemParser elytronSubsystemParser;

    PolicyParser(ElytronSubsystemParser elytronSubsystemParser) {
        this.elytronSubsystemParser = elytronSubsystemParser;
    }

    private void verifyNamespace(XMLExtendedStreamReader reader) throws XMLStreamException {
        this.elytronSubsystemParser.verifyNamespace(reader);
    }

    void readPolicy(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        boolean providerFound;
        ModelNode addPolicy = new ModelNode();
        addPolicy.get("operation").set("add");
        String defaultPolicy = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "default-policy": {
                    PolicyDefinitions.DEFAULT_POLICY.parseAndSetParameter(value, addPolicy, (XMLStreamReader)reader);
                    defaultPolicy = value;
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean bl = providerFound = defaultPolicy == null;
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            this.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "jacc-policy": {
                    String jaccPolicy = this.parseJaccPolicy(addPolicy, reader, operations);
                    providerFound = providerFound || defaultPolicy.equals(jaccPolicy);
                    continue block15;
                }
                case "custom-policy": {
                    String customPolicy = this.parseCustomPolicy(addPolicy, reader, operations);
                    providerFound = providerFound || defaultPolicy.equals(customPolicy);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!providerFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"default-policy"});
        }
        addPolicy.get("address").set(parentAddress).add("policy", defaultPolicy);
        operations.add(addPolicy);
    }

    private String parseJaccPolicy(ModelNode policyModel, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode providerModel = new ModelNode();
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name"));
        String name = null;
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    PolicyDefinitions.JaccPolicyDefinition.NAME.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block12;
                }
                case "policy": {
                    PolicyDefinitions.JaccPolicyDefinition.POLICY_PROVIDER.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block12;
                }
                case "configuration-factory": {
                    PolicyDefinitions.JaccPolicyDefinition.CONFIGURATION_FACTORY.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block12;
                }
                case "module": {
                    PolicyDefinitions.JaccPolicyDefinition.MODULE.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode policies = policyModel.get("jacc-policy");
        if (!policies.isDefined()) {
            policies.setEmptyList();
        }
        policies.add(providerModel);
        return name;
    }

    private String parseCustomPolicy(ModelNode policyModel, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode providerModel = new ModelNode();
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "class-name"));
        String name = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    PolicyDefinitions.CustomPolicyDefinition.NAME.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block10;
                }
                case "class-name": {
                    PolicyDefinitions.CustomPolicyDefinition.CLASS_NAME.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block10;
                }
                case "module": {
                    PolicyDefinitions.CustomPolicyDefinition.MODULE.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode policies = policyModel.get("custom-policy");
        if (!policies.isDefined()) {
            policies.setEmptyList();
        }
        policies.add(providerModel);
        return name;
    }

    void writePolicy(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!subsystem.hasDefined("policy")) {
            return;
        }
        Property policy = subsystem.get("policy").asProperty();
        String defaultPolicy = policy.getName();
        ModelNode policyModel = policy.getValue();
        if (policyModel.get("default-policy").isDefined()) {
            defaultPolicy = policyModel.get("default-policy").asString();
        }
        boolean mappersStarted = false;
        mappersStarted |= this.writeJaccPolicy(mappersStarted, defaultPolicy, policyModel, writer);
        if (mappersStarted |= this.writeCustomPolicy(mappersStarted, defaultPolicy, policyModel, writer)) {
            writer.writeEndElement();
        }
    }

    private boolean writeJaccPolicy(boolean started, String defaultPolicy, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("jacc-policy")) {
            ModelNode jaccPolicies = subsystem.get("jacc-policy");
            this.startPolicy(started, defaultPolicy, subsystem, writer);
            for (ModelNode jaccPolicy : jaccPolicies.asList()) {
                writer.writeStartElement("jacc-policy");
                PolicyDefinitions.JaccPolicyDefinition.NAME.marshallAsAttribute(jaccPolicy, (XMLStreamWriter)writer);
                PolicyDefinitions.JaccPolicyDefinition.POLICY_PROVIDER.marshallAsAttribute(jaccPolicy, (XMLStreamWriter)writer);
                PolicyDefinitions.JaccPolicyDefinition.CONFIGURATION_FACTORY.marshallAsAttribute(jaccPolicy, (XMLStreamWriter)writer);
                PolicyDefinitions.JaccPolicyDefinition.MODULE.marshallAsAttribute(jaccPolicy, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomPolicy(boolean started, String defaultPolicy, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-policy")) {
            ModelNode jaccPolicies = subsystem.get("custom-policy");
            this.startPolicy(started, defaultPolicy, subsystem, writer);
            for (ModelNode customPolicy : jaccPolicies.asList()) {
                writer.writeStartElement("custom-policy");
                PolicyDefinitions.CustomPolicyDefinition.NAME.marshallAsAttribute(customPolicy, (XMLStreamWriter)writer);
                PolicyDefinitions.CustomPolicyDefinition.CLASS_NAME.marshallAsAttribute(customPolicy, (XMLStreamWriter)writer);
                PolicyDefinitions.CustomPolicyDefinition.MODULE.marshallAsAttribute(customPolicy, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private void startPolicy(boolean started, String defaultPolicy, ModelNode policyModel, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("policy");
            writer.writeAttribute("default-policy", defaultPolicy);
        }
    }
}

