/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;

class CredentialStoreService
implements Service<CredentialStore> {
    private static final String CS_LOCATION_ATTRIBUTE = "location";
    private static final String CS_KEY_STORE_TYPE_ATTRIBUTE = "keyStoreType";
    private final AtomicReference<CredentialStore> credentialStore = new AtomicReference();
    private final String type;
    private final String provider;
    private final String providerLoaderName;
    private final String otherProvidersLoaderName;
    private final String relativeTo;
    private final String location;
    private final String name;
    private final Map<String, String> credentialStoreAttributes;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final InjectedValue<Provider[]> providers = new InjectedValue();
    private final InjectedValue<Provider[]> otherProviders = new InjectedValue();
    private final InjectedValue<CredentialStore> injectedCredentialStore = new InjectedValue();
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> credentialSourceSupplier = new InjectedValue();
    private PathManager.Callback.Handle callbackHandle;

    private CredentialStoreService(String name, Map<String, String> credentialStoreAttributes, String type, String provider, String relativeTo, String location, String providerLoaderName, String otherProvidersLoaderName) throws CredentialStoreException {
        this.name = name;
        this.type = type != null ? type : KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE;
        this.provider = provider;
        this.relativeTo = relativeTo;
        this.credentialStoreAttributes = credentialStoreAttributes;
        this.location = location;
        this.providerLoaderName = providerLoaderName;
        this.otherProvidersLoaderName = otherProvidersLoaderName;
    }

    static CredentialStoreService createCredentialStoreService(String name, String location, boolean modifiable, boolean create, Map<String, String> implementationAttributes, String type, String provider, String relativeTo, String providerLoaderName, String keyStoreProvidersLoaderName) throws CredentialStoreException {
        HashMap<String, String> credentialStoreAttributes = new HashMap<String, String>();
        if (implementationAttributes != null) {
            credentialStoreAttributes.putAll(implementationAttributes);
        }
        credentialStoreAttributes.put("modifiable", Boolean.toString(modifiable));
        credentialStoreAttributes.put("create", Boolean.toString(create));
        if (type == null || type.equals(KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE)) {
            credentialStoreAttributes.putIfAbsent(CS_KEY_STORE_TYPE_ATTRIBUTE, "JCEKS");
        }
        return new CredentialStoreService(name, credentialStoreAttributes, type, provider, relativeTo, location != null ? location : name, providerLoaderName, keyStoreProvidersLoaderName);
    }

    public void start(StartContext startContext) throws StartException {
        Path loc = this.resolveLocation();
        try {
            ElytronSubsystemMessages.ROOT_LOGGER.tracef("starting CredentialStore:  name = %s", this.name);
            this.credentialStoreAttributes.put(CS_LOCATION_ATTRIBUTE, loc.toAbsolutePath().toString());
            CredentialStore cs = this.getCredentialStoreInstance();
            Object[] otherProvidersArr = (Provider[])this.otherProviders.getOptionalValue();
            if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                ElytronSubsystemMessages.ROOT_LOGGER.tracef("initializing CredentialStore:  name = %s  type = %s  provider = %s  otherProviders = %s  attributes = %s", new Object[]{this.name, this.type, this.provider, Arrays.toString(otherProvidersArr), this.credentialStoreAttributes});
            }
            cs.initialize(this.credentialStoreAttributes, (CredentialStore.ProtectionParameter)this.resolveCredentialStoreProtectionParameter(), (Provider[])otherProvidersArr);
            if (this.credentialStoreAttributes.get("create").equals("true") && !loc.toFile().exists()) {
                ElytronSubsystemMessages.ROOT_LOGGER.tracef("CredentialStore %s does not exist, creating", this.name);
                cs.flush();
            }
            this.credentialStore.set(cs);
            ElytronSubsystemMessages.ROOT_LOGGER.tracef("CredentialStore started:  name = %s  credentialStore = %s", this.name, cs);
        }
        catch (Exception e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
        }
    }

    public void stop(StopContext stopContext) {
        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
            ElytronSubsystemMessages.ROOT_LOGGER.tracef("stopping CredentialStore:  name = %s  credentialStore = %s", this.name, this.credentialStore.get());
        }
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
        this.credentialStore.set(null);
    }

    public CredentialStore getValue() {
        return this.credentialStore.get();
    }

    private Path resolveLocation() {
        if (this.relativeTo != null) {
            PathManager pathManager = (PathManager)this.pathManager.getValue();
            String baseDir = pathManager.resolveRelativePathEntry("", this.relativeTo);
            this.callbackHandle = pathManager.registerCallback(this.relativeTo, new PathManager.Callback(){

                public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                    if (!eventContext.isResourceServiceRestartAllowed()) {
                        eventContext.reloadRequired();
                    }
                }

                public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                }
            }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
            return Paths.get(baseDir, this.location);
        }
        return Paths.get(this.location, new String[0]);
    }

    private CredentialStore getCredentialStoreInstance() throws CredentialStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        if (this.provider != null) {
            return CredentialStore.getInstance((String)this.type, (String)this.provider);
        }
        Object[] injectedProviders = (Provider[])this.providers.getOptionalValue();
        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
            ElytronSubsystemMessages.ROOT_LOGGER.tracef("obtaining CredentialStore %s from providers %s", this.name, Arrays.toString(injectedProviders));
        }
        if (injectedProviders != null) {
            for (Object p : injectedProviders) {
                try {
                    return CredentialStore.getInstance((String)this.type, (Provider)p);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
            }
            throw ElytronSubsystemMessages.ROOT_LOGGER.providerLoaderCannotSupplyProvider(this.providerLoaderName, this.type);
        }
        return CredentialStore.getInstance((String)this.type);
    }

    Injector<Provider[]> getProvidersInjector() {
        return this.providers;
    }

    Injector<Provider[]> getOtherProvidersInjector() {
        return this.otherProviders;
    }

    Injector<PathManager> getPathManagerInjector() {
        return this.pathManager;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getProvider() {
        return this.provider;
    }

    Injector<CredentialStore> getCredentialStoreInjector() {
        return this.injectedCredentialStore;
    }

    Injector<ExceptionSupplier<CredentialSource, Exception>> getCredentialSourceSupplierInjector() {
        return this.credentialSourceSupplier;
    }

    private CredentialStore.CredentialSourceProtectionParameter resolveCredentialStoreProtectionParameter() throws Exception {
        CredentialSource cs;
        ExceptionSupplier sourceSupplier = (ExceptionSupplier)this.credentialSourceSupplier.getValue();
        CredentialSource credentialSource = cs = sourceSupplier != null ? (CredentialSource)sourceSupplier.get() : null;
        if (cs != null) {
            Credential credential = cs.getCredential(PasswordCredential.class);
            ElytronSubsystemMessages.ROOT_LOGGER.tracef("resolving CredentialStore %s ProtectionParameter from %s", this.name, credential);
            return this.credentialToCredentialSourceProtectionParameter(credential);
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreProtectionParameterCannotBeResolved(this.name);
    }

    private CredentialStore.CredentialSourceProtectionParameter credentialToCredentialSourceProtectionParameter(Credential credential) {
        return new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential(credential));
    }
}

