/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AuthenticationFactoryParser;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.CommonAttributes;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.HttpServerDefinitions;

class HttpParser {
    private final AuthenticationFactoryParser authenticationFactoryParser = new AuthenticationFactoryParser();
    private PersistentResourceXMLDescription aggregateHttpServerMechanismFactory = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"aggregate-http-server-mechanism-factory")).addAttribute((AttributeDefinition)HttpServerDefinitions.getRawAggregateHttpServerFactoryDefinition().getReferencesAttribute(), (AttributeParser)new CommonAttributes.AggregateAttributeParser("http-server-mechanism-factory"), (AttributeMarshaller)new CommonAttributes.AggregateAttributeMarshaller("http-server-mechanism-factory")).build();
    private PersistentResourceXMLDescription configurableHttpServerMechanismFactoryParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"configurable-http-server-mechanism-factory")).addAttribute((AttributeDefinition)HttpServerDefinitions.HTTP_SERVER_FACTORY).addAttribute((AttributeDefinition)CommonAttributes.PROPERTIES).addAttribute((AttributeDefinition)HttpServerDefinitions.CONFIGURED_FILTERS).build();
    private PersistentResourceXMLDescription providerHttpServerMechanismFactoryParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"provider-http-server-mechanism-factory")).addAttribute((AttributeDefinition)HttpServerDefinitions.PROVIDERS).build();
    private PersistentResourceXMLDescription serviceLoaderHttpServerMechanismFactoryParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"service-loader-http-server-mechanism-factory")).setUseElementsForGroups(false).addAttribute((AttributeDefinition)ClassLoadingAttributeDefinitions.MODULE).build();

    HttpParser() {
    }

    void readHttp(PathAddress parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "http-authentication-factory": {
                    this.authenticationFactoryParser.readHttpAuthenticationFactoryElement(parentAddress, reader, operations);
                    continue block14;
                }
                case "aggregate-http-server-mechanism-factory": {
                    this.aggregateHttpServerMechanismFactory.parse(reader, PathAddress.pathAddress((PathAddress)parentAddress, (PathElement[])new PathElement[0]), operations);
                    continue block14;
                }
                case "configurable-http-server-mechanism-factory": {
                    this.configurableHttpServerMechanismFactoryParser.parse(reader, parentAddress, operations);
                    continue block14;
                }
                case "provider-http-server-mechanism-factory": {
                    this.providerHttpServerMechanismFactoryParser.parse(reader, parentAddress, operations);
                    continue block14;
                }
                case "service-loader-http-server-mechanism-factory": {
                    this.serviceLoaderHttpServerMechanismFactoryParser.parse(reader, parentAddress, operations);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void startHttp(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("http");
        }
    }

    private boolean writeAggregateHttpServerMechanismFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-http-server-mechanism-factory")) {
            this.startHttp(started, writer);
            this.aggregateHttpServerMechanismFactory.persist(writer, subsystem);
            return true;
        }
        return false;
    }

    private boolean writeConfigurableHttpServerMechanismFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("configurable-http-server-mechanism-factory")) {
            this.startHttp(started, writer);
            this.configurableHttpServerMechanismFactoryParser.persist(writer, subsystem);
            return true;
        }
        return false;
    }

    private boolean writeProviderHttpServerMechanismFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("provider-http-server-mechanism-factory")) {
            this.startHttp(started, writer);
            this.providerHttpServerMechanismFactoryParser.persist(writer, subsystem);
            return true;
        }
        return false;
    }

    private boolean writeServiceLoaderHttpServerMechanismFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("service-loader-http-server-mechanism-factory")) {
            this.startHttp(started, writer);
            this.serviceLoaderHttpServerMechanismFactoryParser.persist(writer, subsystem);
            return true;
        }
        return false;
    }

    void writeHttp(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean started = false;
        started |= this.authenticationFactoryParser.writeHttpAuthenticationFactory(started, subsystem, writer, b -> this.startHttp(b, writer));
        started |= this.writeAggregateHttpServerMechanismFactory(started, subsystem, writer);
        started |= this.writeConfigurableHttpServerMechanismFactory(started, subsystem, writer);
        started |= this.writeProviderHttpServerMechanismFactory(started, subsystem, writer);
        if (started |= this.writeServiceLoaderHttpServerMechanismFactory(started, subsystem, writer)) {
            writer.writeEndElement();
        }
    }
}

