/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.validators;

import java.time.format.DateTimeFormatter;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

public class SuffixValidator
extends ModelTypeValidator {
    private final boolean denySeconds;

    public SuffixValidator() {
        this(false, true);
    }

    public SuffixValidator(boolean nullable, boolean denySeconds) {
        super(ModelType.STRING, nullable);
        this.denySeconds = denySeconds;
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            String suffix = value.asString();
            try {
                if (this.denySeconds && (suffix.contains("s") || suffix.contains("S"))) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.suffixContainsMillis(suffix);
                }
                DateTimeFormatter.ofPattern(suffix);
            }
            catch (IllegalArgumentException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidSuffix(suffix);
            }
        }
    }
}

