/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.capabilities;

import java.security.Principal;
import java.util.function.Function;
import org.wildfly.common.Assert;

public interface PrincipalTransformer
extends Function<Principal, Principal> {
    public static PrincipalTransformer from(Function<Principal, Principal> function) {
        return function::apply;
    }

    public static PrincipalTransformer aggregate(PrincipalTransformer ... transformers) {
        Assert.checkNotNullParam((String)"transformers", (Object)transformers);
        PrincipalTransformer[] clone = (PrincipalTransformer[])transformers.clone();
        for (int i = 0; i < clone.length; ++i) {
            Assert.checkNotNullArrayParam((String)"transformers", (int)i, (Object)clone[i]);
        }
        return p -> {
            if (p == null) {
                return null;
            }
            for (PrincipalTransformer t : clone) {
                Principal tf = (Principal)t.apply(p);
                if (tf == null) continue;
                return tf;
            }
            return null;
        };
    }

    public static PrincipalTransformer chain(PrincipalTransformer ... transformers) {
        Assert.checkNotNullParam((String)"transformers", (Object)transformers);
        PrincipalTransformer[] clone = (PrincipalTransformer[])transformers.clone();
        for (int i = 0; i < clone.length; ++i) {
            Assert.checkNotNullArrayParam((String)"transformers", (int)i, (Object)clone[i]);
        }
        return p -> {
            for (PrincipalTransformer pt : clone) {
                if (p == null) {
                    return null;
                }
                p = (Principal)pt.apply(p);
            }
            return p;
        };
    }
}

