/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.CredentialStoreResourceDefinition;
import org.wildfly.extension.elytron.CredentialStoreService;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronWriteAttributeHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;

class CredentialStoreAliasDefinition
extends SimpleResourceDefinition {
    private static final Class<?>[] SUPPORTED_CREDENTIAL_TYPES = new Class[]{PasswordCredential.class};
    static final SimpleAttributeDefinition ENTRY_TYPE;
    static final StandardResourceDescriptionResolver RESOURCE_DESCRIPTION_RESOLVER;
    static final SimpleAttributeDefinition SECRET_VALUE;
    private static final AttributeDefinition[] CONFIG_ATTRIBUTES;
    private static final SimpleOperationDefinition ADD_DEFINITION;
    private static final AddHandler ADD_HANDLER;

    CredentialStoreAliasDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"alias"), (ResourceDescriptionResolver)RESOURCE_DESCRIPTION_RESOLVER).setRemoveHandler((OperationStepHandler)new RemoveHandler()).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_NONE).setRuntime());
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)ADD_DEFINITION, (OperationStepHandler)ADD_HANDLER);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SECRET_VALUE, null, (OperationStepHandler)new WriteSecretAttributeHandler());
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ENTRY_TYPE, null);
    }

    private static CredentialStore getCredentialStore(ModelNode operation, OperationContext context) throws IllegalArgumentException, IllegalStateException, ServiceNotFoundException, UnsupportedOperationException {
        ServiceName credentialStoreServiceName = CredentialStoreResourceDefinition.CREDENTIAL_STORE_UTIL.serviceName(operation);
        ServiceController serviceContainer = context.getServiceRegistry(false).getRequiredService(credentialStoreServiceName);
        CredentialStore credentialStore = ((CredentialStoreService)serviceContainer.getService()).getValue();
        return credentialStore;
    }

    private static void storeSecret(CredentialStore credentialStore, String alias, String secretValue) throws CredentialStoreException {
        char[] secret = secretValue != null ? secretValue.toCharArray() : new char[]{};
        credentialStore.store(alias, (Credential)CredentialStoreAliasDefinition.createCredentialFromPassword(secret));
        credentialStore.flush();
    }

    static PasswordCredential createCredentialFromPassword(char[] password) throws UnsupportedCredentialTypeException {
        try {
            PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
            return new PasswordCredential(passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(password)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnsupportedCredentialTypeException((Throwable)e);
        }
    }

    static {
        List<String> entryTypes = Stream.of(SUPPORTED_CREDENTIAL_TYPES).map(Class::getCanonicalName).collect(Collectors.toList());
        ENTRY_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("entry-type", ModelType.STRING, true).setStorageRuntime()).setAllowedValues(entryTypes.toArray(new String[entryTypes.size()]))).build();
        RESOURCE_DESCRIPTION_RESOLVER = ElytronExtension.getResourceDescriptionResolver("credential-store", "alias");
        SECRET_VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secret-value", ModelType.STRING, true).setStorageRuntime()).setMinSize(0)).build();
        CONFIG_ATTRIBUTES = new AttributeDefinition[]{SECRET_VALUE, ENTRY_TYPE};
        ADD_DEFINITION = new SimpleOperationDefinitionBuilder("add", (ResourceDescriptionResolver)RESOURCE_DESCRIPTION_RESOLVER).setParameters(new AttributeDefinition[]{SECRET_VALUE, ENTRY_TYPE}).build();
        ADD_HANDLER = new AddHandler();
    }

    private static class WriteSecretAttributeHandler
    extends ElytronWriteAttributeHandler<String> {
        WriteSecretAttributeHandler() {
            super(new AttributeDefinition[]{SECRET_VALUE});
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<String> handbackHolder) throws OperationFailedException {
            String alias = context.getCurrentAddressValue();
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            String secretValue = resolvedValue.asString();
            String entryType = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ENTRY_TYPE, resource.getModel());
            CredentialStore credentialStore = CredentialStoreAliasDefinition.getCredentialStore(operation, context);
            try {
                if (entryType == null || "clear".equals(entryType)) {
                    CredentialStoreAliasDefinition.storeSecret(credentialStore, alias, secretValue);
                    return false;
                }
                String credentialStoreName = CredentialStoreResourceDefinition.credentialStoreName(operation);
                throw ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreEntryTypeNotSupported(credentialStoreName, entryType);
            }
            catch (CredentialStoreException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, e.getLocalizedMessage());
            }
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handback) throws OperationFailedException {
            String alias = context.getCurrentAddressValue();
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            String secretValue = valueToRestore.asString();
            String entryType = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ENTRY_TYPE, resource.getModel());
            CredentialStore credentialStore = CredentialStoreAliasDefinition.getCredentialStore(operation, context);
            try {
                if (entryType == null || "clear".equals(entryType)) {
                    CredentialStoreAliasDefinition.storeSecret(credentialStore, alias, secretValue);
                }
            }
            catch (CredentialStoreException e) {
                ElytronSubsystemMessages.ROOT_LOGGER.error((Object)ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, e.getLocalizedMessage()), e);
            }
        }
    }

    private static class RemoveHandler
    extends CredentialStoreResourceDefinition.CredentialStoreRuntimeOnlyHandler {
        RemoveHandler() {
            super(true, true);
        }

        @Override
        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, CredentialStoreService credentialStoreService) throws OperationFailedException {
            try {
                CredentialStore credentialStore = credentialStoreService.getValue();
                credentialStore.remove(context.getCurrentAddressValue(), PasswordCredential.class);
                credentialStore.flush();
            }
            catch (CredentialStoreException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    private static class AddHandler
    extends BaseAddHandler {
        AddHandler() {
            super(CONFIG_ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            String alias = context.getCurrentAddressValue();
            String secretValue = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)SECRET_VALUE, resource.getModel());
            String entryType = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ENTRY_TYPE, resource.getModel());
            CredentialStore credentialStore = CredentialStoreAliasDefinition.getCredentialStore(operation, context);
            try {
                if (entryType == null || entryType.equals(PasswordCredential.class.getCanonicalName())) {
                    if (credentialStore.exists(alias, PasswordCredential.class)) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.credentialAlreadyExists(alias, PasswordCredential.class.getName());
                    }
                } else {
                    String credentialStoreName = CredentialStoreResourceDefinition.credentialStoreName(operation);
                    throw ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreEntryTypeNotSupported(credentialStoreName, entryType);
                }
                CredentialStoreAliasDefinition.storeSecret(credentialStore, alias, secretValue);
            }
            catch (CredentialStoreException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, e.getLocalizedMessage());
            }
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String aliasName;
            if (!CredentialStoreResourceDefinition.CASE_SENSITIVE.resolveModelAttribute(context, context.readResourceFromRoot(context.getCurrentAddress().getParent(), false).getModel()).asBoolean() && !(aliasName = context.getCurrentAddressValue()).equals(aliasName.toLowerCase(Locale.ROOT))) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidAliasName(aliasName, context.getCurrentAddress().getParent().getLastElement().getValue());
            }
            super.execute(context, operation);
        }
    }
}

