/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities._private.SecurityEventListener;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.AuditLogger;
import org.wildfly.security.audit.EventPriority;
import org.wildfly.security.audit.FileAuditEndpoint;
import org.wildfly.security.audit.JsonSecurityEventFormatter;
import org.wildfly.security.audit.RotatingFileAuditEndpoint;
import org.wildfly.security.audit.SimpleSecurityEventFormatter;
import org.wildfly.security.audit.SyslogAuditEndpoint;
import org.wildfly.security.auth.server.event.SecurityEventVisitor;

class AuditResourceDefinitions {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(FileAttributeDefinitions.PATH).setRequired(true)).build();
    static final SimpleAttributeDefinition SYNCHRONIZED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("synchronized", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition FORMAT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("format", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode(Format.SIMPLE.toString()))).setAllowedValues(new String[]{Format.SIMPLE.toString(), Format.JSON.toString()})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SERVER_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-address", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition TRANSPORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("transport", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode(Transport.TCP.toString()))).setAllowedValues(new String[]{Transport.TCP.toString(), Transport.UDP.toString(), Transport.SSL_TCP.toString()})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition HOST_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host-name", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MAX_BACKUP_INDEX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-backup-index", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(1))).setValidator((ParameterValidator)new IntRangeValidator(1, true))).build();
    static final SimpleAttributeDefinition ROTATE_ON_BOOT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rotate-on-boot", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    static final SimpleAttributeDefinition ROTATE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rotate-size", ModelType.LONG, true).setAllowExpression(true)).setDefaultValue(new ModelNode(2000))).build();
    static final SimpleAttributeDefinition SUFFIX = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("suffix", ModelType.STRING, true).setAllowExpression(true)).build();
    private static final AggregateComponentDefinition<SecurityEventListener> AGGREGATE_SECURITY_EVENT_LISTENER = AggregateComponentDefinition.create(SecurityEventListener.class, "aggregate-security-event-listener", "security-event-listeners", Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY, SecurityEventListener::aggregate, false);
    static final ListAttributeDefinition REFERENCES = AGGREGATE_SECURITY_EVENT_LISTENER.getReferencesAttribute();
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    AuditResourceDefinitions() {
    }

    static AggregateComponentDefinition<SecurityEventListener> getAggregateSecurityEventListenerDefinition() {
        return AGGREGATE_SECURITY_EVENT_LISTENER;
    }

    static ResourceDefinition getFileAuditLogResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PATH, FileAttributeDefinitions.RELATIVE_TO, SYNCHRONIZED, FORMAT};
        TrivialAddHandler<SecurityEventListener> add = new TrivialAddHandler<SecurityEventListener>(SecurityEventListener.class, attributes, new RuntimeCapability[]{Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SecurityEventListener> getValueSupplier(ServiceBuilder<SecurityEventListener> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                boolean synv = SYNCHRONIZED.resolveModelAttribute(context, model).asBoolean();
                Format format = Format.valueOf(FORMAT.resolveModelAttribute(context, model).asString());
                InjectedValue pathManager = new InjectedValue();
                String path = PATH.resolveModelAttribute(context, model).asString();
                String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, model);
                if (relativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManager);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
                }
                return () -> {
                    AuditEndpoint endpoint;
                    FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                    pathResolver.path(path);
                    if (relativeTo != null) {
                        pathResolver.relativeTo(relativeTo, (PathManager)pathManager.getValue());
                    }
                    File resolvedPath = pathResolver.resolve();
                    SecurityEventVisitor formatter = Format.JSON == format ? JsonSecurityEventFormatter.builder().setDateFormatSupplier(AuditResourceDefinitions.bind(SimpleDateFormat::new, AuditResourceDefinitions.DATE_FORMAT)).build() : SimpleSecurityEventFormatter.builder().setDateFormatSupplier(AuditResourceDefinitions.bind(SimpleDateFormat::new, AuditResourceDefinitions.DATE_FORMAT)).build();
                    try {
                        endpoint = FileAuditEndpoint.builder().setLocation(resolvedPath.toPath()).setSyncOnAccept(synv).setDateFormatSupplier(AuditResourceDefinitions.bind(SimpleDateFormat::new, AuditResourceDefinitions.DATE_FORMAT)).build();
                    }
                    catch (IOException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                    }
                    return SecurityEventListener.from(AuditLogger.builder().setPriorityMapper(m -> EventPriority.WARNING).setMessageFormatter(m -> (String)m.accept(formatter, null)).setAuditEndpoint((ExceptionBiConsumer)endpoint).build());
                };
            }
        };
        return new TrivialResourceDefinition("file-audit-log", add, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getRotatingFileAuditLogResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PATH, FileAttributeDefinitions.RELATIVE_TO, SYNCHRONIZED, FORMAT, MAX_BACKUP_INDEX, ROTATE_ON_BOOT, ROTATE_SIZE, SUFFIX};
        TrivialAddHandler<SecurityEventListener> add = new TrivialAddHandler<SecurityEventListener>(SecurityEventListener.class, attributes, new RuntimeCapability[]{Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SecurityEventListener> getValueSupplier(ServiceBuilder<SecurityEventListener> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                boolean synv = SYNCHRONIZED.resolveModelAttribute(context, model).asBoolean();
                Format format = Format.valueOf(FORMAT.resolveModelAttribute(context, model).asString());
                int maxBackupIndex = MAX_BACKUP_INDEX.resolveModelAttribute(context, model).asInt(0);
                boolean rotateOnBoot = ROTATE_ON_BOOT.resolveModelAttribute(context, model).asBoolean();
                long rotateSize = ROTATE_SIZE.resolveModelAttribute(context, model).asLong(0L);
                String suffix = SUFFIX.resolveModelAttribute(context, model).asString();
                InjectedValue pathManager = new InjectedValue();
                String path = PATH.resolveModelAttribute(context, model).asString();
                String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, model);
                if (relativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManager);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
                }
                return () -> {
                    AuditEndpoint endpoint;
                    FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                    pathResolver.path(path);
                    if (relativeTo != null) {
                        pathResolver.relativeTo(relativeTo, (PathManager)pathManager.getValue());
                    }
                    File resolvedPath = pathResolver.resolve();
                    SecurityEventVisitor formatter = Format.JSON == format ? JsonSecurityEventFormatter.builder().build() : SimpleSecurityEventFormatter.builder().build();
                    try {
                        endpoint = RotatingFileAuditEndpoint.builder().setMaxBackupIndex(maxBackupIndex).setRotateOnBoot(rotateOnBoot).setRotateSize(rotateSize).setSuffix(suffix).setLocation(resolvedPath.toPath()).setSyncOnAccept(synv).build();
                    }
                    catch (IOException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                    }
                    return SecurityEventListener.from(AuditLogger.builder().setPriorityMapper(m -> EventPriority.WARNING).setMessageFormatter(m -> (String)m.accept(formatter, null)).setAuditEndpoint((ExceptionBiConsumer)endpoint).build());
                };
            }
        };
        return new TrivialResourceDefinition("rotating-file-audit-log", add, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getSyslogAuditLogResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{SERVER_ADDRESS, PORT, TRANSPORT, HOST_NAME, FORMAT};
        TrivialAddHandler<SecurityEventListener> add = new TrivialAddHandler<SecurityEventListener>(SecurityEventListener.class, attributes, new RuntimeCapability[]{Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SecurityEventListener> getValueSupplier(ServiceBuilder<SecurityEventListener> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InetAddress serverAddress;
                String address = SERVER_ADDRESS.resolveModelAttribute(context, model).asString();
                try {
                    serverAddress = InetAddress.getByName(address);
                }
                catch (UnknownHostException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.serverNotKnown(address, e);
                }
                int port = PORT.resolveModelAttribute(context, model).asInt();
                Transport transport = Transport.valueOf(TRANSPORT.resolveModelAttribute(context, model).asString());
                String hostName = HOST_NAME.resolveModelAttribute(context, model).asString();
                Format format = Format.valueOf(FORMAT.resolveModelAttribute(context, model).asString());
                return () -> {
                    AuditEndpoint endpoint;
                    SecurityEventVisitor formatter = Format.JSON == format ? JsonSecurityEventFormatter.builder().setDateFormatSupplier(AuditResourceDefinitions.bind(SimpleDateFormat::new, AuditResourceDefinitions.DATE_FORMAT)).build() : SimpleSecurityEventFormatter.builder().setDateFormatSupplier(AuditResourceDefinitions.bind(SimpleDateFormat::new, AuditResourceDefinitions.DATE_FORMAT)).build();
                    try {
                        endpoint = SyslogAuditEndpoint.builder().setServerAddress(serverAddress).setPort(port).setSsl(transport == Transport.SSL_TCP).setTcp(transport == Transport.TCP || transport == Transport.SSL_TCP).setHostName(hostName).build();
                    }
                    catch (IOException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                    }
                    return SecurityEventListener.from(AuditLogger.builder().setPriorityMapper(m -> EventPriority.WARNING).setMessageFormatter(m -> (String)m.accept(formatter, null)).setAuditEndpoint((ExceptionBiConsumer)endpoint).build());
                };
            }
        };
        return new TrivialResourceDefinition("syslog-audit-log", add, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY);
    }

    private static <T, R> Supplier<R> bind(Function<T, R> fn, T val) {
        return () -> fn.apply(val);
    }

    private static enum Transport {
        TCP,
        UDP,
        SSL_TCP;

    }

    private static enum Format {
        SIMPLE,
        JSON;

    }
}

