/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.ProviderDefinitions;

class ProviderParser {
    private final PersistentResourceXMLDescription providerLoaderParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"provider-loader"), null).setUseElementsForGroups(false).addAttributes(new AttributeDefinition[]{ClassLoadingAttributeDefinitions.MODULE, ClassLoadingAttributeDefinitions.CLASS_NAMES, ProviderDefinitions.PATH, ProviderDefinitions.RELATIVE_TO, ProviderDefinitions.ARGUMENT, ProviderDefinitions.CONFIGURATION}).build();

    ProviderParser() {
    }

    void readProviders(ModelNode parentAddressNode, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            PathAddress parentAddress = PathAddress.pathAddress((ModelNode)parentAddressNode);
            switch (localName) {
                case "aggregate-providers": {
                    this.readAggregateProviders(parentAddressNode, reader, operations);
                    continue block8;
                }
                case "provider-loader": {
                    this.providerLoaderParser.parse(reader, parentAddress, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readAggregateProviders(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addProviders = new ModelNode();
        addProviders.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addProviders.get("address").set(parentAddress).add("aggregate-providers", name);
        operations.add(addProviders);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"providers".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String providersName = reader.getAttributeValue(0);
            ProviderDefinitions.REFERENCES.parseAndAddParameterElement(providersName, addProviders, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    void writeProviders(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!this.shouldWrite(subsystem)) {
            return;
        }
        writer.writeStartElement("providers");
        this.writeAggregateProviders(subsystem, writer);
        this.providerLoaderParser.persist(writer, subsystem);
        writer.writeEndElement();
    }

    private void writeAggregateProviders(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-providers")) {
            ModelNode aggregateProviders = subsystem.require("aggregate-providers");
            for (String name : aggregateProviders.keys()) {
                ModelNode aggregateProvider = aggregateProviders.require(name);
                writer.writeStartElement("aggregate-providers");
                writer.writeAttribute("name", name);
                List providersReferences = aggregateProvider.get("providers").asList();
                for (ModelNode currentReference : providersReferences) {
                    writer.writeStartElement("providers");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
    }

    private boolean shouldWrite(ModelNode subsystem) {
        return subsystem.hasDefined("aggregate-providers") || subsystem.hasDefined("provider-loader");
    }
}

