/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.CommonAttributes;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;

class AuthenticationClientDefinitions {
    static final SimpleAttributeDefinition CONFIGURATION_EXTENDS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("extends", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.authentication-configuration", Capabilities.AUTHENTICATION_CONFIGURATION_RUNTIME_CAPABILITY)).build();
    static final SimpleAttributeDefinition ANONYMOUS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("anonymous", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setAlternatives(new String[]{"authentication-name", "security-domain"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition AUTHENTICATION_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-name", ModelType.STRING, true).setAllowExpression(true)).setAlternatives(new String[]{"anonymous", "security-domain"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition AUTHORIZATION_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authorization-name", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAlternatives(new String[]{"anonymous", "authentication-name"})).setCapabilityReference("org.wildfly.security.security-domain", Capabilities.AUTHENTICATION_CONFIGURATION_RUNTIME_CAPABILITY)).build();
    static final SimpleAttributeDefinition ALLOW_ALL_MECHANISMS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("allow-all-mechanisms", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAlternatives(new String[]{"allow-sasl-mechanisms"})).build();
    static final StringListAttributeDefinition ALLOW_SASL_MECHANISMS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("allow-sasl-mechanisms").setMinSize(0)).setRequired(false)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAlternatives(new String[]{"allow-all-mechanisms"})).build();
    static final StringListAttributeDefinition FORBID_SASL_MECHANISMS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("forbid-sasl-mechanisms").setMinSize(0)).setRequired(false)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleMapAttributeDefinition MECHANISM_PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder(CommonAttributes.PROPERTIES).setName("mechanism-properties")).setXmlName("mechanism-properties")).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = CredentialReference.getAttributeBuilder((boolean)true, (boolean)true).build();
    static final AttributeDefinition[] AUTHENTICATION_CONFIGURATION_SIMPLE_ATTRIBUTES = new AttributeDefinition[]{CONFIGURATION_EXTENDS, ANONYMOUS, AUTHENTICATION_NAME, AUTHORIZATION_NAME, HOST, PROTOCOL, PORT, REALM, SECURITY_DOMAIN, ALLOW_ALL_MECHANISMS, ALLOW_SASL_MECHANISMS, FORBID_SASL_MECHANISMS};
    static final AttributeDefinition[] AUTHENTICATION_CONFIGURATION_ALL_ATTRIBUTES = new AttributeDefinition[]{CONFIGURATION_EXTENDS, ANONYMOUS, AUTHENTICATION_NAME, AUTHORIZATION_NAME, HOST, PROTOCOL, PORT, REALM, SECURITY_DOMAIN, ALLOW_ALL_MECHANISMS, ALLOW_SASL_MECHANISMS, FORBID_SASL_MECHANISMS, MECHANISM_PROPERTIES, CREDENTIAL_REFERENCE};
    static final SimpleAttributeDefinition MATCH_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-user", ModelType.STRING, true).setAllowExpression(true)).setAlternatives(new String[]{"match-no-user"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_NO_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-no-user", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setAlternatives(new String[]{"match-user"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_URN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-urn", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_LOCAL_SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-local-security-domain", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_PURPOSE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-purpose", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-protocol", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_ABSTRACT_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-abstract-type", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_ABSTRACT_TYPE_AUTHORITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-abstract-type-authority", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-host", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-path", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-port", ModelType.INT, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CONTEXT_EXTENDS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("extends", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.authentication-context", Capabilities.AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY)).build();
    static final SimpleAttributeDefinition AUTHENTICATION_CONFIGURATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-configuration", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.authentication-configuration", Capabilities.AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY)).build();
    static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.ssl-context", Capabilities.AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY)).build();
    static final ObjectTypeAttributeDefinition MATCH_RULE = new ObjectTypeAttributeDefinition.Builder("match-rule", new AttributeDefinition[]{MATCH_ABSTRACT_TYPE, MATCH_ABSTRACT_TYPE_AUTHORITY, MATCH_HOST, MATCH_LOCAL_SECURITY_DOMAIN, MATCH_NO_USER, MATCH_PATH, MATCH_PORT, MATCH_PROTOCOL, MATCH_PURPOSE, MATCH_URN, MATCH_USER, AUTHENTICATION_CONFIGURATION, SSL_CONTEXT}).build();
    static final ObjectListAttributeDefinition MATCH_RULES = new ObjectListAttributeDefinition.Builder("match-rules", MATCH_RULE).setAllowNull(true).build();

    AuthenticationClientDefinitions() {
    }

    static ResourceDefinition getAuthenticationClientDefinition() {
        TrivialAddHandler<AuthenticationConfiguration> add = new TrivialAddHandler<AuthenticationConfiguration>(AuthenticationConfiguration.class, AUTHENTICATION_CONFIGURATION_ALL_ATTRIBUTES, new RuntimeCapability[]{Capabilities.AUTHENTICATION_CONFIGURATION_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<AuthenticationConfiguration> getValueSupplier(ServiceBuilder<AuthenticationConfiguration> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                ModelNode credentialReference;
                boolean allowAllMechanisms;
                Supplier<AuthenticationConfiguration> parentSupplier;
                String parent = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CONFIGURATION_EXTENDS, model);
                if (parent != null) {
                    InjectedValue parentInjector = new InjectedValue();
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.authentication-configuration", (String)parent), AuthenticationConfiguration.class), AuthenticationConfiguration.class, (Injector)parentInjector);
                    parentSupplier = () -> ((InjectedValue)parentInjector).getValue();
                } else {
                    parentSupplier = () -> AuthenticationConfiguration.EMPTY;
                }
                Function<AuthenticationConfiguration, AuthenticationConfiguration> configuration = ignored -> (AuthenticationConfiguration)parentSupplier.get();
                boolean anonymous = ANONYMOUS.resolveModelAttribute(context, model).asBoolean();
                configuration = anonymous ? configuration.andThen(c -> c.useAnonymous()) : configuration;
                String authenticationName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)AUTHENTICATION_NAME, model);
                configuration = authenticationName != null ? configuration.andThen(c -> c.useName(authenticationName)) : configuration;
                String authorizationName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)AUTHORIZATION_NAME, model);
                configuration = authorizationName != null ? configuration.andThen(c -> c.useAuthorizationName(authorizationName)) : configuration;
                String host = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)HOST, model);
                configuration = host != null ? configuration.andThen(c -> c.useHost(host)) : configuration;
                String protocol = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROTOCOL, model);
                configuration = protocol != null ? configuration.andThen(c -> c.useProtocol(protocol)) : configuration;
                int port = ElytronExtension.asIntIfDefined(context, PORT, model);
                configuration = port > 0 ? configuration.andThen(c -> c.usePort(port)) : configuration;
                String realm = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)REALM, model);
                configuration = realm != null ? configuration.andThen(c -> c.useRealm(realm)) : configuration;
                String securityDomain = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)SECURITY_DOMAIN, model);
                if (securityDomain != null) {
                    InjectedValue securityDomainInjector = new InjectedValue();
                    serviceBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.security.security-domain", securityDomain, SecurityDomain.class), SecurityDomain.class, (Injector)securityDomainInjector);
                    configuration = configuration.andThen(c -> c.useForwardedIdentity((SecurityDomain)securityDomainInjector.getValue()));
                }
                configuration = (allowAllMechanisms = ALLOW_ALL_MECHANISMS.resolveModelAttribute(context, model).asBoolean()) ? configuration.andThen(c -> c.allowAllSaslMechanisms()) : configuration;
                List allowedMechanisms = ALLOW_SASL_MECHANISMS.unwrap((ExpressionResolver)context, model);
                configuration = allowedMechanisms.size() > 0 ? configuration.andThen(c -> c.allowSaslMechanisms(allowedMechanisms.toArray(new String[allowedMechanisms.size()]))) : configuration;
                List forbiddenMechanisms = FORBID_SASL_MECHANISMS.unwrap((ExpressionResolver)context, model);
                configuration = forbiddenMechanisms.size() > 0 ? configuration.andThen(c -> c.forbidSaslMechanisms(forbiddenMechanisms.toArray(new String[forbiddenMechanisms.size()]))) : configuration;
                ModelNode properties = MECHANISM_PROPERTIES.resolveModelAttribute(context, model);
                if (properties.isDefined()) {
                    HashMap propertiesMap = new HashMap();
                    properties.keys().forEach(s -> propertiesMap.put(s, properties.require(s).asString()));
                    configuration = configuration.andThen(c -> c.useMechanismProperties(propertiesMap));
                }
                if ((credentialReference = CREDENTIAL_REFERENCE.resolveModelAttribute(context, model)).isDefined()) {
                    InjectedValue credentialSourceSupplierInjector = new InjectedValue();
                    credentialSourceSupplierInjector.inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)model, serviceBuilder));
                    configuration = configuration.andThen(c -> {
                        ExceptionSupplier sourceSupplier = (ExceptionSupplier)credentialSourceSupplierInjector.getValue();
                        try {
                            CredentialSource cs = (CredentialSource)sourceSupplier.get();
                            if (cs != null) {
                                return c.usePassword(((PasswordCredential)cs.getCredential(PasswordCredential.class)).getPassword());
                            }
                            throw ElytronSubsystemMessages.ROOT_LOGGER.credentialCannotBeResolved();
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    });
                }
                Function<AuthenticationConfiguration, AuthenticationConfiguration> finalConfiguration = configuration;
                return () -> (AuthenticationConfiguration)finalConfiguration.apply(null);
            }
        };
        return new TrivialResourceDefinition("authentication-configuration", add, AUTHENTICATION_CONFIGURATION_ALL_ATTRIBUTES, Capabilities.AUTHENTICATION_CONFIGURATION_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getAuthenticationContextDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{CONTEXT_EXTENDS, MATCH_RULES};
        TrivialAddHandler<AuthenticationContext> add = new TrivialAddHandler<AuthenticationContext>(AuthenticationContext.class, attributes, new RuntimeCapability[]{Capabilities.AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<AuthenticationContext> getValueSupplier(ServiceBuilder<AuthenticationContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                Supplier<AuthenticationContext> parentSupplier;
                String parent = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CONTEXT_EXTENDS, model);
                if (parent != null) {
                    InjectedValue parentInjector = new InjectedValue();
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.authentication-context", (String)parent), AuthenticationContext.class), AuthenticationContext.class, (Injector)parentInjector);
                    parentSupplier = () -> ((InjectedValue)parentInjector).getValue();
                } else {
                    parentSupplier = AuthenticationContext::empty;
                }
                Function authContext = Function.identity();
                if (model.hasDefined("match-rules")) {
                    List nodes = model.require("match-rules").asList();
                    for (ModelNode current : nodes) {
                        String authenticationConfiguration = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)AUTHENTICATION_CONFIGURATION, current);
                        String sslContext = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)SSL_CONTEXT, current);
                        if (authenticationConfiguration == null && sslContext == null) continue;
                        Function<MatchRule, MatchRule> matchRule = ignored -> MatchRule.ALL;
                        String abstractType = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)MATCH_ABSTRACT_TYPE, current);
                        String abstractTypeAuthority = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)MATCH_ABSTRACT_TYPE_AUTHORITY, current);
                        matchRule = abstractType != null || abstractTypeAuthority != null ? matchRule.andThen(m -> m.matchAbstractType(abstractType, abstractTypeAuthority)) : matchRule;
                        ModelNode host = MATCH_HOST.resolveModelAttribute(context, current);
                        matchRule = host.isDefined() ? matchRule.andThen(m -> m.matchHost(host.asString())) : matchRule;
                        ModelNode localSecurityDomain = MATCH_LOCAL_SECURITY_DOMAIN.resolveModelAttribute(context, current);
                        matchRule = localSecurityDomain.isDefined() ? matchRule.andThen(m -> m.matchLocalSecurityDomain(localSecurityDomain.asString())) : matchRule;
                        ModelNode matchNoUser = MATCH_NO_USER.resolveModelAttribute(context, current);
                        matchRule = matchNoUser.asBoolean() ? matchRule.andThen(m -> m.matchNoUser()) : matchRule;
                        ModelNode path = MATCH_PATH.resolveModelAttribute(context, current);
                        matchRule = path.isDefined() ? matchRule.andThen(m -> m.matchPath(path.asString())) : matchRule;
                        ModelNode port = MATCH_PORT.resolveModelAttribute(context, current);
                        matchRule = port.isDefined() ? matchRule.andThen(m -> m.matchPort(port.asInt())) : matchRule;
                        ModelNode protocol = MATCH_PROTOCOL.resolveModelAttribute(context, current);
                        matchRule = protocol.isDefined() ? matchRule.andThen(m -> m.matchProtocol(protocol.asString())) : matchRule;
                        ModelNode purpose = MATCH_PURPOSE.resolveModelAttribute(context, current);
                        matchRule = purpose.isDefined() ? matchRule.andThen(m -> m.matchPurpose(purpose.asString())) : matchRule;
                        ModelNode urn = MATCH_URN.resolveModelAttribute(context, current);
                        matchRule = urn.isDefined() ? matchRule.andThen(m -> m.matchUrnName(urn.asString())) : matchRule;
                        ModelNode user = MATCH_USER.resolveModelAttribute(context, current);
                        Function<MatchRule, MatchRule> finalMatchRule = matchRule = user.isDefined() ? matchRule.andThen(m -> m.matchUser(user.asString())) : matchRule;
                        OneTimeSupplier<MatchRule> matchRuleSuppler = new OneTimeSupplier<MatchRule>(() -> (MatchRule)finalMatchRule.apply(null));
                        if (authenticationConfiguration != null) {
                            InjectedValue authenticationConfigurationInjector = new InjectedValue();
                            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.authentication-configuration", (String)authenticationConfiguration), AuthenticationConfiguration.class), AuthenticationConfiguration.class, (Injector)authenticationConfigurationInjector);
                            authContext = authContext.andThen(a -> a.with((MatchRule)matchRuleSuppler.get(), (AuthenticationConfiguration)authenticationConfigurationInjector.getValue()));
                        }
                        if (sslContext == null) continue;
                        InjectedValue sslContextInjector = new InjectedValue();
                        serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.ssl-context", (String)sslContext), SSLContext.class), SSLContext.class, (Injector)sslContextInjector);
                        authContext = authContext.andThen(a -> a.withSsl((MatchRule)matchRuleSuppler.get(), () -> ((InjectedValue)sslContextInjector).getValue()));
                    }
                }
                Function finalContext = authContext;
                return () -> (AuthenticationContext)finalContext.apply(parentSupplier.get());
            }
        };
        return new TrivialResourceDefinition("authentication-context", add, attributes, Capabilities.AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY);
    }

    static final class OneTimeSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;
        private T value;

        OneTimeSupplier(Supplier<T> supplier) {
            Assert.checkNotNullParam((String)"supplier", supplier);
            this.supplier = supplier;
        }

        @Override
        public T get() {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            return this.value;
        }
    }
}

