/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AuditResourceDefinitions;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.FileAttributeDefinitions;

class AuditLoggingParser {
    private final PersistentResourceXMLDescription fileAuditLogParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"file-audit-log"), null).setUseElementsForGroups(false).addAttributes(new AttributeDefinition[]{AuditResourceDefinitions.PATH, FileAttributeDefinitions.RELATIVE_TO, AuditResourceDefinitions.SYNCHRONIZED, AuditResourceDefinitions.FORMAT}).build();
    private final PersistentResourceXMLDescription syslogAuditLogParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"syslog-audit-log"), null).setUseElementsForGroups(false).addAttributes(new AttributeDefinition[]{AuditResourceDefinitions.SERVER_ADDRESS, AuditResourceDefinitions.PORT, AuditResourceDefinitions.TRANSPORT, AuditResourceDefinitions.FORMAT, AuditResourceDefinitions.HOST_NAME}).build();

    AuditLoggingParser() {
    }

    void readAuditLogging(ModelNode parentAddressNode, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            PathAddress parentAddress = PathAddress.pathAddress((ModelNode)parentAddressNode);
            switch (localName) {
                case "aggregate-security-event-listener": {
                    this.readAggregateSecurityEventListener(parentAddress.toModelNode(), reader, operations);
                    continue block10;
                }
                case "file-audit-log": {
                    this.fileAuditLogParser.parse(reader, parentAddress, operations);
                    continue block10;
                }
                case "syslog-audit-log": {
                    this.syslogAuditLogParser.parse(reader, parentAddress, operations);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readAggregateSecurityEventListener(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addEventListener = new ModelNode();
        addEventListener.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addEventListener.get("address").set(parentAddress).add("aggregate-security-event-listener", name);
        operations.add(addEventListener);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"security-event-listener".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String listenerName = reader.getAttributeValue(0);
            AuditResourceDefinitions.REFERENCES.parseAndAddParameterElement(listenerName, addEventListener, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void writeAggregateSecurityEventListener(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-security-event-listener")) {
            ModelNode aggregateSecurityEventListener = subsystem.require("aggregate-security-event-listener");
            for (String name : aggregateSecurityEventListener.keys()) {
                ModelNode aggregateListener = aggregateSecurityEventListener.require(name);
                writer.writeStartElement("aggregate-security-event-listener");
                writer.writeAttribute("name", name);
                List listenerReferences = aggregateListener.get("security-event-listeners").asList();
                for (ModelNode currentReference : listenerReferences) {
                    writer.writeStartElement("security-event-listener");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
    }

    void writeAuditLogging(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!this.shouldWrite(subsystem)) {
            return;
        }
        writer.writeStartElement("audit-logging");
        this.writeAggregateSecurityEventListener(subsystem, writer);
        this.fileAuditLogParser.persist(writer, subsystem);
        this.syslogAuditLogParser.persist(writer, subsystem);
        writer.writeEndElement();
    }

    private boolean shouldWrite(ModelNode subsystem) {
        return subsystem.hasDefined("aggregate-security-event-listener") || subsystem.hasDefined("file-audit-log") || subsystem.hasDefined("syslog-audit-log");
    }
}

