/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.FilteringKeyStoreDefinition;
import org.wildfly.extension.elytron.KeyStoreDefinition;
import org.wildfly.extension.elytron.LdapKeyStoreDefinition;
import org.wildfly.extension.elytron.SSLDefinitions;

class TlsParser {
    TlsParser() {
    }

    void readTls(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean keyManagersFound = false;
        boolean keyStoresFound = false;
        boolean trustManagersFound = false;
        boolean serverSSLContextsFound = false;
        boolean clientSSLContextsFound = false;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("key-managers".equals(localName) && !keyManagersFound) {
                keyManagersFound = true;
                this.readKeyManagers(parentAddress, reader, operations);
                continue;
            }
            if ("key-stores".equals(localName) && !keyStoresFound) {
                keyStoresFound = true;
                this.readKeyStores(parentAddress, reader, operations);
                continue;
            }
            if ("trust-managers".equals(localName) && !trustManagersFound) {
                trustManagersFound = true;
                this.readTrustManagers(parentAddress, reader, operations);
                continue;
            }
            if ("server-ssl-contexts".equals(localName) && !serverSSLContextsFound) {
                serverSSLContextsFound = true;
                this.readServerSSLContexts(parentAddress, reader, operations);
                continue;
            }
            if ("client-ssl-contexts".equals(localName) && !clientSSLContextsFound) {
                clientSSLContextsFound = true;
                this.readClientSSLContexts(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readKeyManagers(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("key-manager".equals(localName)) {
                this.readKeyManager(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readKeyManager(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addKeyManager = new ModelNode();
        addKeyManager.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "algorithm"));
        String name = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block16;
                }
                case "algorithm": {
                    SSLDefinitions.ALGORITHM.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block16;
                }
                case "key-store": {
                    SSLDefinitions.KEYSTORE.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block16;
                }
                case "alias-filter": {
                    SSLDefinitions.ALIAS_FILTER.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block16;
                }
                case "providers": {
                    SSLDefinitions.PROVIDERS.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block16;
                }
                case "provider-name": {
                    SSLDefinitions.PROVIDER_NAME.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addKeyManager.get("address").set(parentAddress).add("key-managers", name);
        list.add(addKeyManager);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("credential-reference".equals(localName)) {
                CredentialReference.getAttributeDefinition().getParser().parseElement((AttributeDefinition)CredentialReference.getAttributeDefinition(), reader, addKeyManager);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readTrustManagers(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("trust-manager".equals(localName)) {
                this.readTrustManager(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readTrustManager(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addKeyManager = new ModelNode();
        addKeyManager.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "algorithm"));
        String name = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block16;
                }
                case "algorithm": {
                    SSLDefinitions.ALGORITHM.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block16;
                }
                case "key-store": {
                    SSLDefinitions.KEYSTORE.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block16;
                }
                case "alias-filter": {
                    SSLDefinitions.ALIAS_FILTER.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block16;
                }
                case "providers": {
                    SSLDefinitions.PROVIDERS.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block16;
                }
                case "provider-name": {
                    SSLDefinitions.PROVIDER_NAME.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addKeyManager.get("address").set(parentAddress).add("trust-managers", name);
        this.readCertificateRevocationList(reader, addKeyManager, requiredAttributes);
        list.add(addKeyManager);
    }

    private void readCertificateRevocationList(XMLExtendedStreamReader reader, ModelNode addKeyManager, Set<String> requiredAttributes) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("certificate-revocation-list".equals(localName)) {
                ModelNode crlNode = new ModelNode().setEmptyObject();
                int count = reader.getAttributeCount();
                block11: for (int i = 0; i < count; ++i) {
                    String value = reader.getAttributeValue(i);
                    if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    String attribute = reader.getAttributeLocalName(i);
                    requiredAttributes.remove(attribute);
                    switch (attribute) {
                        case "path": {
                            FileAttributeDefinitions.PATH.parseAndSetParameter(value, crlNode, (XMLStreamReader)reader);
                            continue block11;
                        }
                        case "relative-to": {
                            FileAttributeDefinitions.RELATIVE_TO.parseAndSetParameter(value, crlNode, (XMLStreamReader)reader);
                            continue block11;
                        }
                        case "maximum-cert-path": {
                            SSLDefinitions.MAXIMUM_CERT_PATH.parseAndSetParameter(value, crlNode, (XMLStreamReader)reader);
                            continue block11;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                addKeyManager.get("certificate-revocation-list").set(crlNode);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readServerSSLContexts(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("server-ssl-context".equals(localName)) {
                this.readServerSSLContext(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readServerSSLContext(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addServerSSLContext = new ModelNode();
        addServerSSLContext.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name"));
        String name = null;
        int count = reader.getAttributeCount();
        block34: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block34;
                }
                case "security-domain": {
                    SSLDefinitions.SECURITY_DOMAIN.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "cipher-suite-filter": {
                    SSLDefinitions.CIPHER_SUITE_FILTER.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "protocols": {
                    for (String protocol : reader.getListAttributeValue(i)) {
                        SSLDefinitions.PROTOCOLS.parseAndAddParameterElement(protocol, addServerSSLContext, (XMLStreamReader)reader);
                    }
                    continue block34;
                }
                case "want-client-auth": {
                    SSLDefinitions.WANT_CLIENT_AUTH.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "need-client-auth": {
                    SSLDefinitions.NEED_CLIENT_AUTH.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "authentication-optional": {
                    SSLDefinitions.AUTHENTICATION_OPTIONAL.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "use-cipher-suites-order": {
                    SSLDefinitions.USE_CIPHER_SUITES_ORDER.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "maximum-session-cache-size": {
                    SSLDefinitions.MAXIMUM_SESSION_CACHE_SIZE.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "session-timeout": {
                    SSLDefinitions.SESSION_TIMEOUT.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "wrap": {
                    SSLDefinitions.WRAP.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "key-managers": {
                    SSLDefinitions.KEY_MANAGERS.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "trust-managers": {
                    SSLDefinitions.TRUST_MANAGERS.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "providers": {
                    SSLDefinitions.PROVIDERS.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                case "provider-name": {
                    SSLDefinitions.PROVIDER_NAME.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block34;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addServerSSLContext.get("address").set(parentAddress).add("server-ssl-context", name);
        list.add(addServerSSLContext);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readClientSSLContexts(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("client-ssl-context".equals(localName)) {
                this.readClientSSLContext(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readClientSSLContext(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addServerSSLContext = new ModelNode();
        addServerSSLContext.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name"));
        String name = null;
        int count = reader.getAttributeCount();
        block24: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block24;
                }
                case "cipher-suite-filter": {
                    SSLDefinitions.CIPHER_SUITE_FILTER.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block24;
                }
                case "protocols": {
                    for (String protocol : reader.getListAttributeValue(i)) {
                        SSLDefinitions.PROTOCOLS.parseAndAddParameterElement(protocol, addServerSSLContext, (XMLStreamReader)reader);
                    }
                    continue block24;
                }
                case "use-cipher-suites-order": {
                    SSLDefinitions.USE_CIPHER_SUITES_ORDER.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block24;
                }
                case "maximum-session-cache-size": {
                    SSLDefinitions.MAXIMUM_SESSION_CACHE_SIZE.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block24;
                }
                case "session-timeout": {
                    SSLDefinitions.SESSION_TIMEOUT.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block24;
                }
                case "key-managers": {
                    SSLDefinitions.KEY_MANAGERS.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block24;
                }
                case "trust-managers": {
                    SSLDefinitions.TRUST_MANAGERS.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block24;
                }
                case "providers": {
                    SSLDefinitions.PROVIDERS.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block24;
                }
                case "provider-name": {
                    SSLDefinitions.PROVIDER_NAME.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block24;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addServerSSLContext.get("address").set(parentAddress).add("client-ssl-context", name);
        list.add(addServerSSLContext);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readKeyStores(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("key-store".equals(localName)) {
                this.readKeyStore(parentAddress, reader, operations);
                continue;
            }
            if ("ldap-key-store".equals(localName)) {
                this.readLdapKeyStore(parentAddress, reader, operations);
                continue;
            }
            if ("filtering-key-store".equals(localName)) {
                this.readFilteringKeyStore(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readKeyStore(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addKeyStore = new ModelNode();
        addKeyStore.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "type"));
        String name = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block16;
                }
                case "type": {
                    KeyStoreDefinition.TYPE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block16;
                }
                case "provider-name": {
                    KeyStoreDefinition.PROVIDER_NAME.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block16;
                }
                case "providers": {
                    KeyStoreDefinition.PROVIDERS.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block16;
                }
                case "password": {
                    KeyStoreDefinition.CREDENTIAL_REFERENCE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block16;
                }
                case "alias-filter": {
                    KeyStoreDefinition.ALIAS_FILTER.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addKeyStore.get("address").set(parentAddress).add("key-store", name);
        list.add(addKeyStore);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("file".equals(localName)) {
                this.readFile(addKeyStore, reader, list);
                continue;
            }
            if ("credential-reference".equals(localName)) {
                CredentialReference.getAttributeDefinition().getParser().parseElement((AttributeDefinition)CredentialReference.getAttributeDefinition(), reader, addKeyStore);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readFile(ModelNode addOp, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        boolean pathFound = false;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "relative-to": {
                    FileAttributeDefinitions.RELATIVE_TO.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case "path": {
                    pathFound = true;
                    FileAttributeDefinitions.PATH.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case "required": {
                    KeyStoreDefinition.REQUIRED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!pathFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"path"});
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readLdapKeyStore(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addKeyStore = new ModelNode();
        addKeyStore.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "dir-context", "search-path"));
        String name = null;
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block20;
                }
                case "dir-context": {
                    LdapKeyStoreDefinition.DIR_CONTEXT.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block20;
                }
                case "search-path": {
                    LdapKeyStoreDefinition.SEARCH_PATH.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block20;
                }
                case "search-recursive": {
                    LdapKeyStoreDefinition.SEARCH_RECURSIVE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block20;
                }
                case "search-time-limit": {
                    LdapKeyStoreDefinition.SEARCH_TIME_LIMIT.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block20;
                }
                case "filter-alias": {
                    LdapKeyStoreDefinition.FILTER_ALIAS.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block20;
                }
                case "filter-certificate": {
                    LdapKeyStoreDefinition.FILTER_CERTIFICATE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block20;
                }
                case "filter-iterate": {
                    LdapKeyStoreDefinition.FILTER_ITERATE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addKeyStore.get("address").set(parentAddress).add("ldap-key-store", name);
        list.add(addKeyStore);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("new-item-template".equals(localName)) {
                this.readNewItemTemplate(addKeyStore, reader, list);
                continue;
            }
            if ("ldap-mapping".equals(localName)) {
                this.readLdapMapping(addKeyStore, reader, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readNewItemTemplate(ModelNode addKeyStore, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("new-item-path", "new-item-rdn"));
        ModelNode newItemTemplate = addKeyStore.get("new-item-template");
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "new-item-path": {
                    LdapKeyStoreDefinition.NewItemTemplateObjectDefinition.NEW_ITEM_PATH.parseAndSetParameter(value, newItemTemplate, (XMLStreamReader)reader);
                    continue block8;
                }
                case "new-item-rdn": {
                    LdapKeyStoreDefinition.NewItemTemplateObjectDefinition.NEW_ITEM_RDN.parseAndSetParameter(value, newItemTemplate, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            if ("attribute".equals(reader.getLocalName())) {
                ModelNode attribute = new ModelNode();
                this.readLdapAttribute(attribute, reader);
                newItemTemplate.get("new-item-attributes").add(attribute);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readLdapAttribute(ModelNode attribute, XMLExtendedStreamReader reader) throws XMLStreamException {
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "value"));
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attributeName = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attributeName);
            switch (attributeName) {
                case "name": {
                    String value = reader.getAttributeValue(i);
                    LdapKeyStoreDefinition.NewItemTemplateAttributeObjectDefinition.NAME.parseAndSetParameter(value, attribute, (XMLStreamReader)reader);
                    continue block8;
                }
                case "value": {
                    for (String val : reader.getListAttributeValue(i)) {
                        LdapKeyStoreDefinition.NewItemTemplateAttributeObjectDefinition.VALUE.parseAndAddParameterElement(val, attribute, (XMLStreamReader)reader);
                    }
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readLdapMapping(ModelNode addKeyStore, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block18: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "alias-attribute": {
                    LdapKeyStoreDefinition.ALIAS_ATTRIBUTE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block18;
                }
                case "certificate-attribute": {
                    LdapKeyStoreDefinition.CERTIFICATE_ATTRIBUTE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block18;
                }
                case "certificate-type": {
                    LdapKeyStoreDefinition.CERTIFICATE_TYPE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block18;
                }
                case "certificate-chain-attribute": {
                    LdapKeyStoreDefinition.CERTIFICATE_CHAIN_ATTRIBUTE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block18;
                }
                case "certificate-chain-encoding": {
                    LdapKeyStoreDefinition.CERTIFICATE_CHAIN_ENCODING.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block18;
                }
                case "key-attribute": {
                    LdapKeyStoreDefinition.KEY_ATTRIBUTE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block18;
                }
                case "key-type": {
                    LdapKeyStoreDefinition.KEY_TYPE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readFilteringKeyStore(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addKeyStore = new ModelNode();
        addKeyStore.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "key-store", "alias-filter"));
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "key-store": {
                    FilteringKeyStoreDefinition.KEY_STORE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block10;
                }
                case "alias-filter": {
                    FilteringKeyStoreDefinition.ALIAS_FILTER.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addKeyStore.get("address").set(parentAddress).add("filtering-key-store", name);
        list.add(addKeyStore);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void startTLS(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("tls");
        }
    }

    void writeTLS(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean tlsStarted = false;
        tlsStarted |= this.writeKeyStores(tlsStarted, subsystem, writer);
        tlsStarted |= this.writeKeyManagers(tlsStarted, subsystem, writer);
        tlsStarted |= this.writeTrustManagers(tlsStarted, subsystem, writer);
        tlsStarted |= this.writeServerSSLContext(tlsStarted, subsystem, writer);
        if (tlsStarted |= this.writeClientSSLContext(tlsStarted, subsystem, writer)) {
            writer.writeEndElement();
        }
    }

    private boolean writeKeyManagers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("key-managers")) {
            this.startTLS(started, writer);
            writer.writeStartElement("key-managers");
            ModelNode keyManagers = subsystem.require("key-managers");
            for (String name : keyManagers.keys()) {
                ModelNode keyManager = keyManagers.require(name);
                writer.writeStartElement("key-manager");
                writer.writeAttribute("name", name);
                SSLDefinitions.ALGORITHM.marshallAsAttribute(keyManager, (XMLStreamWriter)writer);
                SSLDefinitions.KEYSTORE.marshallAsAttribute(keyManager, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDERS.marshallAsAttribute(keyManager, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDER_NAME.marshallAsAttribute(keyManager, (XMLStreamWriter)writer);
                CredentialReference.getAttributeDefinition().marshallAsElement(keyManager, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean writeTrustManagers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("trust-managers")) {
            this.startTLS(started, writer);
            writer.writeStartElement("trust-managers");
            ModelNode trustManagers = subsystem.require("trust-managers");
            for (String name : trustManagers.keys()) {
                ModelNode trustManager = trustManagers.require(name);
                writer.writeStartElement("trust-manager");
                writer.writeAttribute("name", name);
                SSLDefinitions.ALGORITHM.marshallAsAttribute(trustManager, (XMLStreamWriter)writer);
                SSLDefinitions.KEYSTORE.marshallAsAttribute(trustManager, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDERS.marshallAsAttribute(trustManager, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDER_NAME.marshallAsAttribute(trustManager, (XMLStreamWriter)writer);
                SSLDefinitions.CERTIFICATE_REVOCATION_LIST.marshallAsElement(trustManager, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean writeServerSSLContext(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("server-ssl-context")) {
            this.startTLS(started, writer);
            writer.writeStartElement("server-ssl-contexts");
            ModelNode serverSSLContexts = subsystem.require("server-ssl-context");
            for (String name : serverSSLContexts.keys()) {
                ModelNode serverSSLContext = serverSSLContexts.require(name);
                writer.writeStartElement("server-ssl-context");
                writer.writeAttribute("name", name);
                SSLDefinitions.SECURITY_DOMAIN.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.CIPHER_SUITE_FILTER.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.PROTOCOLS.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)SSLDefinitions.PROTOCOLS, serverSSLContext, false, (XMLStreamWriter)writer);
                SSLDefinitions.WANT_CLIENT_AUTH.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.NEED_CLIENT_AUTH.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.AUTHENTICATION_OPTIONAL.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.USE_CIPHER_SUITES_ORDER.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.MAXIMUM_SESSION_CACHE_SIZE.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.SESSION_TIMEOUT.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.WRAP.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.KEY_MANAGERS.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.TRUST_MANAGERS.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDERS.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDER_NAME.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean writeClientSSLContext(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("client-ssl-context")) {
            this.startTLS(started, writer);
            writer.writeStartElement("client-ssl-contexts");
            ModelNode serverSSLContexts = subsystem.require("client-ssl-context");
            for (String name : serverSSLContexts.keys()) {
                ModelNode serverSSLContext = serverSSLContexts.require(name);
                writer.writeStartElement("client-ssl-context");
                writer.writeAttribute("name", name);
                SSLDefinitions.CIPHER_SUITE_FILTER.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.PROTOCOLS.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)SSLDefinitions.PROTOCOLS, serverSSLContext, false, (XMLStreamWriter)writer);
                SSLDefinitions.USE_CIPHER_SUITES_ORDER.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.MAXIMUM_SESSION_CACHE_SIZE.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.SESSION_TIMEOUT.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.KEY_MANAGERS.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.TRUST_MANAGERS.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDERS.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDER_NAME.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean writeKeyStores(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("key-store") || subsystem.hasDefined("ldap-key-store") || subsystem.hasDefined("filtering-key-store")) {
            ModelNode filteringKeystores;
            ModelNode ldapKeystores;
            this.startTLS(started, writer);
            writer.writeStartElement("key-stores");
            ModelNode keystores = subsystem.get("key-store");
            if (keystores.isDefined()) {
                for (Object name : keystores.keys()) {
                    ModelNode keyStore = keystores.require((String)name);
                    writer.writeStartElement("key-store");
                    writer.writeAttribute("name", (String)name);
                    KeyStoreDefinition.TYPE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    KeyStoreDefinition.PROVIDER_NAME.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    KeyStoreDefinition.PROVIDERS.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    KeyStoreDefinition.ALIAS_FILTER.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    if (keyStore.hasDefined("path")) {
                        writer.writeStartElement("file");
                        FileAttributeDefinitions.RELATIVE_TO.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                        FileAttributeDefinitions.PATH.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                        KeyStoreDefinition.REQUIRED.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                    KeyStoreDefinition.CREDENTIAL_REFERENCE.marshallAsElement(keyStore, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
            }
            if ((ldapKeystores = subsystem.get("ldap-key-store")).isDefined()) {
                for (String name : ldapKeystores.keys()) {
                    ModelNode keyStore = ldapKeystores.require(name);
                    writer.writeStartElement("ldap-key-store");
                    writer.writeAttribute("name", name);
                    LdapKeyStoreDefinition.DIR_CONTEXT.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    LdapKeyStoreDefinition.SEARCH_PATH.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    LdapKeyStoreDefinition.SEARCH_RECURSIVE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    LdapKeyStoreDefinition.SEARCH_TIME_LIMIT.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    LdapKeyStoreDefinition.FILTER_ALIAS.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    LdapKeyStoreDefinition.FILTER_CERTIFICATE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    LdapKeyStoreDefinition.FILTER_ITERATE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    ModelNode newItemTemplate = keyStore.get("new-item-template");
                    if (newItemTemplate.isDefined()) {
                        writer.writeStartElement("new-item-template");
                        LdapKeyStoreDefinition.NewItemTemplateObjectDefinition.NEW_ITEM_PATH.marshallAsAttribute(newItemTemplate, (XMLStreamWriter)writer);
                        LdapKeyStoreDefinition.NewItemTemplateObjectDefinition.NEW_ITEM_RDN.marshallAsAttribute(newItemTemplate, (XMLStreamWriter)writer);
                        ModelNode newItemAttributes = newItemTemplate.get("new-item-attributes");
                        if (newItemAttributes.isDefined()) {
                            for (ModelNode newItemAttribute : newItemAttributes.asList()) {
                                writer.writeStartElement("attribute");
                                LdapKeyStoreDefinition.NewItemTemplateAttributeObjectDefinition.NAME.marshallAsAttribute(newItemAttribute, (XMLStreamWriter)writer);
                                LdapKeyStoreDefinition.NewItemTemplateAttributeObjectDefinition.VALUE.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)LdapKeyStoreDefinition.NewItemTemplateAttributeObjectDefinition.VALUE, newItemAttribute, false, (XMLStreamWriter)writer);
                                writer.writeEndElement();
                            }
                        }
                        writer.writeEndElement();
                    }
                    if (this.hasDefinedAny(keyStore, new String[]{"alias-attribute", "certificate-attribute", "certificate-type", "certificate-chain-attribute", "certificate-chain-encoding", "key-attribute", "key-type"})) {
                        writer.writeStartElement("ldap-mapping");
                        LdapKeyStoreDefinition.ALIAS_ATTRIBUTE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                        LdapKeyStoreDefinition.CERTIFICATE_ATTRIBUTE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                        LdapKeyStoreDefinition.CERTIFICATE_TYPE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                        LdapKeyStoreDefinition.CERTIFICATE_CHAIN_ATTRIBUTE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                        LdapKeyStoreDefinition.CERTIFICATE_CHAIN_ENCODING.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                        LdapKeyStoreDefinition.KEY_ATTRIBUTE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                        LdapKeyStoreDefinition.KEY_TYPE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
            if ((filteringKeystores = subsystem.get("filtering-key-store")).isDefined()) {
                for (String name : filteringKeystores.keys()) {
                    ModelNode keyStore = filteringKeystores.require(name);
                    writer.writeStartElement("filtering-key-store");
                    writer.writeAttribute("name", name);
                    FilteringKeyStoreDefinition.KEY_STORE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    FilteringKeyStoreDefinition.ALIAS_FILTER.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean hasDefinedAny(ModelNode node, String[] keys) {
        for (String key : keys) {
            if (!node.hasDefined(key)) continue;
            return true;
        }
        return false;
    }
}

