/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.CharsetValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.realm.jdbc.ColumnMapper;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealm;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealmBuilder;
import org.wildfly.security.auth.realm.jdbc.KeyMapper;
import org.wildfly.security.auth.realm.jdbc.QueryBuilder;
import org.wildfly.security.auth.realm.jdbc.mapper.AttributeMapper;
import org.wildfly.security.auth.realm.jdbc.mapper.PasswordKeyMapper;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.password.spec.Encoding;

class JdbcRealmDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition HASH_CHARSET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-charset", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator((ParameterValidator)new CharsetValidator())).setDefaultValue(new ModelNode("UTF-8"))).setAllowExpression(true)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PrincipalQueryAttributes.PRINCIPAL_QUERIES_7_0, HASH_CHARSET};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    JdbcRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"jdbc-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("jdbc-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, ElytronReloadRequiredWriteAttributeHandler.INSTANCE);
        }
    }

    private static KeyMapper resolveKeyMappers(OperationContext context, ModelNode authenticationQueryNode) throws OperationFailedException {
        PasswordKeyMapper keyMapper = null;
        for (String name : authenticationQueryNode.keys()) {
            PasswordMapperObjectDefinition mapperResource;
            ModelNode propertyNode = authenticationQueryNode.require(name);
            if (!propertyNode.isDefined() || (mapperResource = PrincipalQueryAttributes.SUPPORTED_PASSWORD_MAPPERS.get(name)) == null) continue;
            keyMapper = mapperResource.toPasswordKeyMapper(context, propertyNode);
        }
        return keyMapper;
    }

    static class PrincipalQueryAttributes {
        static final SimpleAttributeDefinition SQL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sql", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition DATA_SOURCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("data-source", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.data-source", "org.wildfly.security.security-realm")).build();
        static final ObjectListAttributeDefinition ATTRIBUTE_MAPPINGS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("attribute-mapping", AttributeMappingObjectDefinition.OBJECT_DEFINITION).setRequired(false)).setAttributeGroup("attribute")).setAllowDuplicates(true)).build();
        static Map<String, PasswordMapperObjectDefinition> SUPPORTED_PASSWORD_MAPPERS;
        @Deprecated
        static final ObjectTypeAttributeDefinition PRINCIPAL_QUERY;
        static final ObjectTypeAttributeDefinition PRINCIPAL_QUERY_7_0;
        @Deprecated
        static final ObjectListAttributeDefinition PRINCIPAL_QUERIES;
        static final ObjectListAttributeDefinition PRINCIPAL_QUERIES_7_0;

        PrincipalQueryAttributes() {
        }

        static {
            HashMap<String, PasswordMapperObjectDefinition> supportedMappers = new HashMap<String, PasswordMapperObjectDefinition>();
            supportedMappers.put("clear-password-mapper", new ClearPasswordObjectDefinition());
            supportedMappers.put("bcrypt-mapper", new BcryptPasswordObjectDefinition());
            supportedMappers.put("salted-simple-digest-mapper", new SaltedSimpleDigestObjectDefinition());
            supportedMappers.put("simple-digest-mapper", new SimpleDigestMapperObjectDefinition());
            supportedMappers.put("scram-mapper", new ScramMapperObjectDefinition());
            supportedMappers.put("modular-crypt-mapper", new ModularCryptMapperObjectDefinition());
            SUPPORTED_PASSWORD_MAPPERS = Collections.unmodifiableMap(supportedMappers);
            PRINCIPAL_QUERY = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("principal-query", new AttributeDefinition[]{SQL, DATA_SOURCE, ATTRIBUTE_MAPPINGS, ClearPasswordObjectDefinition.OBJECT_DEFINITION, BcryptPasswordObjectDefinition.OBJECT_DEFINITION, SaltedSimpleDigestObjectDefinition.OBJECT_DEFINITION, SimpleDigestMapperObjectDefinition.OBJECT_DEFINITION, ScramMapperObjectDefinition.OBJECT_DEFINITION}).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
            PRINCIPAL_QUERY_7_0 = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("principal-query", new AttributeDefinition[]{SQL, DATA_SOURCE, ATTRIBUTE_MAPPINGS, ClearPasswordObjectDefinition.OBJECT_DEFINITION, BcryptPasswordObjectDefinition.OBJECT_DEFINITION_7_0, SaltedSimpleDigestObjectDefinition.OBJECT_DEFINITION_7_0, SimpleDigestMapperObjectDefinition.OBJECT_DEFINITION_7_0, ScramMapperObjectDefinition.OBJECT_DEFINITION_7_0, ModularCryptMapperObjectDefinition.OBJECT_DEFINITION}).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
            PRINCIPAL_QUERIES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("principal-query", PRINCIPAL_QUERY).setMinSize(1)).setAllowDuplicates(true)).setRestartAllServices()).build();
            PRINCIPAL_QUERIES_7_0 = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("principal-query", PRINCIPAL_QUERY_7_0).setMinSize(1)).setAllowDuplicates(true)).setRestartAllServices()).build();
        }
    }

    static interface PasswordMapperObjectDefinition {
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext var1, ModelNode var2) throws OperationFailedException;
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            context.addStep((OperationStepHandler)new JdbcRealmDefinitionValidation(), OperationContext.Stage.MODEL);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            ModelNode principalQueries = PrincipalQueryAttributes.PRINCIPAL_QUERIES_7_0.resolveModelAttribute(context, operation);
            String hashCharset = HASH_CHARSET.resolveModelAttribute(context, model).asString();
            Charset charset = Charset.forName(hashCharset);
            JdbcSecurityRealmBuilder builder = JdbcSecurityRealm.builder();
            builder.setHashCharset(charset);
            TrivialService<SecurityRealm> service = new TrivialService<SecurityRealm>(() -> ((JdbcSecurityRealmBuilder)builder).build());
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, service);
            for (ModelNode query : principalQueries.asList()) {
                String authenticationQuerySql = PrincipalQueryAttributes.SQL.resolveModelAttribute(context, query).asString();
                final QueryBuilder queryBuilder = builder.principalQuery(authenticationQuerySql).withMapper((ColumnMapper[])this.resolveAttributeMappers(context, query)).withMapper(new ColumnMapper[]{JdbcRealmDefinition.resolveKeyMappers(context, query)});
                String dataSourceName = PrincipalQueryAttributes.DATA_SOURCE.resolveModelAttribute(context, query).asString();
                String capabilityName = "org.wildfly.data-source." + dataSourceName;
                ServiceName dataSourceServiceName = context.getCapabilityServiceName(capabilityName, DataSource.class);
                serviceBuilder.addDependency(dataSourceServiceName, DataSource.class, (Injector)new Injector<DataSource>(){

                    public void inject(DataSource value) throws InjectionException {
                        queryBuilder.from(value);
                    }

                    public void uninject() {
                    }
                });
            }
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(context.getRunningMode() == RunningMode.ADMIN_ONLY ? ServiceController.Mode.LAZY : ServiceController.Mode.ACTIVE).install();
        }

        private AttributeMapper[] resolveAttributeMappers(OperationContext context, ModelNode principalQueryNode) throws OperationFailedException {
            ArrayList<AttributeMapper> attributeMappers = new ArrayList<AttributeMapper>();
            ModelNode attributeMappingNode = PrincipalQueryAttributes.ATTRIBUTE_MAPPINGS.resolveModelAttribute(context, principalQueryNode);
            if (attributeMappingNode.isDefined()) {
                for (ModelNode attributeNode : attributeMappingNode.asList()) {
                    ModelNode indexNode = AttributeMappingObjectDefinition.INDEX.resolveModelAttribute(context, attributeNode);
                    ModelNode nameNode = AttributeMappingObjectDefinition.TO.resolveModelAttribute(context, attributeNode);
                    attributeMappers.add(new AttributeMapper(indexNode.asInt(), nameNode.asString()));
                }
            }
            return attributeMappers.toArray(new AttributeMapper[attributeMappers.size()]);
        }
    }

    private static class JdbcRealmDefinitionValidation
    implements OperationStepHandler {
        private JdbcRealmDefinitionValidation() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
            List queries = model.get(PrincipalQueryAttributes.PRINCIPAL_QUERIES_7_0.getName()).asList();
            for (ModelNode modelNode : queries) {
                long mappersCount = modelNode.keys().stream().filter(PrincipalQueryAttributes.SUPPORTED_PASSWORD_MAPPERS::containsKey).count();
                if (mappersCount <= 1L) continue;
                throw ElytronSubsystemMessages.ROOT_LOGGER.jdbcRealmOnlySingleKeyMapperAllowed();
            }
        }
    }

    static class AttributeMappingObjectDefinition {
        static final SimpleAttributeDefinition INDEX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("index", ModelType.INT, false).setAllowExpression(true)).setValidator(IntRangeValidator.POSITIVE)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("to", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{TO, INDEX};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("attribute", (AttributeDefinition[])ATTRIBUTES).build();

        AttributeMappingObjectDefinition() {
        }
    }

    static class ModularCryptMapperObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("modular-crypt-mapper", new AttributeDefinition[]{PASSWORD}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        ModularCryptMapperObjectDefinition() {
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException {
            int password = PASSWORD.resolveModelAttribute(context, propertyNode).asInt();
            return PasswordKeyMapper.builder().setHashColumn(password).build();
        }
    }

    static class ScramMapperObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("scram-sha-256"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"scram-sha-1", "scram-sha-256", "scram-sha-384", "scram-sha-512"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition ITERATION_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("iteration-count-index", ModelType.INT, false).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-index", ModelType.INT, false).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition HASH_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-encoding", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("base64"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"base64", "hex"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-encoding", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("base64"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"base64", "hex"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        @Deprecated
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("scram-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT, ITERATION_COUNT}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION_7_0 = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("scram-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT, ITERATION_COUNT, HASH_ENCODING, SALT_ENCODING}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        ScramMapperObjectDefinition() {
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException {
            String algorithm = ALGORITHM.resolveModelAttribute(context, propertyNode).asStringOrNull();
            int password = PASSWORD.resolveModelAttribute(context, propertyNode).asInt();
            int salt = SALT.resolveModelAttribute(context, propertyNode).asInt();
            int iterationCount = ITERATION_COUNT.resolveModelAttribute(context, propertyNode).asInt();
            String hashEncoding = HASH_ENCODING.resolveModelAttribute(context, propertyNode).asStringOrNull();
            String saltEncoding = SALT_ENCODING.resolveModelAttribute(context, propertyNode).asStringOrNull();
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).setSaltColumn(salt).setIterationCountColumn(iterationCount).setHashEncoding("hex".equals(hashEncoding) ? Encoding.HEX : Encoding.BASE64).setSaltEncoding("hex".equals(saltEncoding) ? Encoding.HEX : Encoding.BASE64).build();
        }
    }

    static class SimpleDigestMapperObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("simple-digest-md5"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"simple-digest-md2", "simple-digest-md5", "simple-digest-sha-1", "simple-digest-sha-256", "simple-digest-sha-384", "simple-digest-sha-512"}))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition HASH_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-encoding", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("base64"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"base64", "hex"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        @Deprecated
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("simple-digest-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION_7_0 = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("simple-digest-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD, HASH_ENCODING}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        SimpleDigestMapperObjectDefinition() {
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException {
            String algorithm = ALGORITHM.resolveModelAttribute(context, propertyNode).asStringOrNull();
            int password = PASSWORD.resolveModelAttribute(context, propertyNode).asInt();
            String hashEncoding = HASH_ENCODING.resolveModelAttribute(context, propertyNode).asStringOrNull();
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).setHashEncoding("hex".equals(hashEncoding) ? Encoding.HEX : Encoding.BASE64).build();
        }
    }

    static class SaltedSimpleDigestObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("password-salt-digest-md5"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"password-salt-digest-md5", "password-salt-digest-sha-1", "password-salt-digest-sha-256", "password-salt-digest-sha-384", "password-salt-digest-sha-512", "salt-password-digest-md5", "salt-password-digest-sha-1", "salt-password-digest-sha-256", "salt-password-digest-sha-384", "salt-password-digest-sha-512"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-index", ModelType.INT, false).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition HASH_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-encoding", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("base64"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"base64", "hex"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-encoding", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("base64"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"base64", "hex"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        @Deprecated
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("salted-simple-digest-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION_7_0 = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("salted-simple-digest-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT, HASH_ENCODING, SALT_ENCODING}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        SaltedSimpleDigestObjectDefinition() {
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException {
            String algorithm = ALGORITHM.resolveModelAttribute(context, propertyNode).asStringOrNull();
            int password = PASSWORD.resolveModelAttribute(context, propertyNode).asInt();
            int salt = SALT.resolveModelAttribute(context, propertyNode).asInt();
            String hashEncoding = HASH_ENCODING.resolveModelAttribute(context, propertyNode).asStringOrNull();
            String saltEncoding = SALT_ENCODING.resolveModelAttribute(context, propertyNode).asStringOrNull();
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).setSaltColumn(salt).setHashEncoding("hex".equals(hashEncoding) ? Encoding.HEX : Encoding.BASE64).setSaltEncoding("hex".equals(saltEncoding) ? Encoding.HEX : Encoding.BASE64).build();
        }
    }

    static class BcryptPasswordObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("bcrypt"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"bcrypt"}))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition ITERATION_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("iteration-count-index", ModelType.INT, false).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-index", ModelType.INT, false).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition HASH_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-encoding", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("base64"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"base64", "hex"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-encoding", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("base64"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"base64", "hex"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        @Deprecated
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("bcrypt-mapper", new AttributeDefinition[]{PASSWORD, SALT, ITERATION_COUNT}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION_7_0 = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("bcrypt-mapper", new AttributeDefinition[]{PASSWORD, SALT, ITERATION_COUNT, HASH_ENCODING, SALT_ENCODING}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        BcryptPasswordObjectDefinition() {
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException {
            String algorithm = ALGORITHM.resolveModelAttribute(context, propertyNode).asStringOrNull();
            int password = PASSWORD.resolveModelAttribute(context, propertyNode).asInt();
            int salt = SALT.resolveModelAttribute(context, propertyNode).asInt();
            int iterationCount = ITERATION_COUNT.resolveModelAttribute(context, propertyNode).asInt();
            String hashEncoding = HASH_ENCODING.resolveModelAttribute(context, propertyNode).asStringOrNull();
            String saltEncoding = SALT_ENCODING.resolveModelAttribute(context, propertyNode).asStringOrNull();
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).setSaltColumn(salt).setIterationCountColumn(iterationCount).setHashEncoding("hex".equals(hashEncoding) ? Encoding.HEX : Encoding.BASE64).setSaltEncoding("hex".equals(saltEncoding) ? Encoding.HEX : Encoding.BASE64).build();
        }
    }

    static class ClearPasswordObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("clear"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"clear"}))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator(IntRangeValidator.POSITIVE)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("clear-password-mapper", new AttributeDefinition[]{PASSWORD}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        ClearPasswordObjectDefinition() {
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException {
            String algorithm = ALGORITHM.resolveModelAttribute(context, propertyNode).asStringOrNull();
            int password = PASSWORD.resolveModelAttribute(context, propertyNode).asInt();
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).build();
        }
    }
}

