/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.security.VirtualDomainMetaData;
import org.jboss.as.server.security.VirtualDomainMetaDataService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.DomainDefinition;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRestartParentWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

class VirtualDomainDefinition
extends SimpleResourceDefinition {
    static final StringListAttributeDefinition OUTFLOW_SECURITY_DOMAINS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("outflow-security-domains").setRequired(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.virtual-security-domain")).build();
    static final SimpleAttributeDefinition AUTH_METHOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auth-method", ModelType.STRING, true).setDefaultValue(new ModelNode(VirtualDomainMetaData.AuthMethod.OIDC.toString()))).setValidator((ParameterValidator)EnumValidator.create(VirtualDomainMetaData.AuthMethod.class))).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{OUTFLOW_SECURITY_DOMAINS, DomainDefinition.OUTFLOW_ANONYMOUS, AUTH_METHOD};
    private static final VirtualDomainAddHandler ADD = new VirtualDomainAddHandler();
    private static final OperationStepHandler REMOVE = new VirtualDomainRemoveHandler(ADD);
    private static final WriteAttributeHandler WRITE = new WriteAttributeHandler("virtual-security-domain");

    VirtualDomainDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"virtual-security-domain"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("virtual-security-domain")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.VIRTUAL_SECURITY_DOMAIN_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)WRITE);
        }
    }

    private static ServiceController<VirtualDomainMetaData> installInitialService(OperationContext context, ServiceName initialName, UnaryOperator<SecurityIdentity> identityOperator, VirtualDomainMetaData.AuthMethod authMethod) throws OperationFailedException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        VirtualDomainMetaDataService virtualDomainService = new VirtualDomainMetaDataService(identityOperator, authMethod);
        ServiceBuilder virtualDomainBuilder = serviceTarget.addService(initialName, (Service)virtualDomainService).setInitialMode(ServiceController.Mode.LAZY);
        ElytronDefinition.commonDependencies(virtualDomainBuilder);
        return virtualDomainBuilder.install();
    }

    private static ServiceController<VirtualDomainMetaData> installService(OperationContext context, ServiceName virtualDomainName, ModelNode model) throws OperationFailedException {
        ServiceName initialName = virtualDomainName.append(new String[]{"initial"});
        final InjectedValue virtualDomain = new InjectedValue();
        List outflowSecurityDomainNames = OUTFLOW_SECURITY_DOMAINS.unwrap((ExpressionResolver)context, model);
        boolean outflowAnonymous = DomainDefinition.OUTFLOW_ANONYMOUS.resolveModelAttribute(context, model).asBoolean();
        String authMethod = AUTH_METHOD.resolveModelAttribute(context, model).asString();
        final ArrayList<InjectedValue> outflowSecurityDomainInjectors = new ArrayList<InjectedValue>(outflowSecurityDomainNames.size());
        final HashSet outflowSecurityDomains = new HashSet();
        VirtualDomainDefinition.installInitialService(context, initialName, !outflowSecurityDomainNames.isEmpty() ? i -> DomainDefinition.outflow(i, outflowAnonymous, outflowSecurityDomains) : UnaryOperator.identity(), VirtualDomainMetaData.AuthMethod.forName((String)authMethod));
        TrivialService<VirtualDomainMetaData> finalVirtualDomainService = new TrivialService<VirtualDomainMetaData>();
        finalVirtualDomainService.setValueSupplier(new TrivialService.ValueSupplier<VirtualDomainMetaData>(){

            @Override
            public VirtualDomainMetaData get() throws StartException {
                for (InjectedValue i : outflowSecurityDomainInjectors) {
                    outflowSecurityDomains.add((SecurityDomain)i.getValue());
                }
                return (VirtualDomainMetaData)virtualDomain.getValue();
            }
        });
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceBuilder virtualDomainBuilder = serviceTarget.addService(virtualDomainName, finalVirtualDomainService).setInitialMode(ServiceController.Mode.ACTIVE);
        virtualDomainBuilder.addDependency(initialName, VirtualDomainMetaData.class, (Injector)virtualDomain);
        for (String outflowDomainName : outflowSecurityDomainNames) {
            InjectedValue outflowDomainInjector = new InjectedValue();
            virtualDomainBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.security.security-domain", outflowDomainName, SecurityDomain.class).append(new String[]{"initial"}), SecurityDomain.class, (Injector)outflowDomainInjector);
            outflowSecurityDomainInjectors.add(outflowDomainInjector);
        }
        return virtualDomainBuilder.install();
    }

    private static class WriteAttributeHandler
    extends ElytronRestartParentWriteAttributeHandler {
        WriteAttributeHandler(String parentKeyName) {
            super(parentKeyName, ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.VIRTUAL_SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(VirtualDomainMetaData.class);
        }

        protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
            context.removeService(parentService.append(new String[]{"initial"}));
            super.removeServices(context, parentService, parentModel);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            VirtualDomainDefinition.installService(context, this.getParentServiceName(parentAddress), parentModel);
        }
    }

    private static class VirtualDomainRemoveHandler
    extends TrivialCapabilityServiceRemoveHandler {
        VirtualDomainRemoveHandler(AbstractAddStepHandler addHandler) {
            super(addHandler, Capabilities.VIRTUAL_SECURITY_DOMAIN_RUNTIME_CAPABILITY);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
            super.performRuntime(context, operation, model);
            if (context.isResourceServiceRestartAllowed()) {
                PathAddress address = context.getCurrentAddress();
                String name = address.getLastElement().getValue();
                context.removeService(this.serviceName(name, address).append(new String[]{"initial"}));
            }
        }
    }

    private static class VirtualDomainAddHandler
    extends BaseAddHandler {
        private VirtualDomainAddHandler() {
            super(Capabilities.VIRTUAL_SECURITY_DOMAIN_RUNTIME_CAPABILITY);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            RuntimeCapability runtimeCapability = Capabilities.VIRTUAL_SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName virtualDomainName = runtimeCapability.getCapabilityServiceName(VirtualDomainMetaData.class);
            VirtualDomainDefinition.installService(context, virtualDomainName, model);
        }
    }
}

