/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.function.Consumer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.realm.FailoverSecurityRealm;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.SecurityEvent;
import org.wildfly.security.auth.server.event.SecurityRealmUnavailableEvent;

class FailoverRealmDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, "aggregate-realm", SecurityRealm.class);
    static final SimpleAttributeDefinition DELEGATE_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("delegate-realm", ModelType.STRING, false).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-realm", "org.wildfly.security.security-realm")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition FAILOVER_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("failover-realm", ModelType.STRING, false).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-realm", "org.wildfly.security.security-realm")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition EMIT_EVENTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("emit-events", ModelType.BOOLEAN, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(ModelNode.TRUE)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{DELEGATE_REALM, FAILOVER_REALM, EMIT_EVENTS};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    FailoverRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"failover-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("failover-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, ElytronReloadRequiredWriteAttributeHandler.INSTANCE);
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            String delegateRealm = DELEGATE_REALM.resolveModelAttribute(context, model).asString();
            InjectedValue delegateRealmValue = new InjectedValue();
            String failoverRealm = FAILOVER_REALM.resolveModelAttribute(context, model).asString();
            InjectedValue failoverRealmValue = new InjectedValue();
            boolean emitEvents = EMIT_EVENTS.resolveModelAttribute(context, model).asBoolean();
            TrivialService<SecurityRealm> failoverRealmService = new TrivialService<SecurityRealm>(() -> {
                SecurityRealm delegate = (SecurityRealm)delegateRealmValue.getValue();
                Consumer<RealmUnavailableException> failoverConsumer = emitEvents ? e -> {
                    SecurityDomain domain = SecurityDomain.getCurrent();
                    if (domain != null) {
                        domain.handleSecurityEvent((SecurityEvent)new SecurityRealmUnavailableEvent(domain.getCurrentSecurityIdentity(), delegateRealm));
                    }
                } : e -> {};
                return new FailoverSecurityRealm(delegate, (SecurityRealm)failoverRealmValue.getValue(), failoverConsumer);
            });
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, failoverRealmService);
            this.addRealmDependency(context, (ServiceBuilder<SecurityRealm>)serviceBuilder, delegateRealm, (Injector<SecurityRealm>)delegateRealmValue);
            this.addRealmDependency(context, (ServiceBuilder<SecurityRealm>)serviceBuilder, failoverRealm, (Injector<SecurityRealm>)failoverRealmValue);
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private void addRealmDependency(OperationContext context, ServiceBuilder<SecurityRealm> serviceBuilder, String realmName, Injector<SecurityRealm> securityRealmInjector) {
            String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-realm", (String)realmName);
            ServiceName realmServiceName = context.getCapabilityServiceName(runtimeCapability, SecurityRealm.class);
            REALM_SERVICE_UTIL.addInjection(serviceBuilder, securityRealmInjector, realmServiceName);
        }
    }
}

