/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.function.Consumer;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.as.server.security.VirtualDomainMetaData;
import org.jboss.as.server.security.VirtualDomainUtil;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.auth.server.SecurityDomain;

class VirtualSecurityDomainProcessor
implements DeploymentUnitProcessor {
    VirtualSecurityDomainProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null || !VirtualDomainMarkerUtility.isVirtualDomainRequired((DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (!VirtualDomainUtil.isVirtualDomainCreated((DeploymentUnit)deploymentUnit)) {
            ServiceName virtualDomainName = VirtualDomainMarkerUtility.virtualDomainName((DeploymentUnit)deploymentUnit);
            VirtualDomainMetaData virtualDomainMetaData = VirtualDomainUtil.getVirtualDomainMetaData((DeploymentUnit)deploymentUnit);
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ServiceBuilder serviceBuilder = serviceTarget.addService(virtualDomainName);
            SecurityDomain.Builder virtualDomainBuilder = SecurityDomain.builder();
            VirtualDomainUtil.configureVirtualDomain((VirtualDomainMetaData)virtualDomainMetaData, (SecurityDomain.Builder)virtualDomainBuilder);
            SecurityDomain virtualDomain = virtualDomainBuilder.build();
            if (virtualDomainMetaData != null) {
                virtualDomainMetaData.setSecurityDomain(virtualDomain);
            }
            Consumer consumer = serviceBuilder.provides(new ServiceName[]{virtualDomainName});
            serviceBuilder.setInstance(Service.newInstance((Consumer)consumer, (Object)virtualDomain));
            serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            serviceBuilder.install();
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        VirtualDomainUtil.clearVirtualDomainMetaDataSecurityDomain((DeploymentUnit)deploymentUnit);
    }
}

