/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.elytron.SecurityPropertyService;

class SecurityPropertiesWriteHandler
extends AbstractWriteAttributeHandler {
    private final PropertiesAttributeDefinition securityProperties;

    SecurityPropertiesWriteHandler(PropertiesAttributeDefinition attributeDefinition) {
        this.securityProperties = attributeDefinition;
    }

    private static SecurityPropertyService getService(OperationContext context) {
        Service serviceImplementation;
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController service = serviceRegistry.getService(SecurityPropertyService.SERVICE_NAME);
        if (service != null && (serviceImplementation = service.getService()) != null && serviceImplementation instanceof SecurityPropertyService) {
            return (SecurityPropertyService)serviceImplementation;
        }
        throw new IllegalStateException("Requires service not available or wrong type.");
    }

    private static void setProperty(OperationContext context, String name, String value) {
        SecurityPropertiesWriteHandler.getService(context).setProperty(name, value);
    }

    private static void removeProperty(OperationContext context, String name) {
        SecurityPropertiesWriteHandler.getService(context).removeProperty(name);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder handbackHolder) throws OperationFailedException {
        Map newProps = this.securityProperties.unwrap((ExpressionResolver)context, resolvedValue);
        Map oldProps = this.securityProperties.unwrap((ExpressionResolver)context, currentValue);
        this.setProperties(context, newProps, oldProps);
        return false;
    }

    private void setProperties(OperationContext context, Map<String, String> newProps, Map<String, String> oldProps) {
        HashMap<String, String> toRemove = new HashMap<String, String>();
        HashMap<String, String> toAdd = new HashMap<String, String>();
        HashMap<String, String> toUpdate = new HashMap<String, String>();
        SecurityPropertiesWriteHandler.doDifference(newProps, oldProps, toAdd, toRemove, toUpdate);
        for (Map.Entry entry : toAdd.entrySet()) {
            SecurityPropertiesWriteHandler.setProperty(context, (String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : toUpdate.entrySet()) {
            SecurityPropertiesWriteHandler.setProperty(context, (String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : toRemove.keySet()) {
            SecurityPropertiesWriteHandler.removeProperty(context, string);
        }
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Object handback) throws OperationFailedException {
        Map newProps = this.securityProperties.unwrap((ExpressionResolver)context, valueToRestore);
        Map oldProps = this.securityProperties.unwrap((ExpressionResolver)context, valueToRevert);
        this.setProperties(context, newProps, oldProps);
    }

    static void doDifference(Map<String, String> left, Map<String, String> right, Map<String, String> onlyOnLeft, Map<String, String> onlyOnRight, Map<String, String> updated) {
        onlyOnRight.clear();
        onlyOnRight.putAll(right);
        for (Map.Entry<String, String> entry : left.entrySet()) {
            String leftKey = entry.getKey();
            String leftValue = entry.getValue();
            if (right.containsKey(leftKey)) {
                String rightValue = onlyOnRight.remove(leftKey);
                if (leftValue.equals(rightValue)) continue;
                updated.put(leftKey, leftValue);
                continue;
            }
            onlyOnLeft.put(leftKey, leftValue);
        }
    }
}

