/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class KeyStoreServiceUtil {
    KeyStoreServiceUtil() {
    }

    public static ModifiableKeyStoreService getModifiableKeyStoreService(ServiceRegistry serviceRegistry, String keyStoreName) throws OperationFailedException {
        RuntimeCapability runtimeCapability = Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(keyStoreName);
        ServiceName serviceName = runtimeCapability.getCapabilityServiceName();
        ServiceController<KeyStore> serviceContainer = ElytronExtension.getRequiredService(serviceRegistry, serviceName, KeyStore.class);
        ServiceController.State serviceState = serviceContainer.getState();
        if (serviceState != ServiceController.State.UP) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serviceName, serviceState);
        }
        return (ModifiableKeyStoreService)serviceContainer.getService();
    }
}

