/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.PersistentSubsystemSchema;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.extension.ExpressionResolverExtension;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronSubsystemSchema;
import org.wildfly.extension.elytron.ExpressionResolverResourceDefinition;
import org.wildfly.security.auth.client.AuthenticationContext;

public class ElytronExtension
implements Extension {
    static final String NAMESPACE_18_0 = "urn:wildfly:elytron:18.0";
    static final String CURRENT_NAMESPACE = "urn:wildfly:elytron:18.0";
    public static final String SUBSYSTEM_NAME = "elytron";
    public static final AttachmentKey<AuthenticationContext> AUTHENTICATION_CONTEXT_KEY = AttachmentKey.create(AuthenticationContext.class);
    public static final AttachmentKey<SSLContext> SSL_CONTEXT_KEY = AttachmentKey.create(SSLContext.class);
    static final ModelVersion ELYTRON_1_2_0 = ModelVersion.create((int)1, (int)2);
    static final ModelVersion ELYTRON_2_0_0 = ModelVersion.create((int)2);
    static final ModelVersion ELYTRON_3_0_0 = ModelVersion.create((int)3);
    static final ModelVersion ELYTRON_4_0_0 = ModelVersion.create((int)4);
    static final ModelVersion ELYTRON_5_0_0 = ModelVersion.create((int)5);
    static final ModelVersion ELYTRON_6_0_0 = ModelVersion.create((int)6);
    static final ModelVersion ELYTRON_7_0_0 = ModelVersion.create((int)7);
    static final ModelVersion ELYTRON_8_0_0 = ModelVersion.create((int)8);
    static final ModelVersion ELYTRON_9_0_0 = ModelVersion.create((int)9);
    static final ModelVersion ELYTRON_10_0_0 = ModelVersion.create((int)10);
    static final ModelVersion ELYTRON_11_0_0 = ModelVersion.create((int)11);
    static final ModelVersion ELYTRON_12_0_0 = ModelVersion.create((int)12);
    static final ModelVersion ELYTRON_13_0_0 = ModelVersion.create((int)13);
    static final ModelVersion ELYTRON_14_0_0 = ModelVersion.create((int)14);
    static final ModelVersion ELYTRON_15_0_0 = ModelVersion.create((int)15);
    static final ModelVersion ELYTRON_15_1_0 = ModelVersion.create((int)15, (int)1);
    static final ModelVersion ELYTRON_16_0_0 = ModelVersion.create((int)16);
    static final ModelVersion ELYTRON_17_0_0 = ModelVersion.create((int)17);
    static final ModelVersion ELYTRON_18_0_0 = ModelVersion.create((int)18);
    static final ModelVersion ELYTRON_19_0_0;
    private static final ModelVersion ELYTRON_CURRENT;
    static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final PathElement SUBSYSTEM_PATH;
    private static final String RESOURCE_NAME;
    static final ServiceName BASE_SERVICE_NAME;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefixes) {
        StringBuilder sb = new StringBuilder(SUBSYSTEM_NAME);
        if (keyPrefixes != null) {
            for (String current : keyPrefixes) {
                sb.append(".").append(current);
            }
        }
        return new StandardResourceDescriptionResolver(sb.toString(), RESOURCE_NAME, ElytronExtension.class.getClassLoader(), true, false);
    }

    static boolean isServerOrHostController(ImmutableManagementResourceRegistration resourceRegistration) {
        return resourceRegistration.getProcessType().isServer() || !"profile".equals(resourceRegistration.getPathAddress().getElement(0).getKey());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMappings(SUBSYSTEM_NAME, EnumSet.allOf(ElytronSubsystemSchema.class));
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, ELYTRON_CURRENT);
        subsystemRegistration.setHostCapable();
        AtomicReference<ExpressionResolverExtension> resolverRef = new AtomicReference<ExpressionResolverExtension>();
        ManagementResourceRegistration registration = subsystemRegistration.registerSubsystemModel((ResourceDefinition)new ElytronDefinition(resolverRef));
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystemRegistration.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter((PersistentSubsystemSchema)ElytronSubsystemSchema.CURRENT.get(context.getStability())));
        context.registerExpressionResolverExtension(resolverRef::get, ExpressionResolverResourceDefinition.INITIAL_PATTERN, false);
    }

    static <T> ServiceController<T> getRequiredService(ServiceRegistry serviceRegistry, ServiceName serviceName, Class<T> serviceType) {
        ServiceController controller = serviceRegistry.getRequiredService(serviceName);
        return controller;
    }

    static {
        ELYTRON_CURRENT = ELYTRON_19_0_0 = ModelVersion.create((int)19);
        SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME);
        RESOURCE_NAME = ElytronExtension.class.getPackage().getName() + ".LocalDescriptions";
        BASE_SERVICE_NAME = ServiceName.of((String[])new String[]{SUBSYSTEM_NAME});
    }
}

