/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.CommonAttributes;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities._private.DirContextSupplier;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.realm.ldap.SimpleDirContextFactoryBuilder;
import org.wildfly.security.credential.source.CredentialSource;

class DirContextDefinition
extends SimpleResourceDefinition {
    public static final String CONNECTION_POOLING_PROPERTY = "com.sun.jndi.ldap.connect.pool";
    static final SimpleAttributeDefinition URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING, false).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition AUTHENTICATION_LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-level", ModelType.STRING, true).setDefaultValue(new ModelNode("simple"))).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PRINCIPAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal", ModelType.STRING, true).setAllowExpression(true)).setAlternatives(new String[]{"authentication-context"})).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = ((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((boolean)true, (boolean)true).setAlternatives(new String[]{"authentication-context"})).build();
    static final SimpleAttributeDefinition ENABLE_CONNECTION_POOLING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-connection-pooling", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition REFERRAL_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("referral-mode", ModelType.STRING, true).setDefaultValue(new ModelNode(DirContextFactory.ReferralMode.IGNORE.toString()))).setAllowedValues(new String[]{DirContextFactory.ReferralMode.FOLLOW.toString(), DirContextFactory.ReferralMode.IGNORE.toString(), DirContextFactory.ReferralMode.THROW.toString()})).setValidator((ParameterValidator)EnumValidator.create(DirContextFactory.ReferralMode.class))).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition AUTHENTICATION_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-context", ModelType.STRING, true).setAllowExpression(false)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.authentication-context", "org.wildfly.security.dir-context")).setAlternatives(new String[]{"credential-reference", "ssl-context", "principal"})).build();
    static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setAllowExpression(false)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.ssl-context", "org.wildfly.security.dir-context")).setAlternatives(new String[]{"authentication-context"})).build();
    static final SimpleAttributeDefinition CONNECTION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-timeout", ModelType.INT, true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition READ_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("read-timeout", ModelType.INT, true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setAllowExpression(true)).setRestartAllServices()).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{URL, AUTHENTICATION_LEVEL, PRINCIPAL, CREDENTIAL_REFERENCE, ENABLE_CONNECTION_POOLING, REFERRAL_MODE, AUTHENTICATION_CONTEXT, SSL_CONTEXT, CONNECTION_TIMEOUT, READ_TIMEOUT, CommonAttributes.PROPERTIES, MODULE};
    private static final AbstractAddStepHandler ADD = new BaseAddHandler((RuntimeCapability)Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY, ATTRIBUTES){

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel());
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String authenticationContextName;
            RuntimeCapability runtimeCapability = Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(DirContextSupplier.class);
            InjectedValue credentialSourceSupplierInjector = new InjectedValue();
            InjectedValue authenticationContextInjector = new InjectedValue();
            InjectedValue sslContextInjector = new InjectedValue();
            TrivialService<DirContextSupplier> service = new TrivialService<DirContextSupplier>(DirContextDefinition.obtainDirContextSupplier(context, model, (InjectedValue<ExceptionSupplier<CredentialSource, Exception>>)credentialSourceSupplierInjector, (InjectedValue<AuthenticationContext>)authenticationContextInjector, (InjectedValue<SSLContext>)sslContextInjector));
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName, service);
            String sslContextName = SSL_CONTEXT.resolveModelAttribute(context, model).asStringOrNull();
            if (sslContextName != null) {
                String sslCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.ssl-context", (String)sslContextName);
                ServiceName sslServiceName = context.getCapabilityServiceName(sslCapability, SSLContext.class);
                serviceBuilder.addDependency(sslServiceName, SSLContext.class, (Injector)sslContextInjector);
            }
            if (CREDENTIAL_REFERENCE.resolveModelAttribute(context, model).isDefined()) {
                credentialSourceSupplierInjector.inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)model, (ServiceBuilder)serviceBuilder));
            }
            if ((authenticationContextName = AUTHENTICATION_CONTEXT.resolveModelAttribute(context, model).asStringOrNull()) != null) {
                String acCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.authentication-context", (String)authenticationContextName);
                ServiceName acServiceName = context.getCapabilityServiceName(acCapability, AuthenticationContext.class);
                serviceBuilder.addDependency(acServiceName, AuthenticationContext.class, (Injector)authenticationContextInjector);
            }
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
        }
    };
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY);

    DirContextDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"dir-context"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("dir-context")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler handler = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)handler);
        }
    }

    private static TrivialService.ValueSupplier<DirContextSupplier> obtainDirContextSupplier(OperationContext context, ModelNode model, InjectedValue<ExceptionSupplier<CredentialSource, Exception>> credentialSourceSupplierInjector, InjectedValue<AuthenticationContext> authenticationContextInjector, InjectedValue<SSLContext> sslContextInjector) throws OperationFailedException {
        String url = URL.resolveModelAttribute(context, model).asString();
        String authenticationLevel = AUTHENTICATION_LEVEL.resolveModelAttribute(context, model).asString();
        String principal = PRINCIPAL.resolveModelAttribute(context, model).asStringOrNull();
        String moduleName = null;
        if (model.hasDefined(MODULE.getName())) {
            moduleName = MODULE.resolveModelAttribute(context, model).asString();
        }
        Module module = null;
        if (moduleName != null && !"".equals(moduleName)) {
            try {
                Module cm = Module.getCallerModule();
                ModuleIdentifier mi = ModuleIdentifier.create((String)moduleName);
                module = cm.getModule(mi);
            }
            catch (ModuleLoadException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToLoadModule(moduleName, (Exception)((Object)e));
            }
        }
        Module finalModule = module;
        Properties connectionProperties = new Properties();
        ModelNode enableConnectionPoolingNode = ENABLE_CONNECTION_POOLING.resolveModelAttribute(context, model);
        connectionProperties.put(CONNECTION_POOLING_PROPERTY, enableConnectionPoolingNode.asString());
        ModelNode properties = CommonAttributes.PROPERTIES.resolveModelAttribute(context, model);
        if (properties.isDefined()) {
            for (Property property : properties.asPropertyList()) {
                connectionProperties.put(property.getName(), property.getValue().asString());
            }
        }
        ModelNode connectionTimeout = CONNECTION_TIMEOUT.resolveModelAttribute(context, model);
        ModelNode readTimeout = READ_TIMEOUT.resolveModelAttribute(context, model);
        DirContextFactory.ReferralMode referralMode = DirContextFactory.ReferralMode.valueOf((String)REFERRAL_MODE.resolveModelAttribute(context, model).asString().toUpperCase());
        return () -> {
            SSLContext sslContext;
            AuthenticationContext authenticationContext;
            ExceptionSupplier credentialSourceSupplier;
            SimpleDirContextFactoryBuilder builder = SimpleDirContextFactoryBuilder.builder().setProviderUrl(url).setSecurityAuthentication(authenticationLevel).setConnectionProperties(connectionProperties);
            if (principal != null) {
                builder.setSecurityPrincipal(principal);
            }
            if ((credentialSourceSupplier = (ExceptionSupplier)credentialSourceSupplierInjector.getOptionalValue()) != null) {
                try {
                    builder.setCredentialSource((CredentialSource)credentialSourceSupplier.get());
                }
                catch (Exception e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.dirContextPasswordCannotBeResolved(e);
                }
            }
            if ((authenticationContext = (AuthenticationContext)authenticationContextInjector.getOptionalValue()) != null) {
                builder.setAuthenticationContext(authenticationContext);
            }
            if ((sslContext = (SSLContext)sslContextInjector.getOptionalValue()) != null) {
                builder.setSocketFactory((SocketFactory)sslContext.getSocketFactory());
            }
            if (connectionTimeout.isDefined()) {
                builder.setConnectTimeout(connectionTimeout.asInt());
            }
            if (readTimeout.isDefined()) {
                builder.setReadTimeout(readTimeout.asInt());
            }
            if (finalModule != null) {
                builder.setModule(finalModule);
            }
            DirContextFactory dirContextFactory = builder.build();
            return () -> dirContextFactory.obtainDirContext(referralMode);
        };
    }
}

