/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.naming.InvalidNameException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.LdapKeyStoreService;
import org.wildfly.extension.elytron.ServiceStateDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities._private.DirContextSupplier;

final class LdapKeyStoreDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<KeyStore> LDAP_KEY_STORE_UTIL = ServiceUtil.newInstance(Capabilities.KEY_STORE_RUNTIME_CAPABILITY, "ldap-key-store", KeyStore.class);
    static final SimpleAttributeDefinition DIR_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("dir-context", ModelType.STRING, false).setAllowExpression(false)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.dir-context", "org.wildfly.security.key-store")).build();
    static final SimpleAttributeDefinition SEARCH_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-path", ModelType.STRING, false).setAttributeGroup("search")).setXmlName("path")).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SEARCH_RECURSIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-recursive", ModelType.BOOLEAN, true).setAttributeGroup("search")).setXmlName("recursive")).setAllowExpression(true)).setRestartAllServices()).setDefaultValue(ModelNode.TRUE)).build();
    static final SimpleAttributeDefinition SEARCH_TIME_LIMIT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-time-limit", ModelType.INT, true).setAttributeGroup("search")).setXmlName("time-limit")).setAllowExpression(true)).setRestartAllServices()).setDefaultValue(new ModelNode(10000))).build();
    static final SimpleAttributeDefinition FILTER_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter-alias", ModelType.STRING, true).setAttributeGroup("search")).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition FILTER_CERTIFICATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter-certificate", ModelType.STRING, true).setAttributeGroup("search")).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition FILTER_ITERATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter-iterate", ModelType.STRING, true).setAttributeGroup("search")).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ALIAS_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias-attribute", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setRestartAllServices()).setDefaultValue(new ModelNode("cn"))).build();
    static final SimpleAttributeDefinition CERTIFICATE_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-attribute", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setRestartAllServices()).setDefaultValue(new ModelNode("usercertificate"))).build();
    static final SimpleAttributeDefinition CERTIFICATE_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-type", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setRestartAllServices()).setDefaultValue(new ModelNode("X.509"))).build();
    static final SimpleAttributeDefinition CERTIFICATE_CHAIN_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-chain-attribute", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setRestartAllServices()).setDefaultValue(new ModelNode("userSMIMECertificate"))).build();
    static final SimpleAttributeDefinition CERTIFICATE_CHAIN_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-chain-encoding", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setRestartAllServices()).setDefaultValue(new ModelNode("PKCS7"))).build();
    static final SimpleAttributeDefinition KEY_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-attribute", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setRestartAllServices()).setDefaultValue(new ModelNode("userPKCS12"))).build();
    static final SimpleAttributeDefinition KEY_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-type", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setRestartAllServices()).setDefaultValue(new ModelNode("PKCS12"))).build();
    private static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("ldap-key-store");
    private static final SimpleAttributeDefinition SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("size", ModelType.INT).setStorageRuntime()).build();
    private static final AttributeDefinition[] CONFIG_ATTRIBUTES = new AttributeDefinition[]{DIR_CONTEXT, SEARCH_PATH, SEARCH_RECURSIVE, SEARCH_TIME_LIMIT, FILTER_ALIAS, FILTER_CERTIFICATE, FILTER_ITERATE, NewItemTemplateObjectDefinition.OBJECT_DEFINITION, ALIAS_ATTRIBUTE, CERTIFICATE_ATTRIBUTE, CERTIFICATE_TYPE, CERTIFICATE_CHAIN_ATTRIBUTE, CERTIFICATE_CHAIN_ENCODING, KEY_ATTRIBUTE, KEY_TYPE};
    private static final KeyStoreAddHandler ADD = new KeyStoreAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.KEY_STORE_RUNTIME_CAPABILITY);
    private static final AbstractWriteAttributeHandler WRITE = new ElytronReloadRequiredWriteAttributeHandler(CONFIG_ATTRIBUTES);

    LdapKeyStoreDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"ldap-key-store"), (ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.KEY_STORE_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : CONFIG_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)WRITE);
        }
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServiceStateDefinition.STATE, (OperationStepHandler)new ElytronRuntimeOnlyHandler(){

                protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName keyStoreName = LDAP_KEY_STORE_UTIL.serviceName(operation);
                    ServiceController serviceController = context.getServiceRegistry(false).getRequiredService(keyStoreName);
                    ServiceStateDefinition.populateResponse(context.getResult(), serviceController);
                }
            });
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)SIZE, (OperationStepHandler)new LdapKeyStoreRuntimeOnlyHandler(false){

                @Override
                protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, LdapKeyStoreService keyStoreService) throws OperationFailedException {
                    try {
                        result.set(keyStoreService.getValue().size());
                    }
                    catch (KeyStoreException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToAccessKeyStore(e);
                    }
                }
            });
        }
    }

    static abstract class LdapKeyStoreRuntimeOnlyHandler
    extends ElytronRuntimeOnlyHandler {
        private final boolean serviceMustBeUp;
        private final boolean writeAccess;

        LdapKeyStoreRuntimeOnlyHandler(boolean serviceMustBeUp, boolean writeAccess) {
            this.serviceMustBeUp = serviceMustBeUp;
            this.writeAccess = writeAccess;
        }

        LdapKeyStoreRuntimeOnlyHandler(boolean serviceMustBeUp) {
            this(serviceMustBeUp, false);
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName ldapKeyStoreName = LDAP_KEY_STORE_UTIL.serviceName(operation);
            ServiceController<KeyStore> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(this.writeAccess), ldapKeyStoreName, KeyStore.class);
            ServiceController.State serviceState = serviceContainer.getState();
            if (serviceState != ServiceController.State.UP) {
                if (this.serviceMustBeUp) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(ldapKeyStoreName, serviceState);
                }
                return;
            }
            this.performRuntime(context.getResult(), context, operation, (LdapKeyStoreService)serviceContainer.getService());
        }

        protected void performRuntime(ModelNode result, ModelNode operation, LdapKeyStoreService keyStoreService) throws OperationFailedException {
        }

        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, LdapKeyStoreService keyStoreService) throws OperationFailedException {
            this.performRuntime(result, operation, keyStoreService);
        }
    }

    static class NewItemTemplateAttributeObjectDefinition {
        static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final StringListAttributeDefinition VALUE = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("value").setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{NAME, VALUE};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("attribute", ATTRIBUTES).setRequired(false)).setXmlName("attribute")).build();

        NewItemTemplateAttributeObjectDefinition() {
        }
    }

    private static class KeyStoreAddHandler
    extends BaseAddHandler {
        private KeyStoreAddHandler() {
            super(Capabilities.KEY_STORE_RUNTIME_CAPABILITY, CONFIG_ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode newNode;
            ModelNode model = resource.getModel();
            String dirContextName = DIR_CONTEXT.resolveModelAttribute(context, model).asStringOrNull();
            String searchPath = SEARCH_PATH.resolveModelAttribute(context, model).asStringOrNull();
            Object filterAlias = FILTER_ALIAS.resolveModelAttribute(context, model).asStringOrNull();
            Object filterCertificate = FILTER_CERTIFICATE.resolveModelAttribute(context, model).asStringOrNull();
            Object filterIterate = FILTER_ITERATE.resolveModelAttribute(context, model).asStringOrNull();
            String aliasAttribute = ALIAS_ATTRIBUTE.resolveModelAttribute(context, model).asStringOrNull();
            String certificateAttribute = CERTIFICATE_ATTRIBUTE.resolveModelAttribute(context, model).asStringOrNull();
            String certificateType = CERTIFICATE_TYPE.resolveModelAttribute(context, model).asStringOrNull();
            String certificateChainAttribute = CERTIFICATE_CHAIN_ATTRIBUTE.resolveModelAttribute(context, model).asStringOrNull();
            String certificateChainEncoding = CERTIFICATE_CHAIN_ENCODING.resolveModelAttribute(context, model).asStringOrNull();
            String keyAttribute = KEY_ATTRIBUTE.resolveModelAttribute(context, model).asStringOrNull();
            String keyType = KEY_TYPE.resolveModelAttribute(context, model).asStringOrNull();
            LdapName createPathLdapName = null;
            String createRdn = null;
            BasicAttributes createAttributes = null;
            if (filterAlias == null) {
                filterAlias = "(" + aliasAttribute + "={0})";
            }
            if (filterCertificate == null) {
                filterCertificate = "(" + certificateAttribute + "={0})";
            }
            if (filterIterate == null) {
                filterIterate = "(" + aliasAttribute + "=*)";
            }
            if ((newNode = NewItemTemplateObjectDefinition.OBJECT_DEFINITION.resolveModelAttribute(context, model)).isDefined()) {
                ModelNode createAttributesNode;
                String createPath = NewItemTemplateObjectDefinition.NEW_ITEM_PATH.resolveModelAttribute(context, newNode).asString();
                createRdn = NewItemTemplateObjectDefinition.NEW_ITEM_RDN.resolveModelAttribute(context, newNode).asString();
                if (createPath != null) {
                    try {
                        createPathLdapName = new LdapName(createPath);
                    }
                    catch (InvalidNameException e) {
                        throw new OperationFailedException((Throwable)e);
                    }
                }
                if ((createAttributesNode = NewItemTemplateObjectDefinition.NEW_ITEM_ATTRIBUTES.resolveModelAttribute(context, newNode)).isDefined()) {
                    createAttributes = new BasicAttributes(true);
                    for (ModelNode attributeNode : createAttributesNode.asList()) {
                        ModelNode nameNode = NewItemTemplateAttributeObjectDefinition.NAME.resolveModelAttribute(context, attributeNode);
                        ModelNode valuesNode = NewItemTemplateAttributeObjectDefinition.VALUE.resolveModelAttribute(context, attributeNode);
                        if (valuesNode.getType() == ModelType.LIST) {
                            BasicAttribute listAttribute = new BasicAttribute(nameNode.asString());
                            for (ModelNode valueNode : valuesNode.asList()) {
                                listAttribute.add(valueNode.asString());
                            }
                            createAttributes.put(listAttribute);
                            continue;
                        }
                        createAttributes.put(new BasicAttribute(nameNode.asString(), valuesNode.asString()));
                    }
                }
            }
            LdapKeyStoreService keyStoreService = new LdapKeyStoreService(searchPath, (String)filterAlias, (String)filterCertificate, (String)filterIterate, createPathLdapName, createRdn, createAttributes, aliasAttribute, certificateAttribute, certificateType, certificateChainAttribute, certificateChainEncoding, keyAttribute, keyType);
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(KeyStore.class);
            ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)keyStoreService).setInitialMode(ServiceController.Mode.ACTIVE);
            String dirContextCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.dir-context", (String)dirContextName);
            ServiceName dirContextServiceName = context.getCapabilityServiceName(dirContextCapability, DirContextSupplier.class);
            serviceBuilder.addDependency(dirContextServiceName, DirContextSupplier.class, keyStoreService.getDirContextSupplierInjector());
            ElytronDefinition.commonDependencies(serviceBuilder).install();
        }
    }

    static class NewItemTemplateObjectDefinition {
        static final SimpleAttributeDefinition NEW_ITEM_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("new-item-path", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setRequires(new String[]{"new-item-rdn", "new-item-attributes"})).build();
        static final SimpleAttributeDefinition NEW_ITEM_RDN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("new-item-rdn", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setRequires(new String[]{"new-item-path", "new-item-attributes"})).build();
        static final ObjectListAttributeDefinition NEW_ITEM_ATTRIBUTES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("new-item-attributes", NewItemTemplateAttributeObjectDefinition.OBJECT_DEFINITION).setRequired(true)).setMinSize(1)).setAllowDuplicates(true)).setAttributeParser(AttributeParser.UNWRAPPED_OBJECT_LIST_PARSER)).setAttributeMarshaller(AttributeMarshaller.UNWRAPPED_OBJECT_LIST_MARSHALLER)).setRequires(new String[]{"new-item-path", "new-item-rdn"})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{NEW_ITEM_PATH, NEW_ITEM_RDN, NEW_ITEM_ATTRIBUTES};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("new-item-template", ATTRIBUTES).setRestartAllServices()).build();

        NewItemTemplateObjectDefinition() {
        }
    }
}

