/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.elytron.AuditResourceDefinitions;
import org.wildfly.extension.elytron.AuthenticationClientDefinitions;
import org.wildfly.extension.elytron.DomainDefinition;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.JdbcRealmDefinition;
import org.wildfly.extension.elytron.KerberosSecurityFactoryDefinition;
import org.wildfly.extension.elytron.SSLDefinitions;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.x500.cert.acme.CertificateAuthority;

public final class ElytronSubsystemTransformers
implements ExtensionTransformerRegistration {
    private static final AttributeConverter MAPPING_PERMISSION_SET_CONVERTER = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode permissionMapping : attributeValue.asList()) {
                    if (!permissionMapping.hasDefined("permission-sets")) continue;
                    ModelNode permissionSets = permissionMapping.get("permission-sets");
                    for (ModelNode permissionSet : permissionSets.asList()) {
                        ModelNode permissionSetName = permissionSet.get("permission-set");
                        PathAddress permissionSetAddress = address.getParent().append("permission-set", permissionSetName.asString());
                        ModelNode permissions = context.readResourceFromRoot(permissionSetAddress).getModel().get("permissions");
                        for (ModelNode permission : permissions.asList()) {
                            permissionMapping.get("permissions").add(permission);
                        }
                    }
                    permissionMapping.remove("permission-sets");
                }
            }
        }
    };
    private static final AttributeConverter CONSTANT_PERMISSION_SET_CONVERTER = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                ModelNode allPermissions = new ModelNode();
                for (ModelNode permissionSet : attributeValue.asList()) {
                    ModelNode permissionSetName = permissionSet.get("permission-set");
                    PathAddress permissionSetAddress = address.getParent().append("permission-set", permissionSetName.asString());
                    ModelNode permissions = context.readResourceFromRoot(permissionSetAddress).getModel().get("permissions");
                    for (ModelNode permission : permissions.asList()) {
                        allPermissions.add(permission);
                    }
                }
                attributeValue.set(allPermissions);
            }
        }
    };
    private static final AttributeConverter MAXIMUM_CERT_PATH_CONVERTER = new AttributeConverter.DefaultAttributeConverter(){
        Integer maxCertPath;

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeName.equals("maximum-cert-path")) {
                this.maxCertPath = attributeValue.asIntOrNull();
                attributeValue.clear();
            } else if (attributeValue.isDefined()) {
                if (this.maxCertPath != null) {
                    attributeValue.set("maximum-cert-path", new ModelNode(this.maxCertPath.intValue()));
                } else {
                    attributeValue.set("maximum-cert-path", new ModelNode(5));
                }
            }
        }
    };
    private static final AttributeConverter CERTIFICATE_REVOCATION_LIST_CONVERTER = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                List crls = attributeValue.asListOrEmpty();
                if (crls.size() == 1) {
                    ModelNode singleCrl = (ModelNode)crls.get(0);
                    attributeValue.clear();
                    attributeValue.get("path").set(singleCrl.get("path"));
                    attributeValue.get("relative-to").set(singleCrl.get("relative-to"));
                } else if (crls.isEmpty()) {
                    attributeValue.clear();
                }
            }
        }
    };
    private static final RejectAttributeChecker REJECT_IF_DIFFERENT_FROM_SYNCHRONIZED = new RejectAttributeChecker.DefaultRejectAttributeChecker(){

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ElytronSubsystemMessages.ROOT_LOGGER.unableToTransformTornAttribute("autoflush", "synchronized");
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                boolean synced = context.readResourceFromRoot(address).getModel().get("synchronized").asBoolean();
                return synced != attributeValue.asBoolean();
            }
            return false;
        }
    };
    private static final DiscardAttributeChecker DISCARD_IF_EQUALS_SYNCHRONIZED = new DiscardAttributeChecker.DefaultDiscardAttributeChecker(){

        protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            boolean synced = context.readResourceFromRoot(address).getModel().get("synchronized").asBoolean();
            return synced == attributeValue.asBoolean();
        }
    };
    private static final RejectAttributeChecker REJECT_IF_MULTIPLE_AUTHORIZATION_REALMS = new RejectAttributeChecker.DefaultRejectAttributeChecker(){

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode value, TransformationContext context) {
            if (value.isDefined()) {
                List values = value.asList();
                return values.size() > 1;
            }
            return false;
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ElytronSubsystemMessages.ROOT_LOGGER.invalidAttributeValue("authorization-realms").getMessage();
        }
    };
    private static final RejectAttributeChecker REJECT_IF_MULTIPLE_CERTIFICATE_REVOCATION_LISTS = new RejectAttributeChecker.DefaultRejectAttributeChecker(){

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode value, TransformationContext context) {
            if (value.isDefined()) {
                List values = value.asList();
                return values.size() > 1;
            }
            return false;
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ElytronSubsystemMessages.ROOT_LOGGER.invalidAttributeValue("certificate-revocation-lists").getMessage();
        }
    };
    private static final AttributeConverter ONE_AUTHORIZATION_REALMS = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                String authorizationRealm = ((ModelNode)context.readResourceFromRoot(address).getModel().get("authorization-realms").asList().get(0)).asString();
                attributeValue.set(authorizationRealm);
            }
        }
    };

    public String getSubsystemName() {
        return "elytron";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        ElytronSubsystemTransformers.from15(chainedBuilder);
        ElytronSubsystemTransformers.from14(chainedBuilder);
        ElytronSubsystemTransformers.from13(chainedBuilder);
        ElytronSubsystemTransformers.from12(chainedBuilder);
        ElytronSubsystemTransformers.from11(chainedBuilder);
        ElytronSubsystemTransformers.from10(chainedBuilder);
        ElytronSubsystemTransformers.from9(chainedBuilder);
        ElytronSubsystemTransformers.from8(chainedBuilder);
        ElytronSubsystemTransformers.from7(chainedBuilder);
        ElytronSubsystemTransformers.from6(chainedBuilder);
        ElytronSubsystemTransformers.from5(chainedBuilder);
        ElytronSubsystemTransformers.from4(chainedBuilder);
        ElytronSubsystemTransformers.from3(chainedBuilder);
        ElytronSubsystemTransformers.from2(chainedBuilder);
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{ElytronExtension.ELYTRON_14_0_0, ElytronExtension.ELYTRON_13_0_0, ElytronExtension.ELYTRON_12_0_0, ElytronExtension.ELYTRON_11_0_0, ElytronExtension.ELYTRON_10_0_0, ElytronExtension.ELYTRON_9_0_0, ElytronExtension.ELYTRON_8_0_0, ElytronExtension.ELYTRON_7_0_0, ElytronExtension.ELYTRON_6_0_0, ElytronExtension.ELYTRON_5_0_0, ElytronExtension.ELYTRON_4_0_0, ElytronExtension.ELYTRON_3_0_0, ElytronExtension.ELYTRON_2_0_0, ElytronExtension.ELYTRON_1_2_0}});
    }

    private static void from15(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_15_0_0, ElytronExtension.ELYTRON_14_0_0);
    }

    private static void from14(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_14_0_0, ElytronExtension.ELYTRON_13_0_0);
        builder.addChildResource(PathElement.pathElement((String)"server-ssl-sni-context")).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode value, TransformationContext context) {
                if (value.isDefined()) {
                    for (String hostname : value.keys()) {
                        if (!hostname.contains("^")) continue;
                        return true;
                    }
                }
                return false;
            }

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return ElytronSubsystemMessages.ROOT_LOGGER.hostContextMapHostnameContainsCaret().getMessage();
            }
        }, new String[]{"host-context-map"});
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"properties-realm")).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new String[]{"hash-encoding"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new String[]{"hash-charset"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"hash-encoding"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"hash-charset"});
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"server-ssl-context")).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ListRejectAttributeChecker((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode("SSLv2Hello"))), new String[]{"protocols"})).end();
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"client-ssl-context")).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ListRejectAttributeChecker((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode("SSLv2Hello"))), new String[]{"protocols"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"filesystem-realm")).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new String[]{"hash-encoding"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new String[]{"hash-charset"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"hash-encoding"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"hash-charset"});
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"jdbc-realm")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"hash-charset"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new String[]{"hash-charset"});
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"ldap-realm")).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new String[]{"hash-charset"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new String[]{"hash-encoding"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"hash-charset"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"hash-encoding"});
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"trust-manager")).getAttributeBuilder().addRejectCheck(REJECT_IF_MULTIPLE_CERTIFICATE_REVOCATION_LISTS, new String[]{"certificate-revocation-lists"})).addRename("certificate-revocation-lists", "certificate-revocation-list")).setValueConverter(CERTIFICATE_REVOCATION_LIST_CONVERTER, new String[]{"certificate-revocation-lists"})).end();
    }

    private static void from13(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_13_0_0, ElytronExtension.ELYTRON_12_0_0);
        builder.rejectChildResource(PathElement.pathElement((String)"expression", (String)"encryption"));
        builder.rejectChildResource(PathElement.pathElement((String)"secret-key-credential-store"));
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"credential-store")).getAttributeBuilder().addRename("path", "location")).end();
    }

    private static void from12(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_12_0_0, ElytronExtension.ELYTRON_11_0_0);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"key-manager")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"generate-self-signed-certificate-host"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{SSLDefinitions.GENERATE_SELF_SIGNED_CERTIFICATE_HOST})).end();
        builder.rejectChildResource(PathElement.pathElement((String)"case-principal-transformer"));
    }

    private static void from11(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_11_0_0, ElytronExtension.ELYTRON_10_0_0);
        builder.rejectChildResource(PathElement.pathElement((String)"distributed-realm"));
        builder.rejectChildResource(PathElement.pathElement((String)"failover-realm"));
    }

    private static void from10(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_10_0_0, ElytronExtension.ELYTRON_9_0_0);
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"authentication-configuration")).getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{"credential-reference"})).end();
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"key-store")).getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{"credential-reference"})).end();
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"key-manager")).getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{"credential-reference"})).end();
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"credential-store")).getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{"credential-reference"})).end();
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"dir-context")).getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{"credential-reference"})).end();
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"certificate-authority-account")).getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{"credential-reference"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"security-domain")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"role-decoder"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{DomainDefinition.ROLE_DECODER})).end();
        builder.rejectChildResource(PathElement.pathElement((String)"source-address-role-decoder"));
        builder.rejectChildResource(PathElement.pathElement((String)"aggregate-role-decoder"));
        builder.rejectChildResource(PathElement.pathElement((String)"regex-role-mapper"));
    }

    private static void from9(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_9_0_0, ElytronExtension.ELYTRON_8_0_0);
        builder.addChildResource(PathElement.pathElement((String)"authentication-configuration")).getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{AuthenticationClientDefinitions.WEBSERVICES});
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"server-ssl-context")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"cipher-suite-names"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{SSLDefinitions.CIPHER_SUITE_NAMES})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"client-ssl-context")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"cipher-suite-names"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{SSLDefinitions.CIPHER_SUITE_NAMES})).end();
    }

    private static void from8(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_8_0_0, ElytronExtension.ELYTRON_7_0_0);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"security-domain")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"evidence-decoder"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{DomainDefinition.EVIDENCE_DECODER})).end();
        builder.rejectChildResource(PathElement.pathElement((String)"x500-subject-evidence-decoder"));
        builder.rejectChildResource(PathElement.pathElement((String)"x509-subject-alt-name-evidence-decoder"));
        builder.rejectChildResource(PathElement.pathElement((String)"custom-evidence-decoder"));
        builder.rejectChildResource(PathElement.pathElement((String)"aggregate-evidence-decoder"));
        builder.rejectChildResource(PathElement.pathElement((String)"certificate-authority"));
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"syslog-audit-log")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"syslog-format"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"reconnect-attempts"})).setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new String[]{"syslog-format", "reconnect-attempts"})).end();
        builder.addChildResource(PathElement.pathElement((String)"certificate-authority-account")).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode value, TransformationContext context) {
                return value.isDefined() && !value.asString().equalsIgnoreCase(CertificateAuthority.LETS_ENCRYPT.getName());
            }

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return ElytronSubsystemMessages.ROOT_LOGGER.invalidAttributeValue("certificate-authority").getMessage();
            }
        }, new String[]{"certificate-authority"});
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"aggregate-realm")).getAttributeBuilder().addRejectCheck(REJECT_IF_MULTIPLE_AUTHORIZATION_REALMS, new String[]{"authorization-realms"})).setValueConverter(ONE_AUTHORIZATION_REALMS, new String[]{"authorization-realms"})).addRename("authorization-realms", "authorization-realm")).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"principal-transformer"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"trust-manager")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"ocsp"})).setValueConverter(MAXIMUM_CERT_PATH_CONVERTER, new String[]{"maximum-cert-path", "certificate-revocation-list"})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(ModelNode.TRUE), new String[]{"only-leaf-cert"})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(ModelNode.TRUE), new String[]{"soft-fail"})).setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{"only-leaf-cert"})).setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{"soft-fail"})).end();
    }

    private static void from7(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_7_0_0, ElytronExtension.ELYTRON_6_0_0);
        HashMap<String, RejectAttributeChecker> keyMapperChecker = new HashMap<String, RejectAttributeChecker>();
        keyMapperChecker.put("hash-encoding", RejectAttributeChecker.DEFINED);
        keyMapperChecker.put("salt-encoding", RejectAttributeChecker.DEFINED);
        HashMap<String, Object> principalQueryCheckers = new HashMap<String, Object>();
        principalQueryCheckers.put("bcrypt-mapper", new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(keyMapperChecker));
        principalQueryCheckers.put("salted-simple-digest-mapper", new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(keyMapperChecker));
        principalQueryCheckers.put("simple-digest-mapper", new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(keyMapperChecker));
        principalQueryCheckers.put("scram-mapper", new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(keyMapperChecker));
        principalQueryCheckers.put("modular-crypt-mapper", RejectAttributeChecker.DEFINED);
        builder.addChildResource(PathElement.pathElement((String)"jdbc-realm")).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ListRejectAttributeChecker((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(principalQueryCheckers)), new AttributeDefinition[]{JdbcRealmDefinition.PrincipalQueryAttributes.PRINCIPAL_QUERY});
    }

    private static void from6(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_6_0_0, ElytronExtension.ELYTRON_5_0_0);
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"key-store")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new String[]{"type"})).end();
    }

    private static void from5(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_5_0_0, ElytronExtension.ELYTRON_4_0_0);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{ElytronDefinition.REGISTER_JASPI_FACTORY})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"default-ssl-context"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ElytronDefinition.DEFAULT_SSL_CONTEXT})).end();
        builder.rejectChildResource(PathElement.pathElement((String)"jaspi-configuration"));
        ElytronSubsystemTransformers.transformAutoFlush(builder, "file-audit-log");
        ElytronSubsystemTransformers.transformAutoFlush(builder, "periodic-rotating-file-audit-log");
        ElytronSubsystemTransformers.transformAutoFlush(builder, "size-rotating-file-audit-log");
        builder.rejectChildResource(PathElement.pathElement((String)"server-ssl-sni-context"));
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"token-realm")).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("host-name-verification-policy", RejectAttributeChecker.DEFINED)), new String[]{"jwt"})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("ssl-context", RejectAttributeChecker.DEFINED)), new String[]{"jwt"})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("key-map", RejectAttributeChecker.DEFINED)), new String[]{"jwt"})).end();
    }

    private static void transformAutoFlush(ResourceTransformationDescriptionBuilder builder, String resourceName) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)resourceName)).getAttributeBuilder().setDiscard(DISCARD_IF_EQUALS_SYNCHRONIZED, new AttributeDefinition[]{AuditResourceDefinitions.AUTOFLUSH})).addRejectCheck(REJECT_IF_DIFFERENT_FROM_SYNCHRONIZED, new AttributeDefinition[]{AuditResourceDefinitions.AUTOFLUSH})).end();
    }

    private static void from4(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_4_0_0, ElytronExtension.ELYTRON_3_0_0);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"jdbc-realm")).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ListRejectAttributeChecker((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("scram-mapper", new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("algorithm", new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode("scram-sha-384"))))))), new AttributeDefinition[]{JdbcRealmDefinition.PrincipalQueryAttributes.PRINCIPAL_QUERIES})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ListRejectAttributeChecker((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("scram-mapper", new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap("algorithm", new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode("scram-sha-512"))))))), new AttributeDefinition[]{JdbcRealmDefinition.PrincipalQueryAttributes.PRINCIPAL_QUERIES})).end();
        builder.rejectChildResource(PathElement.pathElement((String)"certificate-authority-account"));
        builder.rejectChildResource(PathElement.pathElement((String)"mapped-role-mapper"));
        builder.rejectChildResource(PathElement.pathElement((String)"custom-security-event-listener"));
    }

    private static void from3(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_3_0_0, ElytronExtension.ELYTRON_2_0_0);
        builder.discardChildResource(PathElement.pathElement((String)"permission-set"));
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"simple-permission-mapper")).getAttributeBuilder().setValueConverter(MAPPING_PERMISSION_SET_CONVERTER, new String[]{"permission-mappings"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"constant-permission-mapper")).getAttributeBuilder().addRename("permission-sets", "permissions")).setValueConverter(CONSTANT_PERMISSION_SET_CONVERTER, new String[]{"permission-sets"})).end();
    }

    private static void from2(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_2_0_0, ElytronExtension.ELYTRON_1_2_0);
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"kerberos-security-factory")).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{ModelNode.ZERO}), new AttributeDefinition[]{KerberosSecurityFactoryDefinition.FAIL_CACHE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{KerberosSecurityFactoryDefinition.FAIL_CACHE});
    }
}

