/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.lang.reflect.Field;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SecurityActions;

class SecurityPropertyService
implements Service<Void> {
    static final ServiceName SERVICE_NAME = ElytronExtension.BASE_SERVICE_NAME.append(new String[]{"security-properties"});
    private volatile boolean started = false;
    private final Map<String, SetState> valuesSet = new HashMap<String, SetState>();
    private final Map<String, String> toSet = new HashMap<String, String>();

    SecurityPropertyService(Map<String, String> propertiesToBeSet) {
        this.toSet.putAll(propertiesToBeSet);
    }

    public synchronized void start(StartContext context) throws StartException {
        SecurityActions.doPrivileged(() -> {
            this.toSet.forEach((name, value) -> this.setPropertyImmediate((String)name, (String)value));
            return null;
        });
        this.toSet.clear();
        this.started = true;
    }

    public synchronized void stop(StopContext context) {
        SecurityActions.doPrivileged(() -> {
            this.valuesSet.forEach((name, state) -> {
                this.restoreProperty((String)name, ((SetState)state).getPreviousValue());
                this.toSet.put((String)name, ((SetState)state).getNewValue());
            });
            return null;
        });
        this.valuesSet.clear();
        this.started = false;
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    private void restoreProperty(String name, String restorationValue) {
        if (restorationValue == null) {
            try {
                Field f = Security.class.getDeclaredField("props");
                f.setAccessible(true);
                Properties props = (Properties)f.get(null);
                props.remove(name);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {}
        } else {
            Security.setProperty(name, restorationValue);
        }
    }

    private void setPropertyImmediate(String name, String value) {
        String original = this.valuesSet.containsKey(name) ? this.valuesSet.get(name).previousValue : Security.getProperty(name);
        Security.setProperty(name, value);
        this.valuesSet.put(name, new SetState(original, value));
    }

    synchronized void setProperty(String name, String value) {
        if (this.started) {
            SecurityActions.doPrivileged(() -> {
                this.setPropertyImmediate(name, value);
                return null;
            });
        } else {
            this.toSet.put(name, value);
        }
    }

    synchronized void removeProperty(String name) {
        if (this.started) {
            SetState state = this.valuesSet.remove(name);
            SecurityActions.doPrivileged(() -> {
                this.restoreProperty(name, state.getPreviousValue());
                return null;
            });
        } else {
            this.toSet.remove(name);
        }
    }

    private static class SetState {
        private final String previousValue;
        private final String newValue;

        private SetState(String previousValue, String newValue) {
            this.previousValue = previousValue;
            this.newValue = newValue;
        }

        private String getPreviousValue() {
            return this.previousValue;
        }

        private String getNewValue() {
            return this.newValue;
        }
    }
}

