/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.GSSAPIServerSubjectFactory;
import io.undertow.security.api.NonceManager;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.handlers.SinglePortConfidentialityHandler;
import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.security.impl.CachedAuthenticatedSessionMechanism;
import io.undertow.security.impl.ClientCertAuthenticationMechanism;
import io.undertow.security.impl.DigestAuthenticationMechanism;
import io.undertow.security.impl.DigestQop;
import io.undertow.security.impl.GSSAPIAuthenticationMechanism;
import io.undertow.security.impl.SimpleNonceManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.cache.CacheHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.util.Headers;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.DomainApiCheckHandler;
import org.jboss.as.domain.http.server.ErrorContextHandler;
import org.jboss.as.domain.http.server.InExecutorHandler;
import org.jboss.as.domain.http.server.ManagementHttpRequestHandler;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.domain.http.server.ManagementRootConsoleRedirectHandler;
import org.jboss.as.domain.http.server.ResourceHandlerDefinition;
import org.jboss.as.domain.http.server.cors.CorsHttpHandler;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.as.domain.http.server.security.AnonymousMechanism;
import org.jboss.as.domain.http.server.security.AuthenticationMechanismWrapper;
import org.jboss.as.domain.http.server.security.DmrFailureReadinessHandler;
import org.jboss.as.domain.http.server.security.LogoutHandler;
import org.jboss.as.domain.http.server.security.RealmIdentityManager;
import org.jboss.as.domain.http.server.security.RedirectReadinessHandler;
import org.jboss.as.domain.http.server.security.ServerSubjectFactory;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.StartException;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.ssl.SslConnection;

public class ManagementHttpServer {
    private static final Map<Pattern, Charset> USER_AGENT_CHARSET_MAP = ManagementHttpServer.generateCharsetMap();
    private final HttpOpenListener openListener;
    private final InetSocketAddress httpAddress;
    private final InetSocketAddress secureAddress;
    private final XnioWorker worker;
    private volatile AcceptingChannel<StreamConnection> normalServer;
    private volatile AcceptingChannel<SslConnection> secureServer;
    private final SSLContext sslContext;
    private final SslClientAuthMode sslClientAuthMode;

    private ManagementHttpServer(HttpOpenListener openListener, InetSocketAddress httpAddress, InetSocketAddress secureAddress, SSLContext sslContext, SslClientAuthMode sslClientAuthMode, XnioWorker worker) {
        this.openListener = openListener;
        this.httpAddress = httpAddress;
        this.secureAddress = secureAddress;
        this.sslContext = sslContext;
        this.sslClientAuthMode = sslClientAuthMode;
        this.worker = worker;
    }

    public void start() {
        try {
            OptionMap.Builder serverOptionsBuilder = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true);
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
            if (this.httpAddress != null) {
                this.normalServer = this.worker.createStreamConnectionServer((SocketAddress)this.httpAddress, acceptListener, serverOptionsBuilder.getMap());
                this.normalServer.resumeAccepts();
            }
            if (this.secureAddress != null) {
                if (this.sslClientAuthMode != null) {
                    serverOptionsBuilder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)this.sslClientAuthMode);
                }
                OptionMap secureOptions = serverOptionsBuilder.getMap();
                UndertowXnioSsl xnioSsl = new UndertowXnioSsl(this.worker.getXnio(), secureOptions, this.sslContext);
                this.secureServer = xnioSsl.createSslConnectionServer(this.worker, this.secureAddress, acceptListener, secureOptions);
                this.secureServer.resumeAccepts();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        IoUtils.safeClose(this.normalServer);
        IoUtils.safeClose(this.secureServer);
    }

    public static ManagementHttpServer create(InetSocketAddress bindAddress, InetSocketAddress secureBindAddress, int backlog, ModelController modelController, SecurityRealm securityRealm, ControlledProcessStateService controlledProcessStateService, ConsoleMode consoleMode, String consoleSlot, ChannelUpgradeHandler upgradeHandler, ManagementHttpRequestProcessor managementHttpRequestProcessor, Collection<String> allowedOrigins, XnioWorker worker, Executor managementExecutor) throws IOException, StartException {
        boolean redirectSupported;
        SSLContext sslContext = null;
        SslClientAuthMode sslClientAuthMode = null;
        if (secureBindAddress != null) {
            sslContext = securityRealm.getSSLContext();
            if (sslContext == null) {
                throw HttpServerLogger.ROOT_LOGGER.sslRequestedNoSslContext();
            }
            Set supportedMechanisms = securityRealm.getSupportedAuthenticationMechanisms();
            if (supportedMechanisms.contains(AuthMechanism.CLIENT_CERT)) {
                sslClientAuthMode = supportedMechanisms.contains(AuthMechanism.DIGEST) || supportedMechanisms.contains(AuthMechanism.PLAIN) ? SslClientAuthMode.REQUESTED : SslClientAuthMode.REQUIRED;
            }
        }
        HttpOpenListener openListener = new HttpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 4096, 40960));
        int secureRedirectPort = secureBindAddress != null ? secureBindAddress.getPort() : -1;
        boolean bl = redirectSupported = bindAddress == null || secureBindAddress == null || bindAddress.getAddress().equals(secureBindAddress.getAddress());
        if (!redirectSupported && secureRedirectPort > 0) {
            HttpServerLogger.ROOT_LOGGER.httpsRedirectNotSupported(bindAddress.getAddress(), secureBindAddress.getAddress());
            secureRedirectPort = -1;
        }
        ManagementHttpServer.setupOpenListener(openListener, modelController, consoleMode, consoleSlot, controlledProcessStateService, secureRedirectPort, securityRealm, upgradeHandler, managementHttpRequestProcessor, allowedOrigins, managementExecutor);
        return new ManagementHttpServer(openListener, bindAddress, secureBindAddress, sslContext, sslClientAuthMode, worker);
    }

    private static void setupOpenListener(HttpOpenListener listener, ModelController modelController, ConsoleMode consoleMode, String consoleSlot, ControlledProcessStateService controlledProcessStateService, int secureRedirectPort, SecurityRealm securityRealm, ChannelUpgradeHandler upgradeHandler, ManagementHttpRequestProcessor managementHttpRequestProcessor, Collection<String> allowedOrigins, Executor managementExecutor) {
        PathHandler pathHandler;
        CanonicalPathHandler canonicalPathHandler = new CanonicalPathHandler();
        ManagementHttpRequestHandler managementHttpRequestHandler = new ManagementHttpRequestHandler(managementHttpRequestProcessor, (HttpHandler)canonicalPathHandler);
        CorsHttpHandler corsHandler = new CorsHttpHandler(managementHttpRequestHandler, allowedOrigins);
        listener.setRootHandler((HttpHandler)new UpgradeFixHandler(corsHandler));
        PathHandler current = pathHandler = new PathHandler();
        if (upgradeHandler != null) {
            upgradeHandler.setNonUpgradeHandler((HttpHandler)current);
            current = upgradeHandler;
        }
        if (secureRedirectPort > 0) {
            current = new SinglePortConfidentialityHandler((HttpHandler)current, secureRedirectPort);
        }
        current = new CacheHandler(new DirectBufferCache(1024, 10240, 1024000, BufferAllocator.BYTE_BUFFER_ALLOCATOR), (HttpHandler)current);
        current = new SimpleErrorPageHandler((HttpHandler)current);
        canonicalPathHandler.setNext((HttpHandler)current);
        ResourceHandlerDefinition consoleHandler = null;
        try {
            consoleHandler = consoleMode.createConsoleHandler(consoleSlot);
        }
        catch (ModuleLoadException e) {
            HttpServerLogger.ROOT_LOGGER.consoleModuleNotFound(consoleSlot == null ? "main" : consoleSlot);
        }
        try {
            pathHandler.addPrefixPath("/error", ErrorContextHandler.createErrorContext(consoleSlot));
        }
        catch (ModuleLoadException e) {
            HttpServerLogger.ROOT_LOGGER.errorContextModuleNotFound(consoleSlot == null ? "main" : consoleSlot);
        }
        ManagementRootConsoleRedirectHandler rootConsoleRedirectHandler = new ManagementRootConsoleRedirectHandler(consoleHandler);
        pathHandler.addPrefixPath("/", (HttpHandler)rootConsoleRedirectHandler);
        if (consoleHandler != null) {
            RedirectReadinessHandler readinessHandler = new RedirectReadinessHandler(securityRealm, consoleHandler.getHandler(), "/error");
            pathHandler.addPrefixPath(consoleHandler.getContext(), (HttpHandler)readinessHandler);
        }
        HttpHandler domainApiHandler = InExecutorHandler.wrap(managementExecutor, new DomainApiCheckHandler(modelController, controlledProcessStateService, allowedOrigins));
        HttpHandler readinessHandler = ManagementHttpServer.wrapXFrameOptions(new DmrFailureReadinessHandler(securityRealm, ManagementHttpServer.secureDomainAccess(domainApiHandler, securityRealm), "/error"));
        pathHandler.addPrefixPath(DomainApiCheckHandler.PATH, readinessHandler);
        pathHandler.addExactPath("management-upload", readinessHandler);
        if (securityRealm != null) {
            pathHandler.addPrefixPath("/logout", ManagementHttpServer.wrapXFrameOptions(new LogoutHandler(securityRealm.getName())));
        }
    }

    private static HttpHandler secureDomainAccess(HttpHandler domainHandler, SecurityRealm securityRealm) {
        List<AuthenticationMechanism> undertowMechanisms;
        RealmIdentityManager rim = new RealmIdentityManager(securityRealm);
        if (securityRealm != null) {
            Set mechanisms = securityRealm.getSupportedAuthenticationMechanisms();
            undertowMechanisms = new ArrayList<AuthenticationMechanism>(mechanisms.size());
            undertowMechanisms.add(ManagementHttpServer.wrap((AuthenticationMechanism)new CachedAuthenticatedSessionMechanism(), null));
            for (AuthMechanism current : mechanisms) {
                switch (current) {
                    case KERBEROS: {
                        undertowMechanisms.add(ManagementHttpServer.wrap((AuthenticationMechanism)new GSSAPIAuthenticationMechanism((GSSAPIServerSubjectFactory)new ServerSubjectFactory(securityRealm, rim)), current));
                        break;
                    }
                    case CLIENT_CERT: {
                        undertowMechanisms.add(ManagementHttpServer.wrap((AuthenticationMechanism)new ClientCertAuthenticationMechanism(), current));
                        break;
                    }
                    case DIGEST: {
                        List<DigestAlgorithm> digestAlgorithms = Collections.singletonList(DigestAlgorithm.MD5);
                        List<DigestQop> digestQops = Collections.singletonList(DigestQop.AUTH);
                        undertowMechanisms.add(ManagementHttpServer.wrap((AuthenticationMechanism)new DigestAuthenticationMechanism(digestAlgorithms, digestQops, securityRealm.getName(), "/management", (NonceManager)new SimpleNonceManager()), current));
                        break;
                    }
                    case PLAIN: {
                        undertowMechanisms.add(ManagementHttpServer.wrap((AuthenticationMechanism)new BasicAuthenticationMechanism(securityRealm.getName(), "BASIC", false, null, StandardCharsets.UTF_8, USER_AGENT_CHARSET_MAP), current));
                        break;
                    }
                }
            }
        } else {
            undertowMechanisms = Collections.singletonList(ManagementHttpServer.wrap(new AnonymousMechanism(), null));
        }
        HttpHandler current = domainHandler;
        current = new AuthenticationCallHandler(current);
        current = new AuthenticationConstraintHandler(current);
        current = new AuthenticationMechanismsHandler(current, undertowMechanisms);
        return new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, (IdentityManager)rim, current);
    }

    private static Map<Pattern, Charset> generateCharsetMap() {
        HashMap<Pattern, Charset> charsetMap = new HashMap<Pattern, Charset>();
        charsetMap.put(Pattern.compile("Mozilla/5\\.0 \\(.*\\) Gecko/.* Firefox/.*"), StandardCharsets.ISO_8859_1);
        charsetMap.put(Pattern.compile("(?!.*OPR)(?!.*Chrome)Mozilla/5\\.0 \\(.*\\).* Safari/.*"), StandardCharsets.ISO_8859_1);
        charsetMap.put(Pattern.compile("Mozilla/5\\.0 \\(.*; Trident/.*; rv:.*\\).*"), StandardCharsets.ISO_8859_1);
        charsetMap.put(Pattern.compile("Mozilla/5\\.0 \\(.* MSIE.* Trident/.*\\)"), StandardCharsets.ISO_8859_1);
        return Collections.unmodifiableMap(charsetMap);
    }

    private static AuthenticationMechanism wrap(AuthenticationMechanism toWrap, AuthMechanism mechanism) {
        return new AuthenticationMechanismWrapper(toWrap, mechanism);
    }

    private static HttpHandler wrapXFrameOptions(HttpHandler toWrap) {
        return new SetHeaderHandler(toWrap, "X-Frame-Options", "SAMEORIGIN");
    }

    private static class UpgradeFixHandler
    implements HttpHandler {
        final HttpHandler next;

        private UpgradeFixHandler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRequestHeaders().contains(Headers.UPGRADE)) {
                exchange.addResponseWrapper((factory, ex) -> {
                    StreamSinkConduit ret = (StreamSinkConduit)factory.create();
                    if (exchange.getResponseHeaders().contains(Headers.UPGRADE)) {
                        exchange.getResponseHeaders().add(Headers.CONTENT_LENGTH, "0");
                    }
                    return ret;
                });
            }
            this.next.handleRequest(exchange);
        }
    }
}

