/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.DomainApiGenericOperationHandler;
import org.jboss.as.domain.http.server.DomainApiHandler;
import org.jboss.as.domain.http.server.DomainApiUploadHandler;
import org.jboss.as.domain.http.server.cors.CorsUtil;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.as.domain.http.server.security.SubjectDoAsHandler;

class DomainApiCheckHandler
implements HttpHandler {
    static String PATH = "/management";
    private static final String GENERIC_CONTENT_REQUEST = PATH + "-upload";
    private static final String ADD_CONTENT_REQUEST = PATH + "/add-content";
    private final ControlledProcessStateService controlledProcessStateService;
    private final HttpHandler domainApiHandler;
    private final HttpHandler addContentHandler;
    private final HttpHandler genericOperationHandler;
    private final Collection<String> allowedOrigins = new ArrayList<String>();

    DomainApiCheckHandler(ModelController modelController, ControlledProcessStateService controlledProcessStateService, Collection<String> allowedOrigins) {
        this.controlledProcessStateService = controlledProcessStateService;
        this.domainApiHandler = new BlockingHandler((HttpHandler)new SubjectDoAsHandler(new EncodingHandler.Builder().build(Collections.emptyMap()).wrap((HttpHandler)new DomainApiHandler(modelController))));
        this.addContentHandler = new BlockingHandler((HttpHandler)new SubjectDoAsHandler(new DomainApiUploadHandler(modelController)));
        this.genericOperationHandler = new BlockingHandler((HttpHandler)new SubjectDoAsHandler(new EncodingHandler.Builder().build(Collections.emptyMap()).wrap((HttpHandler)new DomainApiGenericOperationHandler(modelController))));
        if (allowedOrigins != null) {
            for (String allowedOrigin : allowedOrigins) {
                this.allowedOrigins.add(CorsUtil.sanitizeDefaultPort(allowedOrigin));
            }
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (!this.commonChecks(exchange)) {
            return;
        }
        if (Methods.POST.equals(exchange.getRequestMethod())) {
            boolean isAddContent = ADD_CONTENT_REQUEST.equals(exchange.getRequestPath());
            boolean isGeneric = GENERIC_CONTENT_REQUEST.equals(exchange.getRequestPath());
            if (isAddContent) {
                this.addContentHandler.handleRequest(exchange);
                return;
            }
            if (isGeneric) {
                this.genericOperationHandler.handleRequest(exchange);
                return;
            }
            if (!this.checkPostContentType(exchange)) {
                return;
            }
        }
        this.domainApiHandler.handleRequest(exchange);
    }

    private boolean checkPostContentType(HttpServerExchange exchange) throws Exception {
        HeaderMap headers = exchange.getRequestHeaders();
        String contentType = this.extractContentType(headers.getFirst(Headers.CONTENT_TYPE));
        if (!"application/json".equals(contentType) && !"application/dmr-encoded".equals(contentType)) {
            HttpServerLogger.ROOT_LOGGER.debug("Request rejected due to unsupported media type - should be one of (application/json,application/dmr-encoded).");
            Common.UNSUPPORTED_MEDIA_TYPE.handleRequest(exchange);
            return false;
        }
        return true;
    }

    private String extractContentType(String fullContentType) {
        if (fullContentType == null) {
            return "";
        }
        int pos = fullContentType.indexOf(59);
        return pos < 0 ? fullContentType : fullContentType.substring(0, pos).trim();
    }

    private boolean commonChecks(HttpServerExchange exchange) throws Exception {
        ControlledProcessState.State currentState = this.controlledProcessStateService.getCurrentState();
        if (currentState == ControlledProcessState.State.STARTING || currentState == ControlledProcessState.State.STOPPING) {
            exchange.getResponseHeaders().add(Headers.RETRY_AFTER, "2");
            Common.SERVICE_UNAVAIABLE.handleRequest(exchange);
            return false;
        }
        HttpString requestMethod = exchange.getRequestMethod();
        if (!Methods.POST.equals(requestMethod) && !Methods.GET.equals(requestMethod)) {
            if (Methods.OPTIONS.equals(requestMethod)) {
                HttpServerLogger.ROOT_LOGGER.debug("Request rejected due to 'OPTIONS' method which is not supported.");
            } else {
                HttpServerLogger.ROOT_LOGGER.debug("Request rejected as method not one of (GET,POST).");
            }
            Common.METHOD_NOT_ALLOWED_HANDLER.handleRequest(exchange);
            return false;
        }
        HeaderMap headers = exchange.getRequestHeaders();
        if (headers.contains(Headers.ORIGIN)) {
            return CorsUtil.matchOrigin(exchange, this.allowedOrigins) != null;
        }
        return true;
    }
}

