/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.api.GSSAPIServerSubjectFactory;
import java.security.GeneralSecurityException;
import javax.security.auth.Subject;
import org.jboss.as.domain.http.server.security.RealmIdentityManager;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.SubjectIdentity;

public class ServerSubjectFactory
implements GSSAPIServerSubjectFactory {
    private final SecurityRealm securityRealm;
    private final RealmIdentityManager realmIdentityManager;

    public ServerSubjectFactory(SecurityRealm securityRealm, RealmIdentityManager realmIdentityManager) {
        this.securityRealm = securityRealm;
        this.realmIdentityManager = realmIdentityManager;
    }

    public Subject getSubjectForHost(String hostName) throws GeneralSecurityException {
        SubjectIdentity subjectIdentity = this.securityRealm.getSubjectIdentity(hostName, false);
        if (subjectIdentity != null) {
            this.realmIdentityManager.setCurrentSubjectIdentity(subjectIdentity);
        }
        return subjectIdentity == null ? null : subjectIdentity.getSubject();
    }
}

