/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.extension.discovery.DiscoveryModel;
import org.wildfly.extension.discovery.DiscoverySchema;
import org.wildfly.extension.discovery.DiscoverySubsystemDefinition;
import org.wildfly.extension.discovery.DiscoverySubsystemParser;

public final class DiscoveryExtension
implements Extension {
    static final String SUBSYSTEM_NAME = "discovery";
    static final String RESOURCE_NAME = DiscoveryExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final RuntimeCapability<?> DISCOVERY_PROVIDER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.discovery.provider", (boolean)true).setServiceType(DiscoveryProvider.class).setAllowMultipleRegistrations(true).build();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, DiscoveryModel.CURRENT.getVersion());
        subsystemRegistration.setHostCapable();
        subsystemRegistration.registerXMLElementWriter((XMLElementWriter)new DiscoverySubsystemParser(DiscoverySchema.CURRENT));
        ManagementResourceRegistration resourceRegistration = subsystemRegistration.registerSubsystemModel((ResourceDefinition)new DiscoverySubsystemDefinition());
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (DiscoverySchema schema : EnumSet.allOf(DiscoverySchema.class)) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new DiscoverySubsystemParser(schema));
        }
    }

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefixes) {
        StringBuilder sb = new StringBuilder(SUBSYSTEM_NAME);
        if (keyPrefixes != null) {
            for (String current : keyPrefixes) {
                sb.append(".").append(current);
            }
        }
        return new StandardResourceDescriptionResolver(sb.toString(), RESOURCE_NAME, DiscoveryExtension.class.getClassLoader(), true, false);
    }
}

