/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.access.InVmAccess;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.deployment.scanner.api.DeploymentOperations;
import org.jboss.as.server.deployment.scanner.logging.DeploymentScannerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.threads.AsyncFuture;
import org.wildfly.security.manager.WildFlySecurityManager;

final class DefaultDeploymentOperations
implements DeploymentOperations {
    private final ModelControllerClient controllerClient;

    DefaultDeploymentOperations(ModelControllerClient controllerClient) {
        this.controllerClient = controllerClient;
    }

    @Override
    public Future<ModelNode> deploy(ModelNode operation, ExecutorService executorService) {
        return this.executeAsync(operation, OperationMessageHandler.DISCARD);
    }

    @Override
    public Map<String, Boolean> getDeploymentsStatus() {
        ModelNode response;
        ModelNode op = Util.getEmptyOperation((String)"read-children-resources", (ModelNode)new ModelNode());
        op.get("child-type").set("deployment");
        try {
            response = this.execute(op);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (response.get("outcome").isDefined() && !"success".equals(response.get("outcome").asString())) {
            throw DeploymentScannerLogger.ROOT_LOGGER.deployModelOperationFailed(response.get("failure-description").asString());
        }
        ModelNode result = response.get("result");
        HashMap<String, Boolean> deployments = new HashMap<String, Boolean>();
        if (result.isDefined()) {
            for (Property property : result.asPropertyList()) {
                deployments.put(property.getName(), property.getValue().get("enabled").asBoolean(false));
            }
        }
        return deployments;
    }

    @Override
    public void close() throws IOException {
        this.controllerClient.close();
    }

    @Override
    public Set<String> getUnrelatedDeployments(ModelNode owner) {
        ModelNode response;
        ModelNode op = Util.getEmptyOperation((String)"read-children-resources", (ModelNode)new ModelNode());
        op.get("child-type").set("deployment");
        try {
            response = this.execute(op);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (response.get("outcome").isDefined() && !"success".equals(response.get("outcome").asString())) {
            throw DeploymentScannerLogger.ROOT_LOGGER.deployModelOperationFailed(response.get("failure-description").asString());
        }
        ModelNode result = response.get("result");
        HashSet<String> deployments = new HashSet<String>();
        if (result.isDefined()) {
            for (Property property : result.asPropertyList()) {
                if (owner.equals(property.getValue().get("owner"))) continue;
                deployments.add(property.getName());
            }
        }
        return deployments;
    }

    private ModelNode execute(ModelNode operation) throws Exception {
        return DefaultDeploymentOperations.controllerClient().execute(this.controllerClient, operation);
    }

    private AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return DefaultDeploymentOperations.controllerClient().executeAsync(this.controllerClient, operation, messageHandler);
    }

    private static ControllerClient controllerClient() {
        return WildFlySecurityManager.isChecking() ? ControllerClient.PRIVILEGED : ControllerClient.NON_PRIVILEGED;
    }

    private static interface ControllerClient {
        public static final ControllerClient NON_PRIVILEGED = new ControllerClient(){

            @Override
            public ModelNode execute(ModelControllerClient controllerClient, ModelNode operation) throws Exception {
                return (ModelNode)InVmAccess.runInVm(() -> controllerClient.execute(operation));
            }

            @Override
            public AsyncFuture<ModelNode> executeAsync(ModelControllerClient controllerClient, ModelNode operation, OperationMessageHandler messageHandler) {
                return (AsyncFuture)InVmAccess.runInVm(() -> controllerClient.executeAsync(operation, messageHandler));
            }
        };
        public static final ControllerClient PRIVILEGED = new ControllerClient(){

            @Override
            public ModelNode execute(ModelControllerClient controllerClient, ModelNode operation) throws Exception {
                return AccessController.doPrivileged(() -> NON_PRIVILEGED.execute(controllerClient, operation));
            }

            @Override
            public AsyncFuture<ModelNode> executeAsync(ModelControllerClient controllerClient, ModelNode operation, OperationMessageHandler messageHandler) {
                return AccessController.doPrivileged(() -> NON_PRIVILEGED.executeAsync(controllerClient, operation, messageHandler));
            }
        };

        public ModelNode execute(ModelControllerClient var1, ModelNode var2) throws Exception;

        public AsyncFuture<ModelNode> executeAsync(ModelControllerClient var1, ModelNode var2, OperationMessageHandler var3);
    }
}

