/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner.logging;

import java.io.File;
import java.util.Set;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYDS", length=4)
public interface DeploymentScannerLogger
extends BasicLogger {
    public static final DeploymentScannerLogger ROOT_LOGGER = (DeploymentScannerLogger)Logger.getMessageLogger(DeploymentScannerLogger.class, (String)"org.jboss.as.server.deployment.scanner");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Cannot delete deployment progress marker file %s")
    public void cannotDeleteDeploymentProgressMarker(File var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Cannot remove extraneous deployment marker file %s")
    public void cannotRemoveDeploymentMarker(String var1);

    @LogMessage(level=Logger.Level.WARN)
    public void cannotRemoveDeploymentMarker(File var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Deployment of '%s' requested, but the deployment is not present")
    public void deploymentNotFound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Found %1$s in deployment directory. To trigger deployment create a file called %1$s%2$s")
    public void deploymentTriggered(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Caught exception writing deployment marker file %s")
    public void errorWritingDeploymentMarker(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Reliable deployment behaviour is not possible when auto-deployment of exploded content is enabled (i.e. deployment without use of \"%s\"' marker files). Configuration of auto-deployment of exploded content is not recommended in any situation where reliability is desired. Configuring the deployment scanner's %s setting to \"false\" is recommended.")
    public void explodedAutoDeploymentContentWarning(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="The deployment scanner found that the content for exploded deployment %1$s has been deleted, but auto-deploy/undeploy for exploded deployments is not enabled and the %1$s%2$s marker file for this deployment has not been removed. As a result, the deployment is not being undeployed, but resources needed by the deployment may have been deleted and application errors may occur. Deleting the %1$s%2$s marker file to trigger undeploy is recommended.")
    public void explodedDeploymentContentDeleted(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Failed checking whether %s was a complete zip")
    public void failedCheckingZipFile(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=9, value="File system deployment service failed")
    public void fileSystemDeploymentFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10, value="Scan found incompletely copied file content for deployment %s. Deployment changes will not be processed until all content is complete.")
    public void incompleteContent(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11, value="The deployment scanner found a directory named %1$s that was not inside a directory whose name ends with .ear, .jar, .rar, .sar or .war. This is likely the result of unzipping an archive directly inside the %2$s directory, which is a user error. The %1$s directory will not be scanned for deployments, but it is possible that the scanner may find other files from the unzipped archive and attempt to deploy them, leading to errors.")
    public void invalidExplodedDeploymentDirectory(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12, value="Scan of %s threw Exception")
    public void scanException(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="Started %s for directory %s")
    public void started(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14, value="Scan found content configured for auto-deploy that could not be safely auto-deployed. See details above. Deployment changes will not be processed until all problematic content is either removed or whether to deploy the content or not is indicated via a %s or %s marker file. Problematic deployments are %s")
    public void unsafeAutoDeploy(String var1, String var2, Set<String> var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15, value="Re-attempting failed deployment %s")
    public void reattemptingFailedDeployment(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16, value="Failed checking whether %s was a complete XML")
    public void failedCheckingXMLFile(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17, value="Initial deployment scan failed")
    public void initialScanFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Deployment %s was previously deployed by this scanner but has been undeployed by another management tool. Marker file %s is being added to record this fact.")
    public void scannerDeploymentUndeployedButNotByScanner(String var1, File var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19, value="Deployment %s was previously deployed by this scanner but has been removed from the server deployment list by another management tool. Marker file %s is being added to record this fact.")
    public void scannerDeploymentRemovedButNotByScanner(String var1, File var2);

    @Message(id=20, value="Cannot remove subsystem while it still has scanners configured. Remove all scanners first.")
    public String cannotRemoveSubsystem();

    @Message(id=21, value="Deployment content %s appears to be incomplete and is not progressing toward completion. This content cannot be auto-deployed.%s")
    public String deploymentContentIncomplete(File var1, String var2);

    @Message(id=22, value="Did not receive a response to the deployment operation within the allowed timeout period [%d seconds]. Check the server configuration file and the server logs to find more about the status of the deployment.")
    public String deploymentTimeout(long var1);

    @Message(id=23, value="%s does not exist")
    public IllegalArgumentException directoryDoesNotExist(String var1);

    @Message(id=24, value="%s is not writable")
    public IllegalArgumentException directoryNotWritable(String var1);

    @Message(id=25, value="File %s cannot be scanned because it does not begin with a ZIP file format local file header signature")
    public String invalidZipFileFormat(String var1);

    @Message(id=26, value="File %s cannot be scanned because it uses the currently unsupported ZIP64 format")
    public String invalidZip64FileFormat(String var1);

    @Message(id=27, value="%s is not a directory")
    public IllegalArgumentException notADirectory(String var1);

    @Message(id=28, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=0, value=" A previous version of this content was deployed and remains deployed.")
    public String previousContentDeployed();

    @Message(id=29, value="scanner not configured")
    public String scannerNotConfigured();

    @Message(id=30, value="File %2$s was configured for auto-deploy but could not be safely auto-deployed. The reason the file could not be auto-deployed was: %1$s.  To enable deployment of this file create a file called %2$s%3$s")
    public String unsafeAutoDeploy2(String var1, String var2, String var3);

    @Message(id=31, value="Extension with module 'org.jboss.as.deployment-scanner' cannot be installed in a managed domain. Please remove it and any subsystem referencing it")
    public IllegalStateException deploymentScannerNotForDomainMode();

    @Message(id=32, value="Failed to list files in directory %s. Check that the contents of the directory are readable.")
    public RuntimeException cannotListDirectoryFiles(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=33, value="Deployment %s was previously undeployed by this scanner but has been redeployed by another management tool. Marker file %s is being removed to record this fact.")
    public void scannerDeploymentRedeployedButNotByScanner(String var1, File var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=34, value="Failed synchronizing status of deployment %s.")
    public void failedStatusSynchronization(@Cause Throwable var1, String var2);
}

