/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller._private.OperationFailedRuntimeException;
import org.jboss.as.controller.extension.ExtensionAddHandler;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public final class ParallelExtensionAddHandler
implements OperationStepHandler {
    private final ExecutorService executor;
    private final List<ParsedBootOp> extensionAdds = new ArrayList<ParsedBootOp>();
    private ParsedBootOp ourOp;
    private final MutableRootResourceRegistrationProvider rootResourceRegistrationProvider;
    private final int maxParallelBootTasks;

    public ParallelExtensionAddHandler(ExecutorService executorService, int maxParallelBootTasks, MutableRootResourceRegistrationProvider rootResourceRegistrationProvider) {
        assert (maxParallelBootTasks > 1);
        this.executor = executorService;
        this.maxParallelBootTasks = maxParallelBootTasks;
        this.rootResourceRegistrationProvider = rootResourceRegistrationProvider;
    }

    public void addParsedOp(ParsedBootOp op, ExtensionAddHandler handler) {
        ParsedBootOp toAdd = new ParsedBootOp(op, (OperationStepHandler)handler);
        this.extensionAdds.add(toAdd);
        this.getParsedBootOp().addChildOperation(toAdd);
    }

    public ParsedBootOp getParsedBootOp() {
        if (this.ourOp == null) {
            ModelNode op = Util.getEmptyOperation("parallel-extension-add", new ModelNode().setEmptyList());
            this.ourOp = new ParsedBootOp(op, (OperationStepHandler)this);
        }
        return this.ourOp;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(this.getParallelExtensionInitializeStep(), OperationContext.Stage.MODEL, true);
        for (int i = this.extensionAdds.size() - 1; i >= 0; --i) {
            ParsedBootOp op = this.extensionAdds.get(i);
            context.addStep(op.response, op.operation, op.handler, OperationContext.Stage.MODEL, true);
        }
    }

    private OperationStepHandler getParallelExtensionInitializeStep() {
        return new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                long start = System.currentTimeMillis();
                GroupInitializeTask[] initializeTasks = new GroupInitializeTask[ParallelExtensionAddHandler.this.maxParallelBootTasks];
                ManagementResourceRegistration rootResourceRegistration = ParallelExtensionAddHandler.this.rootResourceRegistrationProvider.getRootResourceRegistrationForUpdate(context);
                int taskIdx = -1;
                for (ParsedBootOp op : ParallelExtensionAddHandler.this.extensionAdds) {
                    taskIdx = taskIdx == ParallelExtensionAddHandler.this.maxParallelBootTasks - 1 ? 0 : ++taskIdx;
                    String module = op.address.getLastElement().getValue();
                    ExtensionAddHandler addHandler = (ExtensionAddHandler)ExtensionAddHandler.class.cast(op.handler);
                    ExtensionInitializeTask initializeTask = new ExtensionInitializeTask(module, addHandler, rootResourceRegistration);
                    if (initializeTasks[taskIdx] == null) {
                        initializeTasks[taskIdx] = new GroupInitializeTask(initializeTask);
                        continue;
                    }
                    initializeTasks[taskIdx].loadTasks.add(initializeTask);
                }
                for (GroupInitializeTask initTask : initializeTasks) {
                    if (initTask == null) continue;
                    initTask.execute(ParallelExtensionAddHandler.this.executor);
                }
                for (GroupInitializeTask initTask : initializeTasks) {
                    if (initTask == null) continue;
                    try {
                        OperationFailedRuntimeException ofe = (OperationFailedRuntimeException)initTask.future.get();
                        if (ofe == null) continue;
                        throw ofe;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw ControllerLogger.ROOT_LOGGER.moduleInitializationInterrupted(initTask.currentModule);
                    }
                    catch (ExecutionException e) {
                        throw ControllerLogger.ROOT_LOGGER.failedInitializingModule(e, initTask.currentModule);
                    }
                }
                if (ControllerLogger.MGMT_OP_LOGGER.isDebugEnabled()) {
                    long elapsed = System.currentTimeMillis() - start;
                    ControllerLogger.MGMT_OP_LOGGER.debugf("Initialized extensions in [%d] ms", elapsed);
                }
            }
        };
    }

    private static class GroupInitializeTask
    implements Callable<OperationFailedRuntimeException> {
        private final List<ExtensionInitializeTask> loadTasks = new ArrayList<ExtensionInitializeTask>();
        private volatile String currentModule;
        private volatile Future<OperationFailedRuntimeException> future;

        private GroupInitializeTask(ExtensionInitializeTask first) {
            this.currentModule = first.module;
            this.loadTasks.add(first);
        }

        @Override
        public OperationFailedRuntimeException call() throws Exception {
            for (ExtensionInitializeTask task : this.loadTasks) {
                this.currentModule = task.module;
                OperationFailedRuntimeException ex = task.call();
                if (ex == null) continue;
                return ex;
            }
            return null;
        }

        private void execute(ExecutorService executorService) {
            this.future = executorService.submit(this);
        }
    }

    private static class ExtensionInitializeTask
    implements Callable<OperationFailedRuntimeException> {
        private final String module;
        private final ExtensionAddHandler addHandler;
        private final ManagementResourceRegistration rootResourceRegistration;

        ExtensionInitializeTask(String module, ExtensionAddHandler addHandler, ManagementResourceRegistration rootResourceRegistration) {
            this.module = module;
            this.addHandler = addHandler;
            this.rootResourceRegistration = rootResourceRegistration;
        }

        @Override
        public OperationFailedRuntimeException call() {
            OperationFailedRuntimeException failure = null;
            try {
                this.addHandler.initializeExtension(this.module, this.rootResourceRegistration);
            }
            catch (OperationFailedRuntimeException e) {
                failure = e;
            }
            return failure;
        }
    }
}

