/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLMapper;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DeferredExtensionContext {
    private final ModuleLoader moduleLoader;
    private final ExtensionRegistry extensionRegistry;
    private final ExecutorService bootExecutor;
    private final List<ExtensionData> extensions = new ArrayList<ExtensionData>();
    private boolean loaded;

    public DeferredExtensionContext(ModuleLoader moduleLoader, ExtensionRegistry extensionRegistry, ExecutorService bootExecutor) {
        this.moduleLoader = moduleLoader;
        this.extensionRegistry = extensionRegistry;
        this.bootExecutor = bootExecutor;
    }

    public void load() throws XMLStreamException {
        if (!this.loaded) {
            this.loaded = true;
            LinkedHashMap<String, Future<XMLStreamException>> loadFutures = this.bootExecutor != null ? new LinkedHashMap<String, Future<XMLStreamException>>() : null;
            for (ExtensionData extensionData : this.extensions) {
                final String moduleName = extensionData.moduleName;
                final XMLMapper xmlMapper = extensionData.xmlMapper;
                if (loadFutures != null) {
                    Callable<XMLStreamException> callable = new Callable<XMLStreamException>(){

                        @Override
                        public XMLStreamException call() throws Exception {
                            return DeferredExtensionContext.this.loadModule(moduleName, xmlMapper);
                        }
                    };
                    Future<XMLStreamException> future = this.bootExecutor.submit(callable);
                    loadFutures.put(moduleName, future);
                    continue;
                }
                XMLStreamException xse = this.loadModule(moduleName, xmlMapper);
                if (xse == null) continue;
                throw xse;
            }
            if (loadFutures != null) {
                for (Map.Entry entry : loadFutures.entrySet()) {
                    try {
                        XMLStreamException xse = (XMLStreamException)((Future)entry.getValue()).get();
                        if (xse == null) continue;
                        throw xse;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw ControllerLogger.ROOT_LOGGER.moduleLoadingInterrupted((String)entry.getKey());
                    }
                    catch (ExecutionException e) {
                        throw ControllerLogger.ROOT_LOGGER.failedToLoadModule(e, (String)entry.getKey());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLStreamException loadModule(String moduleName, XMLMapper xmlMapper) throws XMLStreamException {
        try {
            Module module = this.moduleLoader.loadModule(ModuleIdentifier.fromString((String)moduleName));
            boolean initialized = false;
            for (Extension extension : module.loadService(Extension.class)) {
                ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(extension.getClass());
                try {
                    extension.initializeParsers(this.extensionRegistry.getExtensionParsingContext(moduleName, xmlMapper));
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                }
                if (initialized) continue;
                initialized = true;
            }
            if (!initialized) {
                throw ControllerLogger.ROOT_LOGGER.notFound("META-INF/services/", Extension.class.getName(), module.getIdentifier());
            }
            return null;
        }
        catch (ModuleLoadException e) {
            throw ControllerLogger.ROOT_LOGGER.failedToLoadModule(e);
        }
    }

    public void addExtension(String moduleName, XMLMapper xmlMapper) {
        this.extensions.add(new ExtensionData(moduleName, xmlMapper));
    }

    private class ExtensionData {
        final String moduleName;
        final XMLMapper xmlMapper;

        private ExtensionData(String moduleName, XMLMapper xmlMapper) {
            this.moduleName = moduleName;
            this.xmlMapper = xmlMapper;
        }
    }
}

