/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.xml.XMLAttributeReader;
import org.jboss.as.controller.xml.XMLComponent;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLUsage;
import org.jboss.as.version.Stability;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.common.Assert;
import org.wildfly.common.function.Functions;

public interface XMLAttribute<RC, WC>
extends XMLComponent<RC, WC> {
    public QName getName();

    @Override
    public XMLAttributeReader<RC> getReader();

    public XMLUsage getUsage();

    public static class DefaultXMLAttribute<RC, WC>
    implements XMLAttribute<RC, WC> {
        private final QName name;
        private final XMLUsage usage;
        private final XMLAttributeReader<RC> reader;
        private final XMLContentWriter<WC> writer;
        private final Stability stability;

        DefaultXMLAttribute(QName name, XMLUsage usage, XMLAttributeReader<RC> reader, XMLContentWriter<WC> writer, Stability stability) {
            this.name = name;
            this.usage = usage;
            this.reader = reader;
            this.writer = writer;
            this.stability = stability;
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public XMLAttributeReader<RC> getReader() {
            return this.reader;
        }

        @Override
        public XMLContentWriter<WC> getWriter() {
            return this.writer;
        }

        @Override
        public XMLUsage getUsage() {
            return this.usage;
        }

        @Override
        public Stability getStability() {
            return this.stability;
        }
    }

    public static class DefaultBuilder<RC, WC>
    implements Builder<RC, WC> {
        private final QName name;
        private final Stability stability;
        private volatile BiConsumer<RC, String> consumer = Functions.discardingBiConsumer();
        private volatile Function<WC, String> formatter = Object::toString;
        private volatile XMLUsage usage = Use.OPTIONAL;
        private volatile String defaultValue = null;
        private volatile boolean fixed = false;

        DefaultBuilder(QName name, Stability stability) {
            this.name = name;
            this.stability = stability;
        }

        @Override
        public Builder<RC, WC> withConsumer(BiConsumer<RC, String> consumer) {
            this.consumer = consumer;
            return this;
        }

        @Override
        public Builder<RC, WC> withFormatter(Function<WC, String> formatter) {
            this.formatter = formatter;
            return this;
        }

        @Override
        public Builder<RC, WC> withUsage(XMLUsage usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public Builder<RC, WC> withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.fixed = false;
            return this;
        }

        @Override
        public Builder<RC, WC> withFixedValue(String fixedValue) {
            Assert.assertNotNull((Object)fixedValue);
            this.withDefaultValue(fixedValue);
            this.fixed = true;
            return this;
        }

        @Override
        public XMLAttribute<RC, WC> build() {
            final QName name = this.name;
            final XMLUsage usage = this.usage;
            final BiConsumer<RC, String> consumer = this.consumer;
            final Function<WC, String> formatter = this.formatter;
            final String defaultValue = this.defaultValue;
            final boolean fixed = this.fixed;
            XMLAttributeReader reader = new XMLAttributeReader<RC>(){

                public void readAttribute(XMLStreamReader reader, int index, RC context) throws XMLStreamException {
                    String value = reader.getAttributeValue(index);
                    if (fixed && !value.equals(defaultValue)) {
                        throw ControllerLogger.ROOT_LOGGER.invalidAttributeValue(value, reader.getAttributeName(index), reader.getLocation());
                    }
                    consumer.accept(context, reader.getAttributeValue(index));
                }

                @Override
                public void whenAbsent(RC context) {
                    if (defaultValue != null) {
                        consumer.accept(context, defaultValue);
                    }
                }
            };
            XMLContentWriter writer = new XMLContentWriter<WC>(){

                public void writeContent(XMLExtendedStreamWriter writer, WC content) throws XMLStreamException {
                    String value = (String)formatter.apply(content);
                    if (value != null && (usage.isRequired() || !value.equals(defaultValue))) {
                        writer.writeAttribute(name.getLocalPart(), value);
                    }
                }

                @Override
                public boolean isEmpty(WC content) {
                    return formatter.apply(content) == null;
                }
            };
            return new DefaultXMLAttribute(this.name, this.usage, reader, writer, this.stability);
        }
    }

    public static interface Builder<RC, WC> {
        public Builder<RC, WC> withUsage(XMLUsage var1);

        public Builder<RC, WC> withDefaultValue(String var1);

        public Builder<RC, WC> withFixedValue(String var1);

        public Builder<RC, WC> withConsumer(BiConsumer<RC, String> var1);

        public Builder<RC, WC> withFormatter(Function<WC, String> var1);

        public XMLAttribute<RC, WC> build();
    }

    public static enum Use implements XMLUsage
    {
        OPTIONAL(false, true),
        PROHIBITED(false, false),
        REQUIRED(true, true);

        private final boolean required;
        private final boolean enabled;

        private Use(boolean required, boolean enabled) {
            this.required = required;
            this.enabled = enabled;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

