/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

public final class MultistepUtil {
    private MultistepUtil() {
    }

    public static void recordOperationSteps(OperationContext context, List<ModelNode> operations, List<ModelNode> responses) throws OperationFailedException {
        assert (responses.isEmpty() || operations.size() == responses.size());
        boolean responsesProvided = !responses.isEmpty();
        LinkedHashMap<Integer, ModelNode> operationMap = new LinkedHashMap<Integer, ModelNode>();
        LinkedHashMap<Integer, ModelNode> responseMap = new LinkedHashMap<Integer, ModelNode>();
        int i = 0;
        for (ModelNode op : operations) {
            operationMap.put(i, op);
            if (responsesProvided) {
                ModelNode response = responses.get(i);
                assert (response != null) : "No response provided for " + i;
                responseMap.put(i, response);
            }
            ++i;
        }
        MultistepUtil.recordOperationSteps(context, operationMap, responseMap, OperationHandlerResolver.DEFAULT, false);
        if (!responsesProvided) {
            for (ModelNode response : responseMap.values()) {
                responses.add(response);
            }
        }
    }

    public static <T> void recordOperationSteps(OperationContext context, Map<T, ModelNode> operations, Map<T, ModelNode> responses) throws OperationFailedException {
        MultistepUtil.recordOperationSteps(context, operations, responses, OperationHandlerResolver.DEFAULT, false);
    }

    public static <T> void recordOperationSteps(OperationContext context, Map<T, ModelNode> operations, Map<T, ModelNode> responses, OperationHandlerResolver handlerResolver, boolean adjustAddresses) throws OperationFailedException {
        assert (responses != null);
        assert (responses.isEmpty() || operations.size() == responses.size());
        boolean responsesProvided = !responses.isEmpty();
        PathAddress currentAddress = adjustAddresses ? context.getCurrentAddress() : null;
        ArrayList<OpData> opdatas = new ArrayList<OpData>();
        for (Map.Entry<T, ModelNode> entry : operations.entrySet()) {
            ModelNode response;
            ModelNode modelNode = response = responsesProvided ? responses.get(entry.getKey()) : new ModelNode();
            assert (response != null) : "No response provided for " + entry.getValue();
            ModelNode op = entry.getValue();
            PathAddress stepAddress = PathAddress.pathAddress(op.get("address"));
            if (adjustAddresses) {
                stepAddress = currentAddress.append(stepAddress);
                op.get("address").set(stepAddress.toModelNode());
            }
            OpData opData = MultistepUtil.getOpData(context, op, response, stepAddress, handlerResolver);
            opdatas.add(0, opData);
            if (responsesProvided) continue;
            responses.put(entry.getKey(), response);
        }
        for (OpData opData : opdatas) {
            context.addModelStep(opData.response, opData.operation, opData.definition, opData.handler, true);
        }
    }

    private static OpData getOpData(OperationContext context, ModelNode subOperation, ModelNode response, PathAddress stepAddress, OperationHandlerResolver handlerResolver) throws OperationFailedException {
        String stepOpName;
        ImmutableManagementResourceRegistration registry = context.getRootResourceRegistration();
        OperationEntry operationEntry = registry.getOperationEntry(stepAddress, stepOpName = subOperation.require("operation").asString());
        if (operationEntry == null) {
            ImmutableManagementResourceRegistration child = registry.getSubModel(stepAddress);
            if (child == null) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(stepAddress));
            }
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(stepOpName, stepAddress));
        }
        OperationStepHandler osh = handlerResolver.getOperationStepHandler(stepOpName, stepAddress, subOperation, operationEntry);
        return new OpData(subOperation, operationEntry.getOperationDefinition(), osh, response);
    }

    public static interface OperationHandlerResolver {
        public static final OperationHandlerResolver DEFAULT = new OperationHandlerResolver(){};

        default public OperationStepHandler getOperationStepHandler(String operationName, PathAddress address, ModelNode operation, OperationEntry operationEntry) {
            return operationEntry.getOperationHandler();
        }
    }

    private static class OpData {
        private final ModelNode operation;
        private final OperationDefinition definition;
        private final OperationStepHandler handler;
        private final ModelNode response;

        private OpData(ModelNode operation, OperationDefinition definition, OperationStepHandler handler, ModelNode response) {
            this.definition = definition;
            this.operation = operation;
            this.handler = handler;
            this.response = response;
        }
    }
}

