/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;

public final class OperationEntry {
    private final OperationDefinition operationDefinition;
    private final OperationStepHandler operationHandler;
    private final boolean inherited;

    OperationEntry(OperationDefinition definition, OperationStepHandler operationHandler, boolean inherited) {
        this.operationDefinition = definition;
        this.operationHandler = operationHandler;
        this.inherited = inherited;
    }

    public OperationDefinition getOperationDefinition() {
        return this.operationDefinition;
    }

    public OperationStepHandler getOperationHandler() {
        return this.operationHandler;
    }

    public DescriptionProvider getDescriptionProvider() {
        return this.operationDefinition.getDescriptionProvider();
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public EntryType getType() {
        return this.operationDefinition.getEntryType();
    }

    public Set<Flag> getFlags() {
        return this.operationDefinition.getFlags();
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        List<AccessConstraintDefinition> accessConstraints = this.operationDefinition.getAccessConstraints();
        return accessConstraints == null ? Collections.emptyList() : accessConstraints;
    }

    public static enum Flag {
        READ_ONLY,
        RESTART_NONE,
        RESTART_JVM,
        RESTART_ALL_SERVICES,
        RESTART_RESOURCE_SERVICES,
        DOMAIN_PUSH_TO_SERVERS,
        HOST_CONTROLLER_ONLY,
        MASTER_HOST_CONTROLLER_ONLY,
        RUNTIME_ONLY,
        HIDDEN;

        private static final EnumSet<Flag> NONE;
        private static final Map<EnumSet<Flag>, Set<Flag>> flagSets;

        public static Set<Flag> immutableSetOf(EnumSet<Flag> flags) {
            EnumSet<Flag> baseSet = flags == null ? NONE : flags;
            Set<Flag> result = flagSets.get(baseSet);
            if (result == null) {
                Set<Flag> immutable = Collections.unmodifiableSet(baseSet);
                Set<Flag> existing = flagSets.putIfAbsent(baseSet, immutable);
                result = existing == null ? immutable : existing;
            }
            return result;
        }

        static {
            NONE = EnumSet.noneOf(Flag.class);
            flagSets = new ConcurrentHashMap<EnumSet<Flag>, Set<Flag>>(16);
        }
    }

    public static enum EntryType {
        PUBLIC,
        PRIVATE;

    }
}

