/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ObjectMapAttributeDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public interface AttributeMarshallers {
    public static AttributeMarshaller getObjectMapAttributeMarshaller(String keyElementName) {
        return new ObjectMapAttributeMarshaller(null, null, true, keyElementName);
    }

    public static AttributeMarshaller getObjectMapAttributeMarshaller(String elementName, String keyElementName, boolean wrapElement) {
        return new ObjectMapAttributeMarshaller(null, elementName, wrapElement, keyElementName);
    }

    public static AttributeMarshaller getObjectMapAttributeMarshaller(String elementName, boolean wrapElement) {
        return new ObjectMapAttributeMarshaller(null, elementName, wrapElement, null);
    }

    public static AttributeMarshaller getObjectMapAttributeMarshaller(String wrapperElementName, boolean wrapElement, String elementName, String keyElementName) {
        return new ObjectMapAttributeMarshaller(wrapperElementName, elementName, wrapElement, keyElementName);
    }

    public static class ObjectMapAttributeMarshaller
    extends MapAttributeMarshaller {
        protected final String keyAttributeName;

        public ObjectMapAttributeMarshaller(String wrapperElement, String elementName, boolean wrapElement, String keyAttributeName) {
            super(wrapperElement, elementName, wrapElement);
            this.keyAttributeName = keyAttributeName == null ? "key" : keyAttributeName;
        }

        public ObjectMapAttributeMarshaller(String wrapperElement, String elementName, boolean wrapElement) {
            this(wrapperElement, elementName, wrapElement, null);
        }

        public ObjectMapAttributeMarshaller(String wrapperElement, boolean wrapElement) {
            this(wrapperElement, null, wrapElement);
        }

        public ObjectMapAttributeMarshaller(String keyAttributeName) {
            this(null, null, true, keyAttributeName);
        }

        public ObjectMapAttributeMarshaller() {
            this(null, null, true);
        }

        @Override
        public void marshallSingleElement(AttributeDefinition attribute, ModelNode property, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            ObjectMapAttributeDefinition map = (ObjectMapAttributeDefinition)attribute;
            AttributeDefinition[] valueTypes = map.getValueType().getValueTypes();
            writer.writeEmptyElement(this.elementName);
            Property p = property.asProperty();
            writer.writeAttribute(this.keyAttributeName, p.getName());
            for (AttributeDefinition valueType : valueTypes) {
                valueType.getAttributeMarshaller().marshall(valueType, p.getValue(), false, writer);
            }
        }
    }

    public static class PropertiesAttributeMarshaller
    extends MapAttributeMarshaller {
        public PropertiesAttributeMarshaller(String wrapperElement, String elementName, boolean wrapElement) {
            super(wrapperElement, elementName, wrapElement);
        }

        public PropertiesAttributeMarshaller(String wrapperElement, boolean wrapElement) {
            this(wrapperElement, null, wrapElement);
        }

        public PropertiesAttributeMarshaller() {
            this(null, null, true);
        }

        @Override
        public void marshallSingleElement(AttributeDefinition attribute, ModelNode property, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            writer.writeEmptyElement(this.elementName);
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.asProperty().getName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), property.asProperty().getValue().asString());
        }
    }

    public static abstract class MapAttributeMarshaller
    extends AttributeMarshaller {
        protected final String wrapperElement;
        protected final String elementName;
        protected final boolean wrapElement;

        public MapAttributeMarshaller(String wrapperElement, String elementName, boolean wrapElement) {
            this.wrapperElement = wrapperElement;
            this.elementName = elementName == null ? "property" : elementName;
            this.wrapElement = wrapElement;
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (!(resourceModel = resourceModel.get(attribute.getName())).isDefined()) {
                return;
            }
            String wrapper = this.wrapperElement == null ? attribute.getName() : this.wrapperElement;
            List elementList = resourceModel.asList();
            if (elementList.isEmpty()) {
                if (this.wrapElement) {
                    writer.writeEmptyElement(wrapper);
                } else {
                    ControllerLogger.MGMT_OP_LOGGER.debugf("%s found ambigous empty value for unwrapped property %s", this.getClass().getSimpleName(), attribute.getName());
                }
                return;
            }
            if (this.wrapElement) {
                writer.writeStartElement(wrapper);
            }
            for (ModelNode property : elementList) {
                this.marshallSingleElement(attribute, property, marshallDefault, writer);
            }
            if (this.wrapElement) {
                writer.writeEndElement();
            }
        }

        @Override
        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            this.marshallAsElement(attribute, resourceModel, marshallDefault, writer);
        }

        @Override
        public boolean isMarshallableAsElement() {
            return true;
        }

        public abstract void marshallSingleElement(AttributeDefinition var1, ModelNode var2, boolean var3, XMLStreamWriter var4) throws XMLStreamException;
    }
}

