/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.security;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Destroyable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.security.CredentialStoreClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.value.InjectedValue;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public final class CredentialReference
implements Destroyable {
    public static final String CREDENTIAL_REFERENCE = "credential-reference";
    public static final String STORE = "store";
    public static final String ALIAS = "alias";
    public static final String TYPE = "type";
    public static final String CLEAR_TEXT = "clear-text";
    static final SimpleAttributeDefinition credentialStoreAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("store", ModelType.STRING, true).setXmlName("store")).build();
    static final SimpleAttributeDefinition credentialAliasAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias", ModelType.STRING, true).setXmlName("alias")).build();
    static final SimpleAttributeDefinition credentialTypeAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setXmlName("type")).build();
    static final SimpleAttributeDefinition clearTextAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("clear-text", ModelType.STRING, true).setXmlName("clear-text")).build();
    static final ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition = CredentialReference.getAttributeBuilder("credential-reference", "credential-reference", false).build();
    private final String credentialStoreName;
    private final String alias;
    private final String credentialType;
    private volatile char[] secret;

    private CredentialReference(String credentialStoreName, String alias, String credentialType, char[] secret) {
        this.credentialStoreName = credentialStoreName;
        this.alias = alias;
        this.credentialType = credentialType;
        this.secret = (char[])(secret != null ? (char[])secret.clone() : null);
    }

    public String getCredentialStoreName() {
        return this.credentialStoreName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public char[] getSecret() {
        return this.secret;
    }

    @Override
    public void destroy() {
        if (this.secret != null) {
            for (int i = 0; i < this.secret.length; ++i) {
                this.secret[i] = '\u0000';
            }
            this.secret = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.secret == null;
    }

    public static CredentialReference createCredentialReference(char[] secret) {
        return new CredentialReference(CredentialReference.class.getName(), null, null, secret);
    }

    public static CredentialReference createCredentialReference(String credentialStoreName, String alias, String credentialType) {
        return new CredentialReference(credentialStoreName, alias, credentialType, null);
    }

    public static ObjectTypeAttributeDefinition getAttributeDefinition() {
        return credentialReferenceAttributeDefinition;
    }

    public static ObjectTypeAttributeDefinition.Builder getAttributeBuilder(String name, String xmlName, boolean allowNull) {
        return ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder(name, credentialStoreAttribute, credentialAliasAttribute, credentialTypeAttribute, clearTextAttribute).setXmlName(xmlName)).setAttributeMarshaller(CredentialReference.credentialReferenceAttributeMarshaller())).setAttributeParser(CredentialReference.credentialReferenceAttributeParser())).setAllowNull(allowNull);
    }

    public static String credentialReferencePartAsStringIfDefined(OperationContext context, ObjectTypeAttributeDefinition attributeDefinition, ModelNode model, String name) throws OperationFailedException {
        ModelNode value = attributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            ModelNode namedNode = value.get(name);
            if (namedNode != null && namedNode.isDefined()) {
                return namedNode.asString();
            }
            return null;
        }
        return null;
    }

    public static void reinjectCredentialStoreClient(InjectedValue<CredentialStoreClient> injectedCredentialStoreClient, CredentialReference credentialReference) throws ClassNotFoundException {
        CredentialStoreClient updatedCredentialStoreClient;
        CredentialStoreClient originalCredentialStoreClient = (CredentialStoreClient)injectedCredentialStoreClient.getOptionalValue();
        if (originalCredentialStoreClient != null) {
            updatedCredentialStoreClient = credentialReference.getCredentialType() != null ? new CredentialStoreClient(originalCredentialStoreClient.getCredentialStore(), credentialReference.getCredentialStoreName(), credentialReference.getAlias(), credentialReference.getCredentialType()) : new CredentialStoreClient(originalCredentialStoreClient.getCredentialStore(), credentialReference.getCredentialStoreName(), credentialReference.getAlias());
        } else {
            ClearTextCredentialStore credentialStore = new ClearTextCredentialStore(credentialReference);
            updatedCredentialStoreClient = new CredentialStoreClient(credentialStore, CredentialReference.class.getName(), "");
        }
        injectedCredentialStoreClient.setValue(() -> updatedCredentialStoreClient);
    }

    private static AttributeMarshaller credentialReferenceAttributeMarshaller() {
        return new AttributeMarshaller(){

            @Override
            public void marshallAsElement(AttributeDefinition attribute, ModelNode credentialReferenceModelNode, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
                writer.writeStartElement(attribute.getXmlName());
                if (credentialReferenceModelNode.hasDefined(clearTextAttribute.getName())) {
                    clearTextAttribute.marshallAsAttribute(credentialReferenceModelNode, writer);
                } else {
                    credentialStoreAttribute.marshallAsAttribute(credentialReferenceModelNode, writer);
                    credentialAliasAttribute.marshallAsAttribute(credentialReferenceModelNode, writer);
                    credentialTypeAttribute.marshallAsAttribute(credentialReferenceModelNode, writer);
                }
                writer.writeEndElement();
            }

            @Override
            public boolean isMarshallableAsElement() {
                return true;
            }
        };
    }

    private static AttributeParser credentialReferenceAttributeParser() {
        return new AttributeParser(){

            @Override
            public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
                AttributeParser.OBJECT_PARSER.parseElement(attribute, reader, operation);
            }

            @Override
            public boolean isParseAsElement() {
                return true;
            }
        };
    }

    private static class ClearTextCredentialStore
    extends CredentialStore {
        private static String TYPE = "ClearTextCredentialStore";
        private CredentialReference credentialReference;

        ClearTextCredentialStore(CredentialReference credentialReference) {
            super(null, null, TYPE);
            this.credentialReference = credentialReference;
        }

        public boolean isInitialized() {
            return true;
        }

        public boolean isModifiable() {
            return false;
        }

        public <C extends Credential> boolean exists(String credentialAlias, Class<C> credentialType) {
            return false;
        }

        public <C extends Credential> void store(String credentialAlias, C credential) {
            throw new RuntimeException("method not implemented");
        }

        public <C extends Credential> C retrieve(String credentialAlias, Class<C> credentialType) throws CredentialStoreException, UnsupportedCredentialTypeException {
            try {
                PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
                return (C)((Credential)credentialType.cast(new PasswordCredential(passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(this.credentialReference.getSecret())))));
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new CredentialStoreException((Throwable)e);
            }
        }

        public void remove(String credentialAlias, Class<? extends Credential> credentialType) {
            throw new RuntimeException("method not implemented");
        }

        public Set<String> getAliases() {
            return Collections.emptySet();
        }
    }
}

