/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.impl.AbstractDelegatingAsyncFuture;
import org.jboss.as.controller.client.impl.OperationResponseProxy;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.remote.SecurityActions;
import org.jboss.as.controller.remote.SubjectProtocolUtil;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;
import org.wildfly.security.manager.WildFlySecurityManager;

class TransactionalProtocolClientImpl
implements ManagementRequestHandlerFactory,
TransactionalProtocolClient {
    private static final File javaTempDir = new File(WildFlySecurityManager.getPropertyPrivileged((String)"java.io.tmpdir", null));
    private final File tempDir;
    private final ManagementChannelAssociation channelAssociation;

    public TransactionalProtocolClientImpl(ManagementChannelAssociation channelAssociation) {
        assert (channelAssociation != null);
        this.channelAssociation = channelAssociation;
        File temp = (File)channelAssociation.getAttachments().getAttachment(ManagementChannelHandler.TEMP_DIR);
        this.tempDir = temp != null && temp.isDirectory() ? temp : javaTempDir;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationType = header.getOperationId();
        if (operationType == 72) {
            return new HandleReportRequestHandler();
        }
        if (operationType == 76) {
            return ReadAttachmentInputStreamRequestHandler.INSTANCE;
        }
        return handlers.resolveNext();
    }

    @Override
    public AsyncFuture<OperationResponse> execute(TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> listener, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) throws IOException {
        TransactionalProtocolClient.Operation wrapper = TransactionalProtocolHandlers.wrap(operation, messageHandler, attachments);
        return this.execute(listener, wrapper);
    }

    @Override
    public <T extends TransactionalProtocolClient.Operation> AsyncFuture<OperationResponse> execute(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) throws IOException {
        Subject subject = SecurityActions.getSubject();
        ExecuteRequestContext context = new ExecuteRequestContext(new OperationWrapper<T>(listener, operation), subject, this.tempDir);
        final ActiveOperation op = this.channelAssociation.initializeOperation((Object)context, (ActiveOperation.CompletedCallback)context);
        final AtomicBoolean cancelSent = new AtomicBoolean();
        AbstractDelegatingAsyncFuture<OperationResponse> result = new AbstractDelegatingAsyncFuture<OperationResponse>(op.getResult()){

            public synchronized void asyncCancel(boolean interruptionDesired) {
                if (!cancelSent.get()) {
                    try {
                        TransactionalProtocolClientImpl.this.channelAssociation.executeRequest(op, (ManagementRequest)new CompleteTxRequest(113, TransactionalProtocolClientImpl.this.channelAssociation));
                        cancelSent.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        context.initialize((AsyncFuture<OperationResponse>)result);
        this.channelAssociation.executeRequest(op, (ManagementRequest)new ExecuteRequest());
        return result;
    }

    private static OperationResponse createOperationResponse(ModelNode simpleResponse, ManagementChannelAssociation channelAssociation, int operationId) {
        ModelNode streamHeader;
        ModelNode modelNode = streamHeader = simpleResponse.hasDefined("response-headers") && simpleResponse.get("response-headers").hasDefined("attached-streams") ? simpleResponse.get(new String[]{"response-headers", "attached-streams"}) : null;
        if (streamHeader != null && streamHeader.asInt() > 0) {
            return OperationResponseProxy.create((ModelNode)simpleResponse, (ManagementChannelAssociation)channelAssociation, (int)operationId, streamHeader);
        }
        return OperationResponse.Factory.createSimple((ModelNode)simpleResponse);
    }

    static ModelNode getFailureResponse(String outcome, String message) {
        ModelNode response = new ModelNode();
        response.get("outcome").set(outcome);
        if (message != null) {
            response.get("failure-description").set(message);
        }
        return response;
    }

    static ModelNode getResponse(String outcome) {
        return TransactionalProtocolClientImpl.getFailureResponse(outcome, null);
    }

    static void writeSubject(FlushableDataOutput output, Subject subject) throws IOException {
        SubjectProtocolUtil.write((DataOutput)output, subject);
    }

    static class PreparedOperationImpl<T extends TransactionalProtocolClient.Operation>
    implements TransactionalProtocolClient.PreparedOperation<T> {
        private final T operation;
        private final ModelNode preparedResult;
        private final AsyncFuture<OperationResponse> finalResult;
        private final ModelController.OperationTransaction transaction;

        protected PreparedOperationImpl(T operation, ModelNode preparedResult, AsyncFuture<OperationResponse> finalResult, ModelController.OperationTransaction transaction) {
            assert (finalResult != null) : "null result";
            this.operation = operation;
            this.preparedResult = preparedResult;
            this.finalResult = finalResult;
            this.transaction = transaction;
        }

        @Override
        public T getOperation() {
            return this.operation;
        }

        @Override
        public ModelNode getPreparedResult() {
            return this.preparedResult;
        }

        @Override
        public boolean isFailed() {
            return false;
        }

        @Override
        public boolean isTimedOut() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.finalResult.isDone();
        }

        @Override
        public AsyncFuture<OperationResponse> getFinalResult() {
            return this.finalResult;
        }

        @Override
        public void commit() {
            this.transaction.commit();
        }

        @Override
        public void rollback() {
            this.transaction.rollback();
        }
    }

    private static class OperationWrapper<T extends TransactionalProtocolClient.Operation> {
        private final T operation;
        private final TransactionalProtocolClient.TransactionalOperationListener<T> listener;
        private AsyncFuture<OperationResponse> future;

        OperationWrapper(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) {
            this.listener = listener;
            this.operation = operation;
        }

        OperationMessageHandler getMessageHandler() {
            return this.operation.getMessageHandler();
        }

        ModelNode getOperation() {
            return this.operation.getOperation();
        }

        OperationAttachments getAttachments() {
            return this.operation.getAttachments();
        }

        void prepared(ModelController.OperationTransaction transaction, ModelNode result) {
            PreparedOperationImpl<T> preparedOperation = new PreparedOperationImpl<T>(this.operation, result, this.future, transaction);
            this.listener.operationPrepared(preparedOperation);
        }

        void completed(OperationResponse response) {
            this.listener.operationComplete(this.operation, response);
        }

        void failed(ModelNode response) {
            this.listener.operationFailed(this.operation, response);
        }
    }

    static class ExecuteRequestContext
    implements ActiveOperation.CompletedCallback<OperationResponse> {
        final OperationWrapper<?> wrapper;
        final AtomicBoolean completed = new AtomicBoolean(false);
        final Subject subject;
        final File tempDir;

        ExecuteRequestContext(OperationWrapper<?> operationWrapper, Subject subject, File tempDir) {
            this.wrapper = operationWrapper;
            this.subject = subject;
            this.tempDir = tempDir;
        }

        void initialize(AsyncFuture<OperationResponse> result) {
            ((OperationWrapper)this.wrapper).future = result;
        }

        OperationMessageHandler getMessageHandler() {
            return this.wrapper.getMessageHandler();
        }

        ModelNode getOperation() {
            return this.wrapper.getOperation();
        }

        OperationAttachments getAttachments() {
            return this.wrapper.getAttachments();
        }

        List<InputStream> getInputStreams() {
            OperationAttachments attachments = this.getAttachments();
            if (attachments == null) {
                return Collections.emptyList();
            }
            return attachments.getInputStreams();
        }

        Subject getSerializableSubject() {
            if (this.subject != null) {
                Subject toSend = new Subject();
                Set<Principal> principals = toSend.getPrincipals();
                for (Principal current : this.subject.getPrincipals()) {
                    if (!(current instanceof Serializable)) continue;
                    principals.add(current);
                }
                toSend.setReadOnly();
                return toSend;
            }
            return null;
        }

        public synchronized void completed(OperationResponse result) {
            if (this.completed.compareAndSet(false, true)) {
                this.wrapper.completed(result);
            }
        }

        public void failed(Exception e) {
            this.operationFailed(TransactionalProtocolClientImpl.getFailureResponse("failed", e.getMessage()));
        }

        public void cancelled() {
            this.operationFailed(TransactionalProtocolClientImpl.getResponse("cancelled"));
        }

        synchronized void operationFailed(ModelNode response) {
            if (this.completed.compareAndSet(false, true)) {
                this.wrapper.failed(response);
            }
        }

        synchronized void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            this.wrapper.prepared(transaction, result);
        }
    }

    private static class ReadAttachmentInputStreamRequestHandler
    implements ManagementRequestHandler<ModelNode, ExecuteRequestContext> {
        static final ReadAttachmentInputStreamRequestHandler INSTANCE = new ReadAttachmentInputStreamRequestHandler();

        private ReadAttachmentInputStreamRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)102);
            final int index = input.readInt();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    ExecuteRequestContext exec = (ExecuteRequestContext)context.getAttachment();
                    ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
                    ManagementResponseHeader response = new ManagementResponseHeader(header.getVersion(), header.getRequestId(), null);
                    InputStream is = (InputStream)exec.getAttachments().getInputStreams().get(index);
                    File temp = this.copyStream(is, exec.tempDir);
                    try {
                        FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)response);
                        try {
                            output.writeByte(103);
                            output.writeInt((int)temp.length());
                            output.writeByte(104);
                            FileInputStream fis = new FileInputStream(temp);
                            try {
                                StreamUtils.copyStream((InputStream)fis, (DataOutput)output);
                                fis.close();
                            }
                            finally {
                                StreamUtils.safeClose((Closeable)fis);
                            }
                            output.writeByte(36);
                            output.close();
                        }
                        finally {
                            StreamUtils.safeClose((Closeable)output);
                        }
                    }
                    finally {
                        temp.delete();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected File copyStream(InputStream is, File tempDir) throws IOException {
            File temp = File.createTempFile("upload", "temp", tempDir);
            if (is != null) {
                FileOutputStream os = new FileOutputStream(temp);
                try {
                    StreamUtils.copyStream((InputStream)is, (OutputStream)os);
                    os.close();
                }
                finally {
                    StreamUtils.safeClose((Closeable)os);
                }
            }
            return temp;
        }
    }

    private static class HandleReportRequestHandler
    implements ManagementRequestHandler<ModelNode, ExecuteRequestContext> {
        private HandleReportRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)98);
            MessageSeverity severity = Enum.valueOf(MessageSeverity.class, input.readUTF());
            ProtocolUtils.expectHeader((DataInput)input, (int)99);
            String message = input.readUTF();
            ProtocolUtils.expectHeader((DataInput)input, (int)21);
            ExecuteRequestContext requestContext = (ExecuteRequestContext)context.getAttachment();
            OperationMessageHandler handler = requestContext.getMessageHandler();
            handler.handleReport(severity, message);
        }
    }

    private static class CompleteTxRequest
    extends AbstractManagementRequest<OperationResponse, ExecuteRequestContext> {
        private final byte status;
        private final ManagementChannelAssociation channelAssociation;

        private CompleteTxRequest(byte status, ManagementChannelAssociation channelAssociation) {
            this.status = status;
            this.channelAssociation = channelAssociation;
        }

        public byte getOperationType() {
            return 78;
        }

        public void sendRequest(final ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("sending CompleteTxRequest for %d", context.getOperationId());
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    this.sendRequestInternal((ActiveOperation.ResultHandler<OperationResponse>)resultHandler, (ManagementRequestContext<ExecuteRequestContext>)context);
                }
            }, false);
        }

        protected void sendRequest(ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("transmitting CompleteTxRequest (%s) for %d", this.status != 113, context.getOperationId());
            output.write((int)this.status);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("received response to CompleteTxRequest (%s) for %d", this.status != 113, context.getOperationId());
            ProtocolUtils.expectHeader((DataInput)input, (int)74);
            ModelNode responseNode = new ModelNode();
            responseNode.readExternal(input);
            resultHandler.done((Object)TransactionalProtocolClientImpl.createOperationResponse(responseNode, this.channelAssociation, context.getOperationId()));
        }

        private void sendRequestInternal(ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            super.sendRequest(resultHandler, context);
        }
    }

    private class ExecuteRequest
    extends AbstractManagementRequest<OperationResponse, ExecuteRequestContext> {
        private ExecuteRequest() {
        }

        public byte getOperationType() {
            return 71;
        }

        public void sendRequest(final ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("sending ExecuteRequest for %d", context.getOperationId());
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    ExecuteRequest.this.sendRequestInternal((ActiveOperation.ResultHandler<OperationResponse>)resultHandler, (ManagementRequestContext<ExecuteRequestContext>)context);
                }
            }, false);
        }

        protected void sendRequest(ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("transmitting ExecuteRequest for %d", context.getOperationId());
            ExecuteRequestContext executionContext = (ExecuteRequestContext)context.getAttachment();
            List<InputStream> streams = executionContext.getInputStreams();
            ModelNode operation = executionContext.getOperation();
            int inputStreamLength = 0;
            if (streams != null) {
                inputStreamLength = streams.size();
            }
            output.write(97);
            operation.writeExternal((DataOutput)output);
            output.write(101);
            output.writeInt(inputStreamLength);
            Boolean sendSubject = (Boolean)TransactionalProtocolClientImpl.this.channelAssociation.getAttachments().getAttachment(TransactionalProtocolClient.SEND_SUBJECT);
            if (sendSubject != null && sendSubject.booleanValue()) {
                Subject subject = ((ExecuteRequestContext)context.getAttachment()).getSerializableSubject();
                TransactionalProtocolClientImpl.writeSubject(output, subject);
            }
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<OperationResponse> resultHandler, final ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("received response to ExecuteRequest for %d", context.getOperationId());
            byte responseType = input.readByte();
            ModelNode response = new ModelNode();
            response.readExternal(input);
            boolean prepared = responseType == 75;
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            if (prepared) {
                executeRequestContext.operationPrepared(new ModelController.OperationTransaction(){

                    @Override
                    public void rollback() {
                        this.done(false);
                    }

                    @Override
                    public void commit() {
                        this.done(true);
                    }

                    private void done(boolean commit) {
                        byte status = commit ? (byte)112 : 113;
                        try {
                            TransactionalProtocolClientImpl.this.channelAssociation.executeRequest(context.getOperationId(), (ManagementRequest)new CompleteTxRequest(status, TransactionalProtocolClientImpl.this.channelAssociation));
                        }
                        catch (Exception e) {
                            resultHandler.failed((Throwable)e);
                        }
                    }
                }, response);
            } else {
                executeRequestContext.operationFailed(response);
                resultHandler.done((Object)OperationResponse.Factory.createSimple((ModelNode)response));
            }
        }

        private void sendRequestInternal(ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            super.sendRequest(resultHandler, context);
        }
    }
}

