/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.security;

import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CredentialStoreClient {
    private final CredentialStore credentialStore;
    private final String name;
    private final String alias;
    private final Class<? extends Credential> type;

    public CredentialStoreClient(CredentialStore credentialStore, String name, String alias, Class<? extends Credential> type) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"credentialStore", (Object)credentialStore);
        this.name = name;
        this.alias = alias;
        this.type = type;
        this.credentialStore = credentialStore;
    }

    public CredentialStoreClient(CredentialStore credentialStore, String name, String alias) {
        this(credentialStore, name, alias, (Class<? extends Credential>)null);
    }

    public CredentialStoreClient(CredentialStore credentialStore, String name, String alias, String className) throws ClassNotFoundException {
        this(credentialStore, name, alias, CredentialStoreClient.toClass(className, credentialStore.getClass().getClassLoader()));
    }

    private static Class<? extends Credential> toClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(className, true, classLoader);
    }

    public char[] getSecret() {
        PasswordCredential passwordCredential = (PasswordCredential)this.getCredential();
        if (passwordCredential != null) {
            if (passwordCredential.getPassword() instanceof ClearPassword) {
                return ((ClearPassword)passwordCredential.getPassword()).getPassword();
            }
            ControllerLogger.ROOT_LOGGER.log(Logger.Level.DEBUG, ControllerLogger.ROOT_LOGGER.unsupportedCredentialType(this.name, passwordCredential.getPassword().getClass().getName()));
        }
        return null;
    }

    public Credential getCredential() {
        if (this.alias == null) {
            return null;
        }
        try {
            if (this.type != null) {
                return this.credentialStore.retrieve(this.alias, this.type);
            }
            return this.credentialStore.retrieve(this.alias, PasswordCredential.class);
        }
        catch (CredentialStoreException e) {
            ControllerLogger.ROOT_LOGGER.log(Logger.Level.INFO, (Object)e);
            return null;
        }
    }

    public CredentialStore getCredentialStore() {
        return this.credentialStore;
    }

    public String getAlias() {
        return this.alias;
    }

    public Class<? extends Credential> getType() {
        return this.type;
    }
}

