/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.ConfigurationChangesCollector;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationClientException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.ServiceVerificationHelper;
import org.jboss.as.controller.ValidateModelStepHandler;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.notification.NotificationSupport;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationEntry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.InetAddressPrincipal;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.Assert;
import org.wildfly.security.manager.WildFlySecurityManager;

abstract class AbstractOperationContext
implements OperationContext {
    private static final Set<String> NON_COPIED_HEADERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("allow-resource-service-restart", "rollback-on-runtime-failure", "rollout-plan")));
    private static final Set<ControlledProcessState.State> RUNTIME_LIMITED_STATES = EnumSet.of(ControlledProcessState.State.RELOAD_REQUIRED, ControlledProcessState.State.RESTART_REQUIRED);
    static final ThreadLocal<Thread> controllingThread = new ThreadLocal();
    static final String INTERNAL_MODEL_VALIDATION_NAME = "internal-model-validation";
    final Thread initiatingThread;
    private final EnumMap<OperationContext.Stage, Deque<Step>> steps;
    private final ModelController.OperationTransactionControl transactionControl;
    final ControlledProcessState processState;
    final NotificationSupport notificationSupport;
    private final boolean booting;
    private final ProcessType processType;
    private final RunningMode runningMode;
    private final Environment callEnvironment;
    private final ConfigurationChangesCollector configurationChangesCollector = ConfigurationChangesCollector.INSTANCE;
    boolean respectInterruption = true;
    private final Queue<Notification> notifications;
    private final Queue<String> missingNotificationDescriptionWarnings;
    OperationContext.Stage currentStage = OperationContext.Stage.MODEL;
    OperationContext.ResultAction resultAction;
    boolean cancelled;
    Step activeStep;
    Caller caller;
    private boolean executing;
    ModelNode initialResponse;
    private final List<ModelNode> controllerOperations = new ArrayList<ModelNode>(2);
    private boolean auditLogged;
    private final AuditLogger auditLogger;
    private final ModelControllerImpl controller;
    private final OperationStepHandler extraValidationStepHandler;
    private Map<String, OperationResponse.StreamEntry> responseStreams;
    private final Set<PathAddress> modifiedResourcesForModelValidation;

    AbstractOperationContext(ProcessType processType, RunningMode runningMode, ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, boolean booting, AuditLogger auditLogger, NotificationSupport notificationSupport, ModelControllerImpl controller, boolean skipModelValidation, OperationStepHandler extraValidationStepHandler) {
        this.processType = processType;
        this.runningMode = runningMode;
        this.transactionControl = transactionControl;
        this.processState = processState;
        this.booting = booting;
        this.auditLogger = auditLogger;
        this.notificationSupport = notificationSupport;
        this.notifications = new ConcurrentLinkedQueue<Notification>();
        this.missingNotificationDescriptionWarnings = new ConcurrentLinkedQueue<String>();
        this.controller = controller;
        this.steps = new EnumMap(OperationContext.Stage.class);
        for (OperationContext.Stage stage : OperationContext.Stage.values()) {
            if (booting && stage == OperationContext.Stage.VERIFY) {
                this.steps.put(stage, new LinkedBlockingDeque());
                continue;
            }
            this.steps.put(stage, new ArrayDeque());
        }
        this.initiatingThread = Thread.currentThread();
        this.callEnvironment = new Environment(processState, processType);
        this.modifiedResourcesForModelValidation = !skipModelValidation ? new HashSet() : null;
        this.extraValidationStepHandler = extraValidationStepHandler;
    }

    abstract ModelControllerImpl.ManagementModelImpl getManagementModel();

    abstract Resource readResourceFromRoot(ManagementModel var1, PathAddress var2, boolean var3);

    @Override
    public boolean isBooting() {
        return this.booting;
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(step, stage, false);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        ModelNode response = this.activeStep == null ? new ModelNode().setEmptyObject() : this.activeStep.response;
        this.addStep(response, operation, null, step, stage);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        ModelNode response = this.activeStep == null ? new ModelNode().setEmptyObject() : this.activeStep.response;
        this.addStep(response, operation, null, null, step, stage, addFirst);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(response, operation, null, step, stage);
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        this.addStep(this.activeStep.response, this.activeStep.operation, this.activeStep.address, null, step, stage, addFirst);
    }

    @Override
    public void addModelStep(OperationDefinition stepDefinition, OperationStepHandler stepHandler, boolean addFirst) throws IllegalArgumentException {
        this.addStep(this.activeStep.response, this.activeStep.operation, this.activeStep.address, stepDefinition, stepHandler, OperationContext.Stage.MODEL, addFirst);
    }

    @Override
    public void addModelStep(ModelNode response, ModelNode operation, OperationDefinition stepDefinition, OperationStepHandler stepHandler, boolean addFirst) throws IllegalArgumentException {
        this.addStep(response, operation, null, stepDefinition, stepHandler, OperationContext.Stage.MODEL, addFirst);
    }

    void addStep(ModelNode response, ModelNode operation, PathAddress address, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(response, operation, address, null, step, stage, false);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        this.addStep(response, operation, null, null, step, stage, addFirst);
    }

    void addStep(ModelNode response, ModelNode operation, PathAddress address, OperationDefinition stepDefinition, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        assert (this.isControllingThread());
        Assert.checkNotNullParam((String)"response", (Object)response);
        Assert.checkNotNullParam((String)"operation", (Object)operation);
        Assert.checkNotNullParam((String)"step", (Object)step);
        Assert.checkNotNullParam((String)"stage", (Object)((Object)stage));
        if (this.currentStage == OperationContext.Stage.DONE) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        if (stage.compareTo(this.currentStage) < 0) {
            throw ControllerLogger.ROOT_LOGGER.stageAlreadyComplete(stage);
        }
        if (stage == OperationContext.Stage.DOMAIN && this.processType != ProcessType.HOST_CONTROLLER && this.processType != ProcessType.EMBEDDED_HOST_CONTROLLER) {
            throw ControllerLogger.ROOT_LOGGER.invalidStage(stage, this.processType);
        }
        if (stage == OperationContext.Stage.DONE) {
            throw ControllerLogger.ROOT_LOGGER.invalidStepStage();
        }
        if (!this.booting && this.activeStep != null && this.activeStep.operation.hasDefined("operation-headers")) {
            ModelNode activeHeaders = this.activeStep.operation.get("operation-headers");
            for (Property property : activeHeaders.asPropertyList()) {
                String key = property.getName();
                if (NON_COPIED_HEADERS.contains(key)) continue;
                operation.get(new String[]{"operation-headers", key}).set(property.getValue());
            }
        }
        Deque<Step> deque = this.steps.get((Object)stage);
        if (addFirst) {
            deque.addFirst(new Step(stepDefinition, step, response, operation, address));
        } else {
            deque.addLast(new Step(stepDefinition, step, response, operation, address));
        }
        if (!this.executing && stage == OperationContext.Stage.MODEL) {
            this.recordControllerOperation(operation);
            if (this.initialResponse == null) {
                this.initialResponse = response;
            }
        }
    }

    void addBootStep(ParsedBootOp parsedBootOp) {
        this.addStep(parsedBootOp.response, parsedBootOp.operation, parsedBootOp.handler, OperationContext.Stage.MODEL);
        for (ModelNode childOp : parsedBootOp.getChildOperations()) {
            this.recordControllerOperation(childOp);
        }
    }

    @Override
    public final ModelNode getFailureDescription() {
        return this.activeStep.response.get("failure-description");
    }

    @Override
    public final boolean hasFailureDescription() {
        return this.activeStep.response.has("failure-description");
    }

    @Override
    public final ModelNode getResponseHeaders() {
        return this.activeStep.response.get("response-headers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationContext.ResultAction executeOperation() {
        assert (this.isControllingThread());
        try {
            this.executing = true;
            this.processStages();
            if (this.resultAction == OperationContext.ResultAction.KEEP) {
                this.report(MessageSeverity.INFO, ControllerLogger.ROOT_LOGGER.operationSucceeded());
            } else {
                this.report(MessageSeverity.INFO, ControllerLogger.ROOT_LOGGER.operationRollingBack());
            }
        }
        catch (RuntimeException e) {
            this.handleUncaughtException(e);
            ControllerLogger.MGMT_OP_LOGGER.unexpectedOperationExecutionException(e, this.controllerOperations);
        }
        finally {
            if (this.resultAction != OperationContext.ResultAction.KEEP && !this.isBooting()) {
                AbstractOperationContext abstractOperationContext = this;
                synchronized (abstractOperationContext) {
                    if (this.responseStreams != null) {
                        int i = 0;
                        for (OperationResponse.StreamEntry is : this.responseStreams.values()) {
                            try {
                                is.getStream().close();
                            }
                            catch (Exception e) {
                                ControllerLogger.MGMT_OP_LOGGER.debugf(e, "Failed closing stream at index %d", i);
                            }
                            ++i;
                        }
                        this.responseStreams.clear();
                    }
                }
            }
        }
        return this.resultAction;
    }

    void handleUncaughtException(RuntimeException e) {
    }

    @Override
    public final void completeStep(OperationContext.RollbackHandler rollbackHandler) {
        Assert.checkNotNullParam((String)"rollbackHandler", (Object)rollbackHandler);
        if (rollbackHandler == OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER) {
            this.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        } else {
            this.completeStep(new RollbackDelegatingResultHandler(rollbackHandler));
        }
    }

    @Override
    public final void completeStep(OperationContext.ResultHandler resultHandler) {
        Assert.checkNotNullParam((String)"resultHandler", (Object)resultHandler);
        this.activeStep.resultHandler = resultHandler;
    }

    @Override
    public final void stepCompleted() {
        this.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    @Override
    public final PathAddress getCurrentAddress() {
        assert (this.activeStep != null);
        return this.activeStep.address;
    }

    @Override
    public final String getCurrentAddressValue() {
        PathAddress pa = this.getCurrentAddress();
        if (pa.size() == 0) {
            throw new IllegalStateException();
        }
        return pa.getLastElement().getValue();
    }

    boolean stageCompleted(OperationContext.Stage stage) {
        return true;
    }

    abstract void awaitServiceContainerStability() throws InterruptedException, TimeoutException;

    abstract ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException;

    abstract void publishCapabilityRegistry();

    abstract void operationRollingBack();

    abstract void releaseStepLocks(Step var1);

    abstract void waitForRemovals() throws InterruptedException, TimeoutException;

    abstract boolean isReadOnly();

    abstract ManagementResourceRegistration getRootResourceRegistrationForUpdate();

    boolean isControllingThread() {
        return Thread.currentThread() == this.initiatingThread || controllingThread.get() == this.initiatingThread;
    }

    void logAuditRecord() {
        this.trackConfigurationChange();
        if (!this.auditLogged) {
            try {
                AccessAuditContext accessContext = SecurityActions.currentAccessAuditContext();
                Caller caller = this.getCaller();
                Subject subject = SecurityActions.getSubject(caller);
                this.auditLogger.log(this.isReadOnly(), this.resultAction, caller == null ? null : caller.getName(), accessContext == null ? null : accessContext.getDomainUuid(), accessContext == null ? null : accessContext.getAccessMechanism(), this.getSubjectInetAddress(subject), this.getModel(), this.controllerOperations);
                this.auditLogged = true;
            }
            catch (Exception e) {
                ControllerLogger.MGMT_OP_LOGGER.failedToUpdateAuditLog(e);
            }
        }
    }

    private InetAddress getSubjectInetAddress(Subject subject) {
        InetAddressPrincipal principal = this.getPrincipal(subject, InetAddressPrincipal.class);
        return principal != null ? principal.getInetAddress() : null;
    }

    private <T extends Principal> T getPrincipal(Subject subject, Class<T> clazz) {
        if (subject == null) {
            return null;
        }
        Set<T> principals = subject.getPrincipals(clazz);
        assert (principals.size() <= 1);
        if (principals.isEmpty()) {
            return null;
        }
        return (T)((Principal)principals.iterator().next());
    }

    private void recordControllerOperation(ModelNode operation) {
        this.controllerOperations.add(operation.clone());
    }

    void trackConfigurationChange() {
        if (!this.isBooting() && !this.isReadOnly() && this.configurationChangesCollector.trackAllowed()) {
            try {
                AccessAuditContext accessContext = SecurityActions.currentAccessAuditContext();
                Caller currentCaller = this.getCaller();
                Subject subject = SecurityActions.getSubject(currentCaller);
                this.configurationChangesCollector.addConfigurationChanges(new ConfigurationChangesCollector.ConfigurationChange(this.resultAction, currentCaller == null ? null : currentCaller.getName(), accessContext == null ? null : accessContext.getDomainUuid(), accessContext == null ? null : accessContext.getAccessMechanism(), this.getSubjectInetAddress(subject), this.controllerOperations));
            }
            catch (Exception e) {
                ControllerLogger.MGMT_OP_LOGGER.failedToUpdateAuditLog(e);
            }
        }
    }

    abstract Resource getModel();

    RuntimeCapabilityRegistry.RuntimeStatus getStepCapabilityStatus(Step step) {
        return RuntimeCapabilityRegistry.RuntimeStatus.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStages() {
        ModelNode primaryResponse = null;
        do {
            boolean exit;
            Throwable toThrow;
            block16: {
                Step step;
                if ((step = this.steps.get((Object)this.currentStage).pollFirst()) == null) {
                    if (this.currentStage == OperationContext.Stage.MODEL && this.addModelValidationSteps()) continue;
                    if (!this.tryStageCompleted(this.currentStage)) {
                        this.resultAction = OperationContext.ResultAction.ROLLBACK;
                        this.executeResultHandlerPhase(null);
                        return;
                    }
                    if (!this.currentStage.hasNext()) continue;
                    this.currentStage = this.currentStage.next();
                    if (this.currentStage != OperationContext.Stage.VERIFY) continue;
                    try {
                        this.awaitServiceContainerStability();
                    }
                    catch (InterruptedException e) {
                        this.cancelled = true;
                        this.handleContainerStabilityFailure(primaryResponse, e);
                        this.executeResultHandlerPhase(null);
                        return;
                    }
                    catch (TimeoutException te) {
                        this.handleContainerStabilityFailure(primaryResponse, te);
                        this.executeResultHandlerPhase(null);
                        return;
                    }
                }
                if (primaryResponse == null) {
                    primaryResponse = step.response;
                }
                toThrow = null;
                exit = false;
                try {
                    RuntimeCapabilityRegistry.RuntimeStatus stepStatus = this.getStepExecutionStatus(step);
                    if (stepStatus == RuntimeCapabilityRegistry.RuntimeStatus.NORMAL) {
                        this.executeStep(step);
                        break block16;
                    }
                    String header = stepStatus == RuntimeCapabilityRegistry.RuntimeStatus.RESTART_REQUIRED ? "operation-requires-restart" : "operation-requires-reload";
                    step.response.get(new String[]{"response-headers", header}).set(true);
                }
                catch (Error | RuntimeException re) {
                    try {
                        this.resultAction = OperationContext.ResultAction.ROLLBACK;
                        toThrow = re;
                        if (toThrow != null || !this.canContinueProcessing()) {
                            this.executeResultHandlerPhase(toThrow);
                            exit = true;
                        }
                    }
                    catch (Throwable throwable) {
                        if (toThrow != null || !this.canContinueProcessing()) {
                            this.executeResultHandlerPhase(toThrow);
                            exit = true;
                        }
                        throw throwable;
                    }
                }
            }
            if (toThrow != null || !this.canContinueProcessing()) {
                this.executeResultHandlerPhase(toThrow);
                exit = true;
            }
            if (!exit) continue;
            return;
        } while (this.currentStage != OperationContext.Stage.DONE);
        assert (primaryResponse != null);
        this.executeDoneStage(primaryResponse);
    }

    private RuntimeCapabilityRegistry.RuntimeStatus getStepExecutionStatus(Step step) {
        String attrName;
        AttributeAccess aa;
        String opName;
        if (this.booting || this.currentStage != OperationContext.Stage.RUNTIME || !RUNTIME_LIMITED_STATES.contains((Object)this.processState.getState()) || step.operationDefinition != null && (step.operationDefinition.getFlags().contains((Object)OperationEntry.Flag.READ_ONLY) || step.operationDefinition.getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY))) {
            return RuntimeCapabilityRegistry.RuntimeStatus.NORMAL;
        }
        ManagementResourceRegistration mrr = step.getManagementResourceRegistration(this.getManagementModel());
        if (mrr.isRuntimeOnly()) {
            return RuntimeCapabilityRegistry.RuntimeStatus.NORMAL;
        }
        String string = opName = step.operationDefinition != null ? step.operationDefinition.getName() : null;
        if (("write-attribute".equals(opName) || "undefine-attribute".equals(opName)) && step.operation.hasDefined("name") && (aa = mrr.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attrName = step.operation.get("name").asString())) != null && aa.getStorageType() == AttributeAccess.Storage.RUNTIME) {
            return RuntimeCapabilityRegistry.RuntimeStatus.NORMAL;
        }
        return this.getStepCapabilityStatus(step);
    }

    private boolean tryStageCompleted(OperationContext.Stage currentStage) {
        boolean result;
        try {
            result = this.stageCompleted(currentStage);
        }
        catch (RuntimeException e) {
            result = false;
            if (!this.initialResponse.hasDefined("failure-description")) {
                this.initialResponse.get("failure-description").set(ControllerLogger.MGMT_OP_LOGGER.unexpectedOperationExecutionFailureDescription(e));
            }
            ControllerLogger.MGMT_OP_LOGGER.unexpectedOperationExecutionException(e, this.controllerOperations);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDoneStage(ModelNode primaryResponse) {
        Throwable toThrow = null;
        try {
            ConfigurationPersister.PersistenceResource persistenceResource = null;
            if (this.isModelAffected() && this.resultAction != OperationContext.ResultAction.ROLLBACK) {
                try {
                    persistenceResource = this.createPersistenceResource();
                }
                catch (ConfigurationPersistenceException e) {
                    ControllerLogger.MGMT_OP_LOGGER.failedToPersistConfigurationChange(e);
                    primaryResponse.get("outcome").set("failed");
                    primaryResponse.get("failure-description").set(ControllerLogger.ROOT_LOGGER.failedToPersistConfigurationChange(e.getLocalizedMessage()));
                    this.resultAction = OperationContext.ResultAction.ROLLBACK;
                    this.executeResultHandlerPhase(null);
                    this.executeResultHandlerPhase(toThrow);
                    return;
                }
            }
            final AtomicReference<OperationContext.ResultAction> ref = new AtomicReference<OperationContext.ResultAction>(this.transactionControl == null ? OperationContext.ResultAction.KEEP : OperationContext.ResultAction.ROLLBACK);
            if (this.transactionControl != null) {
                if (ControllerLogger.MGMT_OP_LOGGER.isTraceEnabled()) {
                    ControllerLogger.MGMT_OP_LOGGER.trace("Prepared response is " + this.activeStep.response);
                }
                this.transactionControl.operationPrepared(new ModelController.OperationTransaction(){

                    @Override
                    public void commit() {
                        ref.set(OperationContext.ResultAction.KEEP);
                    }

                    @Override
                    public void rollback() {
                        ref.set(OperationContext.ResultAction.ROLLBACK);
                    }
                }, primaryResponse);
            }
            this.resultAction = ref.get();
            if (persistenceResource != null) {
                if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                    persistenceResource.rollback();
                } else {
                    persistenceResource.commit();
                }
            }
            if (this.resultAction != OperationContext.ResultAction.ROLLBACK) {
                this.publishCapabilityRegistry();
            }
        }
        catch (Throwable t) {
            toThrow = t;
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
        }
        finally {
            this.executeResultHandlerPhase(toThrow);
        }
    }

    private void executeResultHandlerPhase(Throwable toThrow) {
        this.respectInterruption = false;
        try {
            this.logAuditRecord();
            this.emitNotifications();
        }
        finally {
            if (this.resultAction != OperationContext.ResultAction.KEEP) {
                this.operationRollingBack();
            }
            this.activeStep.finalizeStep(toThrow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Notification notification) {
        this.checkUndefinedNotification(notification);
        this.notifications.add(notification);
        if (this.modifiedResourcesForModelValidation != null) {
            String type;
            switch (type = notification.getType()) {
                case "attribute-value-written": 
                case "resource-added": {
                    PathAddress addr = notification.getSource();
                    Set<PathAddress> set = this.modifiedResourcesForModelValidation;
                    synchronized (set) {
                        if (!this.modifiedResourcesForModelValidation.contains(addr)) {
                            this.modifiedResourcesForModelValidation.add(addr);
                        }
                        break;
                    }
                }
                case "resource-removed": {
                    PathAddress addr = notification.getSource();
                    Set<PathAddress> set = this.modifiedResourcesForModelValidation;
                    synchronized (set) {
                        if (this.modifiedResourcesForModelValidation.contains(addr)) {
                            this.modifiedResourcesForModelValidation.remove(addr);
                        }
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitNotifications() {
        if (this.resultAction != OperationContext.ResultAction.ROLLBACK) {
            Queue<Object> queue = this.missingNotificationDescriptionWarnings;
            synchronized (queue) {
                for (String warning : this.missingNotificationDescriptionWarnings) {
                    ControllerLogger.ROOT_LOGGER.warn(warning);
                }
                this.missingNotificationDescriptionWarnings.clear();
            }
            queue = this.notifications;
            synchronized (queue) {
                if (this.notifications.isEmpty()) {
                    return;
                }
                this.notificationSupport.emit(this.notifications.toArray(new Notification[this.notifications.size()]));
                this.notifications.clear();
            }
        }
    }

    private void checkUndefinedNotification(Notification notification) {
        String type = notification.getType();
        PathAddress source = notification.getSource();
        Map<String, NotificationEntry> descriptions = this.getRootResourceRegistration().getNotificationDescriptions(source, true);
        if (!descriptions.keySet().contains(type)) {
            this.missingNotificationDescriptionWarnings.add(ControllerLogger.ROOT_LOGGER.notificationIsNotDescribed(type, source));
        }
    }

    private void addBootFailureDescription() {
        if (this.isBooting() && this.activeStep != null && this.activeStep.response.hasDefined("failure-description")) {
            this.controller.addFailureDescription(this.activeStep.operation.clone(), this.activeStep.response.get("failure-description").clone());
        }
    }

    private boolean canContinueProcessing() {
        if (Thread.currentThread().isInterrupted()) {
            this.cancelled = true;
        }
        if (this.cancelled) {
            if (this.activeStep != null) {
                this.activeStep.response.get("outcome").set("cancelled");
                this.activeStep.response.get("failure-description").set(ControllerLogger.ROOT_LOGGER.operationCancelled());
                this.activeStep.response.get("rolled-back").set(true);
                ControllerLogger.MGMT_OP_LOGGER.tracef("Rolling back on cancellation of operation %s on address %s in stage %s", this.activeStep.operationId.name, this.activeStep.operationId.address, (Object)this.currentStage);
            }
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
        } else if (this.activeStep != null && this.activeStep.hasFailed() && (this.isRollbackOnRuntimeFailure() || this.currentStage == OperationContext.Stage.MODEL || this.currentStage == OperationContext.Stage.DOMAIN)) {
            this.activeStep.response.get("outcome").set("failed");
            this.activeStep.response.get("rolled-back").set(true);
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
            ControllerLogger.MGMT_OP_LOGGER.tracef("Rolling back on failed response %s to operation %s on address %s in stage %s", new Object[]{this.activeStep.response, this.activeStep.operationId.name, this.activeStep.operationId.address, this.currentStage});
        } else if (this.activeStep != null && this.activeStep.hasFailed()) {
            ControllerLogger.MGMT_OP_LOGGER.tracef("Not rolling back on failed response %s to operation %s on address %s in stage %s", new Object[]{this.activeStep.response, this.activeStep.operationId.name, this.activeStep.operationId.address, this.currentStage});
        }
        return this.resultAction != OperationContext.ResultAction.ROLLBACK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStep(Step step) {
        block16: {
            step.predecessor = this.activeStep;
            this.activeStep = step;
            try {
                try {
                    ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(step.handler.getClass());
                    try {
                        step.handler.execute(this, step.operation);
                        if (this.isErrorLoggingNecessary() && step.hasFailed()) {
                            ControllerLogger.MGMT_OP_LOGGER.operationFailed(step.operation.get("operation"), step.operation.get("address"), step.response.get("failure-description"));
                        }
                        if (step.serviceVerificationHelper != null) {
                            this.addStep(step.serviceVerificationHelper, OperationContext.Stage.VERIFY);
                        }
                    }
                    finally {
                        step.executed = true;
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof OperationClientException)) {
                        throw t;
                    }
                    ModelNode failDesc = ((OperationClientException)OperationClientException.class.cast(t)).getFailureDescription();
                    step.response.get("failure-description").set(failDesc);
                    if (this.isErrorLoggingNecessary()) {
                        ControllerLogger.MGMT_OP_LOGGER.operationFailed(step.operation.get("operation"), step.operation.get("address"), step.response.get("failure-description"));
                        break block16;
                    }
                    ControllerLogger.MGMT_OP_LOGGER.operationFailedOnClientError(step.operation.get("operation"), step.operation.get("address"), step.response.get("failure-description"));
                }
            }
            catch (Throwable t) {
                ControllerLogger.MGMT_OP_LOGGER.operationFailed(t, step.operation.get("operation"), step.operation.get("address"));
                if (!step.hasFailed()) {
                    step.response.get("failure-description").set(ControllerLogger.ROOT_LOGGER.operationHandlerFailed(t.toString()));
                }
                step.response.get("outcome").set("failed");
                this.resultAction = this.getFailedResultAction(t);
                if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                    step.response.get("rolled-back").set(true);
                }
            }
            finally {
                this.addBootFailureDescription();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addModifiedResourcesForModelValidation(Set<PathAddress> modifiedResources) {
        if (this.modifiedResourcesForModelValidation != null) {
            Set<PathAddress> set = this.modifiedResourcesForModelValidation;
            synchronized (set) {
                this.modifiedResourcesForModelValidation.addAll(modifiedResources);
            }
        }
    }

    private boolean isErrorLoggingNecessary() {
        return this.isBooting() || this.currentStage == OperationContext.Stage.RUNTIME || this.currentStage == OperationContext.Stage.VERIFY;
    }

    private void handleContainerStabilityFailure(ModelNode response, Exception cause) {
        boolean interrupted = cause instanceof InterruptedException;
        assert (interrupted || cause instanceof TimeoutException);
        if (response != null) {
            response.get("outcome").set("cancelled");
            response.get("failure-description").set(interrupted ? ControllerLogger.ROOT_LOGGER.operationCancelled() : ControllerLogger.ROOT_LOGGER.timeoutExecutingOperation());
            response.get("rolled-back").set(true);
        }
        this.resultAction = OperationContext.ResultAction.ROLLBACK;
        this.respectInterruption = false;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private static void throwThrowable(Throwable toThrow) {
        if (toThrow != null) {
            if (toThrow instanceof RuntimeException) {
                throw (RuntimeException)toThrow;
            }
            throw (Error)toThrow;
        }
    }

    private OperationContext.ResultAction getFailedResultAction(Throwable cause) {
        if (this.currentStage == OperationContext.Stage.MODEL || this.cancelled || this.isRollbackOnRuntimeFailure() || this.isRollbackOnly() || cause != null && !(cause instanceof OperationFailedException)) {
            return OperationContext.ResultAction.ROLLBACK;
        }
        return OperationContext.ResultAction.KEEP;
    }

    @Override
    public final ProcessType getProcessType() {
        return this.processType;
    }

    @Override
    public final RunningMode getRunningMode() {
        return this.runningMode;
    }

    @Override
    public final boolean isNormalServer() {
        return this.processType.isServer() && this.runningMode == RunningMode.NORMAL;
    }

    @Override
    public final boolean isRollbackOnly() {
        return this.resultAction == OperationContext.ResultAction.ROLLBACK;
    }

    @Override
    public final void setRollbackOnly() {
        this.resultAction = OperationContext.ResultAction.ROLLBACK;
    }

    final boolean isRollingBack() {
        return this.currentStage == OperationContext.Stage.DONE && this.resultAction == OperationContext.ResultAction.ROLLBACK;
    }

    @Override
    public final void reloadRequired() {
        if (this.processState.isReloadSupported()) {
            this.activeStep.restartStamp = this.processState.setReloadRequired();
            this.activeStep.response.get(new String[]{"response-headers", "operation-requires-reload"}).set(true);
            this.getManagementModel().getCapabilityRegistry().capabilityReloadRequired(this.activeStep.address, this.activeStep.getManagementResourceRegistration(this.getManagementModel()));
        } else {
            this.restartRequired();
        }
    }

    @Override
    public final void restartRequired() {
        this.activeStep.restartStamp = this.processState.setRestartRequired();
        this.activeStep.response.get(new String[]{"response-headers", "operation-requires-restart"}).set(true);
        this.getManagementModel().getCapabilityRegistry().capabilityRestartRequired(this.activeStep.address, this.activeStep.getManagementResourceRegistration(this.getManagementModel()));
    }

    @Override
    public final void revertReloadRequired() {
        if (this.processState.isReloadSupported()) {
            if (this.activeStep.restartStamp == null) {
                return;
            }
            this.processState.revertReloadRequired(this.activeStep.restartStamp);
            if (this.activeStep.response.get("response-headers").hasDefined("operation-requires-reload")) {
                this.activeStep.response.get("response-headers").remove("operation-requires-reload");
                if (this.activeStep.response.get("response-headers").asInt() == 0) {
                    this.activeStep.response.remove("response-headers");
                }
            }
        } else {
            this.revertRestartRequired();
        }
    }

    @Override
    public final void revertRestartRequired() {
        if (this.activeStep.restartStamp == null) {
            return;
        }
        this.processState.revertRestartRequired(this.activeStep.restartStamp);
        if (this.activeStep.response.get("response-headers").hasDefined("operation-requires-restart")) {
            this.activeStep.response.get("response-headers").remove("operation-requires-restart");
            if (this.activeStep.response.get("response-headers").asInt() == 0) {
                this.activeStep.response.remove("response-headers");
            }
        }
    }

    @Override
    public final void runtimeUpdateSkipped() {
        this.activeStep.response.get(new String[]{"response-headers", "runtime-update-skipped"}).set(true);
    }

    @Override
    public final ModelNode getResult() {
        return this.activeStep.response.get("result");
    }

    @Override
    public final boolean hasResult() {
        return this.activeStep.response.has("result");
    }

    @Override
    public String attachResultStream(String mimeType, InputStream stream) {
        String domainUUID = UUID.randomUUID().toString();
        this.attachResultStream(domainUUID, mimeType, stream);
        return domainUUID;
    }

    @Override
    public synchronized void attachResultStream(String uuid, String mimeType, InputStream stream) {
        if (this.responseStreams == null) {
            this.responseStreams = new LinkedHashMap<String, OperationResponse.StreamEntry>();
        }
        this.responseStreams.put(uuid, new OperationStreamEntry(uuid, mimeType, stream));
    }

    Map<String, OperationResponse.StreamEntry> getResponseStreams() {
        return this.responseStreams;
    }

    @Override
    public final ModelNode getServerResults() {
        if (this.processType != ProcessType.HOST_CONTROLLER && this.processType != ProcessType.EMBEDDED_HOST_CONTROLLER) {
            throw ControllerLogger.ROOT_LOGGER.serverResultsAccessNotAllowed(ProcessType.HOST_CONTROLLER, this.processType);
        }
        return this.activeStep.response.get("server-groups");
    }

    private boolean hasMoreSteps() {
        boolean more;
        OperationContext.Stage stage = this.currentStage;
        boolean bl = more = !this.steps.get((Object)stage).isEmpty();
        while (!more && stage.hasNext()) {
            more = !this.steps.get((Object)(stage = stage.next())).isEmpty();
        }
        return more;
    }

    @Override
    public Caller getCaller() {
        Caller response;
        this.caller = response = SecurityActions.getCaller(this.caller);
        return response;
    }

    @Override
    public Environment getCallEnvironment() {
        return this.callEnvironment;
    }

    @Override
    public boolean isDefaultRequiresRuntime() {
        if (this.getProcessType().isServer()) {
            return this.isNormalServer();
        }
        if (this.getProcessType() == ProcessType.HOST_CONTROLLER) {
            return this.isHostCapableAddress();
        }
        return false;
    }

    private boolean isHostCapableAddress() {
        return this.activeStep.address.size() >= 2 && this.activeStep.address.getElement(0).getKey().equals("host") && this.activeStep.address.getElement(1).getKey().equals("subsystem");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addModelValidationSteps() {
        if (this.modifiedResourcesForModelValidation == null) {
            return false;
        }
        Set<PathAddress> set = this.modifiedResourcesForModelValidation;
        synchronized (set) {
            if (this.modifiedResourcesForModelValidation.size() == 0) {
                return false;
            }
            for (PathAddress address : this.modifiedResourcesForModelValidation) {
                ModelNode op = Util.createOperation(INTERNAL_MODEL_VALIDATION_NAME, address);
                this.addStep(op, ValidateModelStepHandler.getInstance(this.extraValidationStepHandler), OperationContext.Stage.MODEL);
            }
            this.modifiedResourcesForModelValidation.clear();
        }
        return true;
    }

    private static class OperationStreamEntry
    implements OperationResponse.StreamEntry {
        private final InputStream stream;
        private final String mimeType;
        private final String uuid;

        private OperationStreamEntry(String uuid, String mimeType, InputStream stream) {
            this.uuid = uuid;
            this.mimeType = mimeType;
            this.stream = stream;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public void close() throws IOException {
            StreamUtils.safeClose((Closeable)this.stream);
        }
    }

    static class OperationId {
        final PathAddress address;
        final String name;

        OperationId(ModelNode operation) {
            this(PathAddress.pathAddress(operation.get("address")), operation.hasDefined("operation") ? operation.get("operation").asString() : null);
        }

        private OperationId(PathAddress address, String name) {
            this.address = address;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperationId that = (OperationId)o;
            return this.address.equals(that.address) && !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            int result = this.address.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }

    private static class RollbackDelegatingResultHandler
    implements OperationContext.ResultHandler {
        private final OperationContext.RollbackHandler delegate;

        private RollbackDelegatingResultHandler(OperationContext.RollbackHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                this.delegate.handleRollback(context, operation);
            }
        }
    }

    class Step {
        private final Step parent;
        private final OperationDefinition operationDefinition;
        private final OperationStepHandler handler;
        private final OperationContext.Stage forStage;
        final ModelNode response;
        final ModelNode operation;
        final PathAddress address;
        final OperationId operationId;
        private Object restartStamp;
        private OperationContext.ResultHandler resultHandler;
        ServiceTarget serviceTarget;
        private ServiceVerificationHelper serviceVerificationHelper;
        private Set<ServiceName> addedServices;
        Step predecessor;
        boolean hasRemovals;
        boolean executed;
        ManagementResourceRegistration resourceRegistration;

        private Step(OperationDefinition operationDefinition, OperationStepHandler handler, ModelNode response, ModelNode operation, PathAddress address) {
            this.forStage = AbstractOperationContext.this.currentStage;
            this.parent = AbstractOperationContext.this.activeStep;
            this.operationDefinition = operationDefinition != null ? operationDefinition : (this.parent != null ? this.parent.operationDefinition : null);
            this.handler = handler;
            this.response = response;
            this.operation = operation;
            this.address = address == null ? PathAddress.pathAddress(operation.get("address")) : address;
            String opName = operation.hasDefined("operation") ? operation.require("operation").asString() : null;
            this.operationId = new OperationId(this.address, opName);
            response.get("outcome");
            this.resultHandler = OperationContext.ResultHandler.NOOP_RESULT_HANDLER;
        }

        ServiceTarget getScopedServiceTarget(ServiceTarget parent) {
            if (this.serviceTarget == null) {
                this.serviceTarget = parent.subTarget();
                this.serviceTarget.addMonitor(this.getServiceVerificationHelper().getMonitor());
            }
            return this.serviceTarget;
        }

        void serviceAdded(ServiceController<?> controller) {
            if (!this.executed) {
                this.getAddedServices().add(controller.getName());
            }
        }

        void serviceModeChanged(ServiceController<?> service) {
            assert (service.getMode() != ServiceController.Mode.REMOVE);
            if (!(this.executed || this.addedServices != null && this.addedServices.contains(service.getName()))) {
                service.addListener((ServiceListener)this.getServiceVerificationHelper());
            }
        }

        ManagementResourceRegistration getManagementResourceRegistration(ManagementModel managementModel) {
            if (this.resourceRegistration == null) {
                this.resourceRegistration = managementModel.getRootResourceRegistration().getSubModel(this.address);
            }
            return this.resourceRegistration;
        }

        private List<Step> findPathToRootStep() {
            ArrayList<Step> result = new ArrayList<Step>();
            Step current = this;
            while (current.parent != null) {
                current = current.parent;
                result.add(0, current);
            }
            result.add(this);
            return result;
        }

        private ServiceVerificationHelper getServiceVerificationHelper() {
            if (this.serviceVerificationHelper == null) {
                this.serviceVerificationHelper = new ServiceVerificationHelper();
            }
            return this.serviceVerificationHelper;
        }

        private Set<ServiceName> getAddedServices() {
            if (this.addedServices == null) {
                this.addedServices = new HashSet<ServiceName>();
            }
            return this.addedServices;
        }

        private boolean hasFailed() {
            return this.response.hasDefined("failure-description");
        }

        private void finalizeStep(Throwable toThrow) {
            block5: {
                try {
                    this.finalizeInternal();
                }
                catch (Error | RuntimeException t) {
                    if (toThrow != null) break block5;
                    toThrow = t;
                }
            }
            Step step = this.predecessor;
            while (step != null) {
                block6: {
                    try {
                        step.finalizeInternal();
                    }
                    catch (Error | RuntimeException t) {
                        if (toThrow != null) break block6;
                        toThrow = t;
                    }
                }
                step = step.predecessor;
            }
            AbstractOperationContext.throwThrowable(toThrow);
        }

        private void finalizeInternal() {
            AbstractOperationContext.this.activeStep = this;
            try {
                this.handleResult();
                if (AbstractOperationContext.this.currentStage != null && AbstractOperationContext.this.currentStage != OperationContext.Stage.DONE) {
                    AbstractOperationContext.this.currentStage = OperationContext.Stage.DONE;
                    this.response.get("outcome").set(AbstractOperationContext.this.cancelled ? "cancelled" : "failed");
                    this.response.get("rolled-back").set(true);
                    AbstractOperationContext.this.resultAction = AbstractOperationContext.this.getFailedResultAction(null);
                } else if (AbstractOperationContext.this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                    this.response.get("outcome").set(AbstractOperationContext.this.cancelled ? "cancelled" : "failed");
                    this.response.get("rolled-back").set(true);
                } else {
                    this.response.get("outcome").set(this.hasFailed() ? "failed" : "success");
                }
                if (ControllerLogger.MGMT_OP_LOGGER.isTraceEnabled() && (this.forStage == OperationContext.Stage.MODEL || this.forStage == OperationContext.Stage.DOMAIN)) {
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Final response for step handler %s handling %s in address %s is %s", new Object[]{this.handler, this.operationId.name, this.operationId.address, this.response});
                }
            }
            finally {
                AbstractOperationContext.this.releaseStepLocks(this);
                if (this.predecessor == null) {
                    AbstractOperationContext.this.currentStage = null;
                }
            }
        }

        private void handleResult() {
            this.hasRemovals = false;
            try {
                try {
                    this.rollbackAddedServices();
                }
                finally {
                    try {
                        this.invokeResultHandler();
                    }
                    finally {
                        if (this.hasRemovals) {
                            AbstractOperationContext.this.waitForRemovals();
                        }
                    }
                }
            }
            catch (Exception e) {
                String failedRollbackMessage = ControllerLogger.MGMT_OP_LOGGER.stepHandlerFailedRollback(this.handler, this.operation.asString(), this.address, e);
                ControllerLogger.MGMT_OP_LOGGER.errorf(e, failedRollbackMessage, new Object[0]);
                AbstractOperationContext.this.report(MessageSeverity.ERROR, failedRollbackMessage);
            }
        }

        private void invokeResultHandler() {
            ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(this.handler.getClass());
            try {
                this.resultHandler.handleResult(AbstractOperationContext.this.resultAction, AbstractOperationContext.this, this.operation);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
            }
        }

        private void rollbackAddedServices() {
            if (AbstractOperationContext.this.resultAction == OperationContext.ResultAction.ROLLBACK && this.addedServices != null) {
                for (ServiceName serviceName : this.addedServices) {
                    AbstractOperationContext.this.removeService(serviceName);
                }
            }
        }
    }

    static enum ContextFlag {
        ROLLBACK_ON_FAIL,
        ALLOW_RESOURCE_SERVICE_RESTART;

    }
}

